<?php
	/***********************************************************************************
	*   Filename    : register_thanks.php
    *
	*   Copyright Keysoft Pty Ltd 2009
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';


	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';
	
	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('id', $_GET, '');
	
	$transaction_id = $_GET['id'];

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<br/><h2 class="orangeheading">Change Owner / Details Payment: Complete</h2><br/>

<div class="boldtext">You have successfully completed this payment.</div>
<br/><br/>
<?php 
	//echo $transaction_id;
	//show registered pets and print certs
	if ($transaction_id != ''){
		// select transaction
		$aRequest = array();
		$aRequest['cookie_transaction_id'] = '="' . $transaction_id . '"';
		$fmrTransactions = fFMPerformFind('petsafe', 'All Fields - Web_Payments', $aRequest);
		
		if ($fmrTransactions === FALSE || $fmrTransactions["response"]["dataInfo"]["foundCount"] < 1){
			// do nothing
		} else { 
			$fmrTransaction = $fmrTransactions["response"]["data"][0];
			$pet_id = $fmrTransaction['fieldData']['_sk_pet_id'];
			$paypal_ref_no = $fmrTransaction['fieldData']['payment_reference_no'];	
			
			//get pet details
			$aRequest = array();
			$aRequest['_pk_pet_id'] = '="' . $pet_id . '"';
			
			$fmrPet = fFMPerformFind('petsafe', 'Web - Pets', $aRequest);
			$fmcPet = $fmrPet["response"]["data"][0];
			
			//get new owner id from pet record
			$owner_id = $fmcPet['fieldData']['_sk_member_id'];
			$pet_name = $fmcPet['fieldData']['Name'];
			
			//get owner name from owner record
			$aRequest = array();
			$aRequest['_pk_member_id'] = '="' . $owner_id . '"';

			$fmrOwner = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
			$fmcOwner = $fmrOwner["response"]["data"][0];
			$owner_name =  $fmcOwner['fieldData']['Title'] . ' ' .  $fmcOwner['fieldData']['Given Name'] . ' ' .  $fmcOwner['fieldData']['Last Name'];
			$owner_email =  $fmcOwner['fieldData']['Email'];
			
			?>

		<table class="tbl" width="100%" border="0" cellspacing="0" cellpadding="5">
			<tr>
				<td class="tableheader"><b>New Owner</b></td>
				<td class="tableheader"><b>Pet Name</b></td>
				<td class="tableheader"><b>PayPal Reference No.</b></td>
				<td class="tableheader"><b>&nbsp;</b></td>
				<td class="tableheader"><b>&nbsp;</b></td>
			</tr>
			<tr class="tr1_green">
			<td><?php echo '<b> Member ID. </b>' . $owner_id . ' - ' . $owner_name; ?></td>
			<td><?php echo $pet_name; ?></td>
			<td><?php echo $paypal_ref_no; ?></td>
			<td>
				<form name="form<?php echo $pet_id; ?>" method="post" action="pets_certificate.php" target="_blank">
					<input type="hidden" name="petid" value="<?php echo $pet_id; ?>" />
					<input type="hidden" name="mid" value="<?php echo $owner_id; ?>" />
					<input type="submit" name="button" value="Print Certificate" />
				</form>
			</td>
			<td>
				<form name="form<?php echo $pet_id; ?>" method="post" action="pets_certificate.php" target="_blank">
					<input type="hidden" name="petid" value="<?php echo $pet_id; ?>" />
					<input type="hidden" name="mid" value="<?php echo $owner_id; ?>" />
					<input type="hidden" name="owner_email" value="<?php echo $owner_email; ?>" />
					<input type="hidden" name="email" value="true" />
					<input type="submit" name="button" value="Email Certificate" <?php if($owner_email == ""){echo 'disabled="disabled"'; } ?> />
					
					<?php
						if($owner_email == ''){
							echo '<span style="color:red;">No email address was found.</span>';
						}else{
							echo '( ' . $owner_email . ' )';
						}
					?>
				</form>
				</td>
			</tr>
		</table>
		
		<?php
		}
	}
?>

</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>