<?php
	/***********************************************************************************
	*   Filename    : editcompany_submit.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*   29/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
 
    /************ Only allow logged in vets to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}
	
	/********************* Page Functions *********************/
	function isVetMainContact($vetId, $companyID){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_sk_vet_id eq ".$vetId." and _sk_company_id eq ".$companyID,
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );
       
		return $response;
    }

	function updateClinicDetails($id, $data){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $response = $fm->update('Companies', $id, $data);
		if (!$response['success'])
        {
            // Redirect
			var_dump($response);
			die;
        }

        return;
    }

	/********************* Page Defaults *********************/
	fDefaultParameter('companyid', $_POST, '');
	fDefaultParameter('company_name', $_POST, '');
	fDefaultParameter('company_phone', $_POST, '');
	fDefaultParameter('company_fax', $_POST, '');
	fDefaultParameter('company_weekdays', $_POST, '');
	fDefaultParameter('company_sat', $_POST, '');
	fDefaultParameter('company_sun', $_POST, '');
	fDefaultParameter('company_housecalls', $_POST, '');
	fDefaultParameter('company_emergency', $_POST, '');
	fDefaultParameter('company_special', $_POST, '');
	fDefaultParameter('company_other', $_POST, '');
	fDefaultParameter('company_email', $_POST, '');
	fDefaultParameter('company_website', $_POST, '');
	fDefaultParameter('owner_address', $_POST, '');
	fDefaultParameter('owner_suburb', $_POST, '');
	fDefaultParameter('owner_state', $_POST, '');
	fDefaultParameter('owner_postcode', $_POST, '');
	fDefaultParameter('match_mailaddr', $_POST, '');
	fDefaultParameter('mail_address', $_POST, '');
	fDefaultParameter('mail_suburb', $_POST, '');
	fDefaultParameter('mail_state', $_POST, '');
	fDefaultParameter('mail_postcode', $_POST, '');

	// get values
	$companyid = $_POST['companyid'];

	// get vet record
	// check if user is the main vet for this company
	$fmrVet = isVetMainContact( $_SESSION['VetID'] , $companyid);
	$fmcVet = $fmrVet['data']['value'][0];

	if ($fmcVet['vet_main_contact'] != 'Yes'){
		// Redirect if NOT main vet
		fRedirect('vetarea.php?err_code=NotAuthorised');
		fCleanup();
	}

	$aUpdate = array(
		'Phone' => fReformatPhones($_POST['company_phone']),
		'Fax' => fReformatPhones($_POST['company_fax']),
		'Weekdays' => $_POST['company_weekdays'],
		'Saturday' => $_POST['company_sat'],
		'Sunday' => $_POST['company_sun'],
		'House Calls' => $_POST['company_housecalls'],
		'Emergency Service' => $_POST['company_emergency'],
		'Specialities' => $_POST['company_special'],
		'Other Info' => $_POST['company_other'],
		'Email' => $_POST['company_email'],
		'Web Site' => $_POST['company_website'],
		'Street' => $_POST['owner_address'],
		'Suburb' => $_POST['owner_suburb'],
		'State' => $_POST['owner_state'],
		'Postcode' => $_POST['owner_postcode'],
	);
	if ($matchaddr == '1'){
		$aUpdate['Mailing Street'] = $_POST['owner_address'];
		$aUpdate['Mailing Suburb'] = $_POST['owner_suburb'];
		$aUpdate['Mailing State'] = $_POST['owner_state'];
		$aUpdate['Mailing Postcode'] = $_POST['owner_postcode'];		
	} else {
		$aUpdate['Mailing Street'] = $_POST['mail_address'];;
		$aUpdate['Mailing Suburb'] = $_POST['mail_suburb'];
		$aUpdate['Mailing State'] = $_POST['mail_state'];
		$aUpdate['Mailing Postcode'] = $_POST['mail_postcode'];
	}

	// update company details
	$fmrCompanyUpdate = updateClinicDetails($_POST['companyid'], $aUpdate);

	// ADD TO LOG: updated company details
	$entry = [];
	$entry = [
		"_sk_vet_id" => $_SESSION['VetID'],
		"description" => 'Updated Company details for: ' . $companyname,
		"is_web_admin_login" => isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0
	];
	makeLogEntry($entry);

	// Redirect
	fRedirect('myaccount.php');
	fCleanup();
?>
