<?php
    /***********************************************************************************
    * 	Filename    : invoice_details.php
	*   Description : Invoice detail page
	*   22/08/2022  John Muffett         Reworked for Data API
    *   29/07/2025  John Muffett         Reworked for oData API
    *
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Invoice Details';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('id', $_GET, '');

	$invoiceid = $_GET['id'];

    /************ Only allow logged in vets to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('myaccount.php?err_code=NotAuthorised');
		fCleanup();
	}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td valign="top">

<br/>

<h2 class="orangeheading">Invoice Details</h2>

<table border="0" cellpadding="2" cellspacing="0">

<?php
    /*************************** Page Start ***************************/

	// Get all invoices for this vet
	$aRequest = array();
	$aRequest['_pk_invoice_id'] = '="' . $invoiceid . '"';
   	$fmrInvoice = fFMPerformFind('petsafe', 'Web - Invoice', $aRequest);

	if ($fmrInvoice === FALSE || $fmrInvoice["response"]["dataInfo"]["foundCount"] != 1){
		echo '<p>Invoice not found.<br/><br/>&nbsp;</p>';
	} else {
		$fmcInvoice = $fmrInvoice["response"]["data"][0]['fieldData'];

		// check if invoice belongs to one of vet's companies
		$aRequest = array();
		$aRequest['_sk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
		$aRequest['_sk_company_id'] = '="' . $fmcInvoice['client_id_for_company_c'] . '"';
		$aRequest['vet_main_contact'] = '="Yes"';


		$fmrCompany = fFMPerformFind('petsafe', 'Web - Company_Vet_Relation', $aRequest);
		

		if ($fmrCompany === FALSE || $fmrCompany["response"]["dataInfo"]["foundCount"] != 1){
			echo '<p>Invoice not found.<br/><br/>&nbsp;</p>';

		} else {

			// get values
			$invoiceid = $fmcInvoice['_pk_invoice_id'];
			$invoicenumber = $fmcInvoice['invoice_no_c'];
			$company = $fmcInvoice['client_c'];
			$name = $fmcInvoice['contact_c'];
           		$implanter_id = $fmcInvoice['implanter_number_c'];
			$status = $fmcInvoice['Invoice Status'];
			$invoicedate = $fmcInvoice['Invoice Date'];
			$duedate = $fmcInvoice['cPaymentDueDate'];
			$paiddate = $fmcInvoice['invoice_paid_date'];
			$reference = $fmcInvoice['payment_reference'];
			$amount = $fmcInvoice['amount_inc_gst_c'];

			// create table
			echo '<tr><td class="boldtext">Invoice #</td><td><b>&nbsp;' . $invoicenumber . '</b></td><td class="boldtext">Invoice Status</td><td>&nbsp;' . $status . '</td></tr>';
			echo '<tr><td class="boldtext">Invoice To</td><td>&nbsp;' . $company . '</td><td class="boldtext">Invoice Paid Date</td><td>&nbsp;' . fReformatDate($paiddate) . '</td></tr>';
			echo '<tr><td class="boldtext">Invoice Date</td><td>&nbsp;' . fReformatDate($invoicedate) . '</td><td class="boldtext">Payment Reference</td><td>&nbsp;' . $reference . '</td></tr>';
			echo '<tr><td class="boldtext" valign="top">Due Date</td><td valign="top">&nbsp;' . fReformatDate($duedate) . '</td><td class="boldtext">Implanter ID</td><td>&nbsp;' . $implanter_id . ' ' . $name . '</td></tr>';
			echo '<tr><td class="boldtext" valign="top" colspan="2">&nbsp;</td>';
			if (trim(strtoupper($status)) != 'CLOSED'){
				echo '<td class="boldtext" style="text-align: right;" colspan="2">Total inc GST: $' . formatDecimal($amount) . '<br/><input type="button" value=" Pay Invoice " onclick="javascript:location.href = \'invoice_paypal.php?id=' . $invoiceid . '\';" /></td></tr>';
			} else {
				echo '<td class="boldtext" style="text-align: right;" colspan="2">Total inc GST: $' . formatDecimal($amount) . '</td></tr>';
			}

			echo '<tr><td colspan="4"><hr/></td></tr>';

			// extended invoice details go here
			$aRequest = array();
			$aRequest['_sk_invoice_id'] = '="' . $invoiceid . '"';
			$fmrInvoiceItems = fFMPerformFind('petsafe', 'Web - Invoice Items', $aRequest);
			$fmcInvoiceItems = $fmrInvoiceItems['response']['data'];
?>

	<tr><td colspan="4">
		<table border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr>
				<td style="padding: 2px 4px 2px 4px;" class="boldtext">Qty</td>
				<td style="padding: 2px 4px 2px 4px;" class="boldtext">Item Code</td>
				<td style="padding: 2px 4px 2px 4px;" class="boldtext">Description</td>
				<td style="padding: 2px 4px 2px 4px;" class="boldtext">Member No</td>
				<td style="padding: 2px 4px 2px 4px;" class="boldtext">Member Name</td>
				<td style="padding: 2px 4px 2px 4px;" class="boldtext">Pet Name</td>
				<td style="padding: 2px 4px 2px 4px;" class="boldtext">Chip No</td>
				<td style="padding: 2px 4px 2px 4px;" align="right" class="boldtext">Price/Item</td>
				<td style="padding: 2px 4px 2px 4px;" align="right" class="boldtext">Item Total</td>
				<td style="padding: 2px 4px 2px 4px;" align="right" class="boldtext">Item Total inc GST</td>
			</tr>

<?php
		foreach ($fmcInvoiceItems as $item){
			echo '<tr>';
			echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Qty'] . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['item_code'] . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Description'] . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['_sk_member_id'] . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Member Full Name'] . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Pet Name'] . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Chip No'] . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;" align="right">$' . formatDecimal($item['fieldData']['Amount']) . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;" align="right">$' . formatDecimal($item['fieldData']['cAmount']) . '</td>';
			echo '<td style="padding: 2px 4px 2px 4px;" align="right">$' . formatDecimal($item['fieldData']['cAmountIncGST']) . '</td>';
			echo '</tr>';
		}
?>

		</table>
	</td></tr>

<?php

		echo '<tr><td colspan="4"><hr/></td></tr>';
		echo '<tr><td colspan="4">&nbsp;</td></tr>';
		}
	}
?>

</table>

<form name="print" method="post" action="invoice_print.php" target="_blank">
	<input class="boldtext" type="submit" name="print" value="Print Invoice" />
	<input type="hidden" name="invoiceid" value="<?php echo $invoiceid ?>" />
</form>
<br/><br/>
<div class="boldtext"><a href="invoice_list.php">Return to Invoice List</a></div>
<br/><br/>

<?php
/************************* Page End **************************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>