<?php

	/******************** Global Settings ********************/

	require_once '../phpobjects/common/global.php';


    /********************* Page Defaults *********************/

	fDefaultParameter('invoiceid', $_POST, '');
	$invoiceid = $_POST['invoiceid'];
	$email = $_POST['email'];

	// accept valid input
	if (trim($invoiceid) == ''){

		// Redirect
		fRedirect('index.php');
		fCleanup();
	}


	/****************** Fetch Invoice details  ******************/

	// Get all invoices for this vet
	$aRequest = array();
	$aRequest['_pk_invoice_id'] = '="' . $invoiceid . '"';
   	$fmrInvoice = fFMPerformFind('petsafe', 'Web - Invoice', $aRequest);

	if ($fmrInvoice === FALSE || $fmrInvoice["response"]["dataInfo"]["foundCount"] != 1){
		fRedirect('invoice_list.php');
		fCleanup();
	} 
	
	$fmcInvoice = $fmrInvoice["response"]["data"][0];

	// check if invoice belongs to one of vet's companies
	$aRequest = array();
	$aRequest['_sk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
	$aRequest['_sk_company_id'] = '="' . $fmcInvoice['fieldData']['client_id_for_company_c'] . '"';
	$aRequest['vet_main_contact'] = '="Yes"';

	$fmrCompany = fFMPerformFind('petsafe', 'All Fields - Company_Vet_Relation', $aRequest);

	if ($fmrCompany === FALSE || $fmrCompany["response"]["dataInfo"]["foundCount"] != 1){
		fRedirect('invoice_list.php');
		fCleanup();
	} 
		
	// get values
	$invoiceid = $fmcInvoice['fieldData']['_pk_invoice_id'];
	$invoicenumber = $fmcInvoice['fieldData']['invoice_no_c'];
	$company = $fmcInvoice['fieldData']['client_c'];
	$name = $fmcInvoice['fieldData']['contact_c'];
	$implanter_id = $fmcInvoice['fieldData']['implanter_number_c'];
	$status = $fmcInvoice['fieldData']['Invoice Status'];
	$invoicedate = $fmcInvoice['fieldData']['Invoice Date'];
	$duedate = $fmcInvoice['fieldData']['cPaymentDueDate'];
	$paiddate = $fmcInvoice['fieldData']['invoice_paid_date'];
	$reference = $fmcInvoice['fieldData']['payment_reference'];
	$amount = $fmcInvoice['fieldData']['amount_inc_gst_c'];


	// extended invoice details go here
	$aRequest = array();
	$aRequest['_sk_invoice_id'] = '="' . $invoiceid . '"';
	$fmrInvoiceItems = fFMPerformFind('petsafe', 'Web - Invoice Items', $aRequest);
	$fmcInvoiceItems = $fmrInvoiceItems["response"]["data"];

	/********************** Start Output Buffering ***********/
	ob_start();

?>

<html>

<head>

	<style>
		.mainheading {
			font-family: Arial;
			font-weight: bold;
			font-size: 25;
		}

		.heading {
			font-family: Arial;
			font-weight: bold;
			font-size: 13;
		}

		p {
			font-family: Arial;
			font-weight: normal;
			font-size: 8;
		}

		td {
			font-family: Arial;
			font-weight: normal;
			font-size: 8;
		}

		.smalltext {
			font-family: Arial;
			font-weight: normal;
			font-size: 7;
		}

		.details {
			font-family: Arial;
			font-weight: bold;
			font-size: 10;
		}
	</style>

</head>

<body>

<pageheader>

	<table border="0" cellpadding="0" cellspacing="0" width="100%">
		<tr>
			<td colspan="1">
				<p class="mainheading">Petsafe<sup>&reg;</sup> Invoice</p>
			</td>
			<td>
				<img src="/images/girl_puppy_sm.jpg" align="right" />
			</td>
		</tr>
	</table>

	<table border="0" cellpadding="0" cellspacing="0" width="100%">
		<tr>
			<td class="boldtext">Invoice #</td>
			<td><b><?php echo($invoicenumber); ?></b></td>
		</tr>
		<tr>
			<td class="boldtext">Invoice Status</td>
			<td><?php echo($status); ?></td>
		</tr>
		<tr>
			<td class="boldtext">Invoice To</td>
			<td><?php echo($company); ?></td>
		</tr>
		<tr>
			<td class="boldtext">Invoice Paid Date</td>
			<td><?php echo(fReformatDate($paiddate)); ?></td>
		</tr>
		<tr>
			<td class="boldtext">Invoice Date</td>
			<td><?php echo(fReformatDate($invoicedate)); ?></td>
		</tr>
		<tr>
			<td class="boldtext">Payment Reference</td>
			<td><?php echo($reference); ?></td>
		</tr>
		<tr>
			<td class="boldtext" valign="top">Due Date</td>
			<td valign="top"><?php echo (fReformatDate($duedate));?></td>
		</tr>
		<tr>
			<td class="boldtext">Implanter ID</td>
			<td><?php echo ($implanter_id . ' ' . $name); ?></td>
		</tr>
	</table>

</pageheader>

<br/>
<br/>


<table border="0" cellpadding="0" cellspacing="0" width="100%">
	<tr>
			<td style="padding: 2px 4px 2px 4px;" class="boldtext">Qty</td>
			<td style="padding: 2px 4px 2px 4px;" class="boldtext">Item Code</td>
			<td style="padding: 2px 4px 2px 4px;" class="boldtext">Description</td>
			<td style="padding: 2px 4px 2px 4px;" class="boldtext">Member No</td>
			<td style="padding: 2px 4px 2px 4px;" class="boldtext">Member Name</td>
			<td style="padding: 2px 4px 2px 4px;" class="boldtext">Pet Name</td>
			<td style="padding: 2px 4px 2px 4px;" class="boldtext">Chip No</td>
			<td style="padding: 2px 4px 2px 4px;" align="right" class="boldtext">Price/Item</td>
			<td style="padding: 2px 4px 2px 4px;" align="right" class="boldtext">Item Total</td>
			<td style="padding: 2px 4px 2px 4px;" align="right" class="boldtext">Item Total inc GST</td>
	</tr>
	<tr>
		<td colspan="10"><hr/></td>
	</tr>
<?php
	foreach ($fmcInvoiceItems as $item){
		echo '<tr>';
		echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Qty'] . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['item_code'] . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Description'] . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['_sk_member_id'] . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Member Full Name'] . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Pet Name'] . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;">' . $item['fieldData']['Chip No'] . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;" align="right">$' . formatDecimal($item['fieldData']['Amount']) . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;" align="right">$' . formatDecimal($item['fieldData']['cAmount']) . '</td>';
		echo '<td style="padding: 2px 4px 2px 4px;" align="right">$' . formatDecimal($item['fieldData']['cAmountIncGST']) . '</td>';
		echo '</tr>';
	}
?>
</table>

<table border="0" cellpadding="0" cellspacing="0" width="100%">
		<tr>
			<td colspan="4"><hr/></td>
		</tr>
		<tr>
			<td class="boldtext" style="padding: 2px 4px 2px 4px; text-align: right;" colspan="3">Total inc GST:</td>
			<td class="boldtext" style="padding: 2px 4px 2px 4px; text-align: right;" colspan="1">$<?php echo(formatDecimal($amount)); ?></td>
		</tr>
		<tr>
			<td colspan="4"><hr/></td>
		</tr>
</table>

</body>

</html>

<?php

	require_once '../phpobjects/common/pdf_print.php';

	if($email == true){
		//email_invoice_from_buffer('PetsafeInvoice.pdf');
	}else{
		generate_invoice_from_buffer('PetsafeInvoice_'.$invoiceid);	
	}

	// Cleanup
	fCleanup();

?>
