<?php
	/***********************************************************************************
	*   Filename    : register_thanks.php
	*
	*   Copyright Keysoft Pty Ltd 2009
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	
	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('id', $_GET, '');
	fDefaultParameter('newuser', $_GET, 'false');

	$cookieid = $_GET['id'];
	$newuser = $_GET['newuser'];

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
	<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php
require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<br/><h2 class="greenheading">New Registration: Complete</h2><br/>

<div class="boldtext">Congratulations, you have successfully registered your pet(s) on the PetSafe database.</div>
<div>

<?php
$owner_email = '';

// show new user login details
if ($newuser == 'true' and $_SESSION['MemberID'] != ''){
	$aRequest = array();
	$aRequest['_pk_member_id'] = '="' . $_SESSION['MemberID'] . '"';
	$fmrOwner = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
	$fmcOwner = $fmrOwner["response"]["data"][0];
	$owner_password = $fmcOwner['fieldData']['Password'];
	$owner_email = $fmcOwner['fieldData']['Email'];
	echo '<br/>Your login details are as follows:<br/>';
	echo '<b>Member ID:</b> PS' . $_SESSION['MemberID'] . '<br/>';
	echo '<b>Password:</b> (as per registration)';
	if ($owner_email != ''){
		echo '<br/><br/>Your PetSafe login details have also been sent to the email address provided - <b>' . $owner_email . '</b>.';
	}
}
?>
</div>
<br/>
<div>
<?php
// show registered pets and print certs
if ($cookieid != ''){
	// select transaction
	$aRequest = array();
	$aRequest['cookie_transaction_id'] = '="' . $cookieid . '"';
	$fmrTransactions = fFMPerformFind('petsafe', 'All Fields - Web_Payments', $aRequest);
	if ($fmrTransactions === FALSE || $fmrTransactions["response"]["dataInfo"]["foundCount"] < 1){
		// do nothing
	} else {
		$registeredPets = array(); 
		
		echo '<table class="tbl" width="100%" border="0" cellspacing="0" cellpadding="5">';
		echo '<tr>';
		echo '<td class="tableheader"><b>Owner</b></td>';
		echo '<td class="tableheader"><b>Pet Name</b></td>';
		echo '<td class="tableheader"><b>&nbsp;</b></td>';
		echo '</tr>';

		$fmcTransaction = $fmrTransactions["response"]["data"];
		$rowstyle = '';
		//$owner_emails = array();
		foreach ($fmcTransaction as $trans_record){
			// show pets

			//get pet name from record
			$pet_name = $trans_record['fieldData']['pet_name'];
			$registeredPets[] = $pet_name; 
			//get pet id from record and retrieve pet details
			$petid = $trans_record['fieldData']['_sk_pet_id'];

			$aRequest = array();
			$aRequest['_pk_pet_id'] = '="' . $petid . '"';
			$fmrPet = fFMPerformFind('petsafe', 'Web - Pets', $aRequest);
			$fmcPet = $fmrPet["response"]["data"][0];
            
			//get owner id from pet record
			$ownerid = $fmcPet['fieldData']['_sk_member_id'];
			//get owner name from owner record
			$aRequest = array();
			$aRequest['_pk_member_id'] = '="' . $ownerid . '"';

			$fmrOwner = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
			$fmcOwner = $fmrOwner["response"]["data"][0];
			$owner_name =  $fmcOwner['fieldData']['Title'] . ' ' .  $fmcOwner['fieldData']['Given Name'] . ' ' .  $fmcOwner['fieldData']['Last Name'];
			
			$owner_email = $fmcOwner['fieldData']['Email'];

			if ($rowstyle == 'tr1_green'){
				$rowstyle = '';
			} else {
				$rowstyle = 'tr1_green';
			}
            
			echo '<tr class="' . $rowstyle . '">';
			echo '<td>' . $owner_name . '</td>';
			echo '<td>' . $pet_name . '</td>';
			echo '<td><form name="form' . $petid . '" method="post" action="pets_certificate.php" target="_blank">';
			echo '<input type="submit" name="print" value="Print Certificate" />';
			if($owner_email != "") {
				echo '<input type="submit" name="email" value="Email Certificate"/>';
			}
			echo '<input type="hidden" name="petid" value="' . $petid . '" />';
			echo '<input type="hidden" name="mid" value="' . $ownerid . '" />';
			echo '</form></td>';
			echo '</tr>';
			

		}
		echo '</table>';
		
	}
}
?>
</div>
<br/><br/>

</td>

<td valign="top">
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/cockatoo_help.jpg" />&nbsp;</div>
</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>

<?php 
	fCleanup(); 
?>