<?php
	/********************* Session Scope *********************/
	session_set_cookie_params(1200);
    session_name('keysoftpetsafedigivet');
    session_start();

	/******************** Initialise the session ********************/
	if (!array_key_exists("DateInitialised", $_SESSION) or array_key_exists("init_session", $_GET))
	{
		init_session();
	}

	function init_session(){
		// Defaults
		$_SESSION['ShowDebugOutput']        = false;   // Show Debug Output

		//Session vars for members
		$_SESSION['LoggedIn']				= 0;		// Logged in or not
		$_SESSION['MemberID']				= '';		// ID of the logged in member/owner
		$_SESSION['VetID']					= '';		// ID of the logged in vet/employee
		$_SESSION['IsAdminLogin']           = 0;		// If logged in via the admin password
		$_SESSION['VetAllowSearch']			= '';		// Vet-specific field to see if search for chips function is enabled or disabled
		$_SESSION['cookieid']				= '';		// Cookie ID - used for registrations

		// Date Initialised
		$_SESSION['DateInitialised']        = date("d/m/Y H:i:s", time());
	}

    // Reset the expiration time upon page load - add 20 min
    if (isset($_COOKIE['keysoftpetsafedigivet']))
      setcookie('keysoftpetsafedigivet', $_COOKIE['keysoftpetsafedigivet'], time() + 1200, "/");
?>