<?php

	/***********************************************************************************
	*   Copyright Keysoft Pty Ltd 2009
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';

	/********************* Page Defaults *********************/
	fDefaultParameter('err_code',  $_GET, '');
	fDefaultParameter('chip_id',   $_GET, '');
	fDefaultParameter('t',   $_GET, '');

	// get values
	$chip_id = $_GET['chip_id'];
	$transaction = $_GET['t'];

	$aRequest = array();
	$aRequest['_pk_chip_id'] = '="' . $chip_id . '"';

	$fmrChip = fFMPerformFind('petsafe', 'Web - Chips', $aRequest);

	/************ Check for not found or duplicate ************/
	if ($fmrChip === FALSE || $fmrChip["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Redirect if tag found but linked chip not found
		fRedirect('index.php?err_code=ChipNotFound#chipsearch');
		fCleanup();
	}
	$fmcChip = $fmrChip["response"]["data"][0];

	// Get the pet details
	$aRequest = array();
	$aRequest['_pk_pet_id'] = '="' . $fmcChip['fieldData']['_sk_pet_id'] . '"';

	$fmrPet = fFMPerformFind('petsafe', 'Web - Pets', $aRequest);

	/************ Check for not found or duplicate ************/
	if ($fmrPet === FALSE || $fmrPet["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Redirect if tag found but linked chip not found
		fRedirect('index.php?err_code=PetNotFound#chipsearch');
		fCleanup();
	}

	$fmcPet = $fmrPet["response"]["data"][0];
	$member_id = $fmcPet['fieldData']['_sk_member_id'];
	$pet_id    = $fmcChip['fieldData']['_sk_pet_id'];
	
	// Get the owner details
	//FIND FUTURE OWNER INFO, THE NEW OWNER ID IS SAVED IN THE WEB PAYMENTS TABLE
	$aRequest = array();
	$aRequest['cookie_transaction_id'] = '="' . $transaction . '"';
	
	$fmrTransaction = fFMPerformFind('petsafe', 'All Fields - Web_Payments', $aRequest);
	
	if ($fmrTransaction === FALSE || $fmrTransaction["response"]["dataInfo"]["foundCount"] < 1){
		// invalid transaction
		fRedirect('index.php?err_code=OwnerNotFound#chipsearch');
		fCleanup();
	}else{
		$fmrTransactionRecord = $fmrTransaction["response"]["data"][0];
		$new_owner_id = $fmrTransactionRecord['fieldData']['_sk_member_id'];
	}
	
	$aRequest = array();
	$aRequest['_pk_member_id'] = '="' . $new_owner_id . '"';

	$fmrOwner = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
	/************ Check for not found or duplicate ************/
	if ($fmrOwner === FALSE || $fmrOwner["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Redirect if tag found but linked chip not found
		fRedirect('index.php?err_code=OwnerNotFound#chipsearch');
		fCleanup();
	}
	$fmcOwner = $fmrOwner["response"]["data"][0];

	// Select the charges
	$aRequest = array();
	$aRequest['Change Fee'] = '=="Yes"';
	$fmrPrice = fFMPerformFind('petsafe', 'All Fields - Item_Type', $aRequest);
	// Check found
	if ($fmrPrice === FALSE || $fmrPrice["response"]["dataInfo"]["foundCount"] <= 0)
	{
		// No fees, so return to the account page
		fRedirect('myaccount.php');
	}
	$fmcPrice = $fmrPrice["response"]["data"][0];
	$initial_amount = $fmcPrice['fieldData']['price'];

	$name = $fmcOwner['fieldData']['Given Name'] . ' ' . $fmcOwner['fieldData']['Last Name'];
	$address = $fmcOwner['fieldData']['Street'];
	$city = $fmcOwner['fieldData']['Suburb'];
	$state = $fmcOwner['fieldData']['State'];
	$postcode = $fmcOwner['fieldData']['Postcode'];
	$country = 'AU';
	$phone = $fmcOwner['fieldData']['Home Phone'];
	$email = $fmcOwner['fieldData']['Email'];
	
    // Get details of person logged in (person doing payent)
    $payer_name = '';
    $payer_phone = '';
    $payer_email = '';
    $payer_city = '';
    $payer_state = '';
    $payer_postcode = '';
    $payer_address = '';
    $payer_country = $country;
    
    if($_SESSION['VetID'] != ''){
	    $aRequest = array();
	    $aRequest['_pk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
	    $fmrPayer = fFMPerformFind('petsafe', 'All Fields - Vet', $aRequest);
	    
	    if ($fmrPayer === FALSE || $fmrPayer["response"]["dataInfo"]["foundCount"] != 1){
			// payer vet not found
			fRedirect('invoice_list.php');
			fCleanup();
	    }else{
	        $fmcPayer = $fmrPayer["response"]["data"][0];
	        
	        $payer_name = $fmcPayer['fieldData']['vet_first_name'] . ' ' . $fmcPayer['fieldData']['vet_last_name'];
	        $payer_phone = $fmcPayer['fieldData']['vet_phone'];
	        $payer_email = $fmcPayer['fieldData']['vet_email'];
	        $payer_city = $fmcPayer['fieldData']['vet_mailing_suburb'];
	        $payer_state = $fmcPayer['fieldData']['vet_mailing_state'];
	        $payer_postcode = $fmcPayer['fieldData']['vet_mailing_postcode'];
	        $payer_address = $fmcPayer['fieldData']['vet_mailing_street'];
	        $payer_country = $country;
	    }
    }
	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<script>
	function validate_amount(){
		var amount = document.getElementById('amount').value;
		
		if(amount <= 0){
			var frm_no_fee = document.getElementById('frmNoFee');
			frm_no_fee.submit();
			return false;
		}
		
		return true;
	}
	
	function set_amount(item_e){
		var amount = item_e.selectedOptions[0].getAttribute("data-value");
		document.getElementById('amount').value = amount;
	}
	
	function set_description(item_e){
		var description = item_e.selectedOptions[0].getAttribute("data-description");
		document.getElementById('description').value = description;
	}
</script>

</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<br/><h2 class="greenheading">Change Owner / Details: Payment</h2><br/>

<form method="POST" name="frmPayment" action="https://pilot-payflowlink.paypal.com" onsubmit="return validate_amount();">
<table class="tbl" width="100%" border="0" cellspacing="0" cellpadding="5">
<tr>
	<td><b>Owner</b></td>
	<td><?php echo $fmcOwner['fieldData']['Title'] . ' ' . $fmcOwner['fieldData']['Given Name'] . ' ' . $fmcOwner['fieldData']['Last Name']; ?></td>
</tr>
<tr>
	<td><b>Charge Type</b></td>
	<td><select name="USER4" onchange="set_amount(this); set_description(this);"><?php
		$fmacPrice = $fmrPrice["response"]["data"];
		foreach ($fmacPrice as $fmcPrice)
		{
			echo '<option value="'.htmlspecialchars($fmcPrice['fieldData']['item_code']).'" data-value="' .$fmcPrice['fieldData']['price']  . '" data-description="' . htmlspecialchars($fmcPrice['fieldData']['item_description']) . '">'.htmlspecialchars($fmcPrice['fieldData']['item_description']).'</option>';
		}
	?></select></td>
</tr>
<tr>
	<td><b>Amount</b></td>
	<td><input type="text" name="AMOUNT" id="amount" value="<?php echo $initial_amount; ?>" align="right" size="8"/></td>
</tr>
</table>

<br/>

<table width="100%" border="0">
<tr>
<td align="right">
	<input type="hidden" name="LOGIN" value="PetsafeF"/>
	<input type="hidden" name="PARTNER" value="VSA"/>
	<input type="hidden" name="TYPE" value="S"/>
	<input type="hidden" name="DESCRIPTION" id="description" value="<?php echo 'MemberID:' . $new_owner_id; ?>"/>
	<input type="hidden" name="NAME" value="<?php echo $payer_name; ?>">
    <input type="hidden" name="ADDRESS" value="<?php echo $payer_address; ?>"/>
    <input type="hidden" name="CITY" value="<?php echo $payer_city; ?>"/>
    <input type="hidden" name="ZIP" value="<?php echo $payer_postcode; ?>"/>
	<input type="hidden" name="PHONE" value="<?php echo $payer_phone; ?>"/>
	<input type="hidden" name="EMAIL" value="<?php echo $payer_email; ?>"/>
<!--
	<input type="hidden" name="NAMETOSHIP" value="<?php echo $name; ?>"/>
	<input type="hidden" name="ADDRESSTOSHIP" value="<?php echo $address; ?>"/>
	<input type="hidden" name="CITYTOSHIP" value="<?php echo $city; ?>"/>
	<input type="hidden" name="STATETOSHIP" value="<?php echo $state; ?>"/>
	<input type="hidden" name="ZIPTOSHIP" value="<?php echo $postcode; ?>"/>
	<input type="hidden" name="COUNTRYTOSHIP" value="<?php echo $country; ?>"/>
-->
	<input type="hidden" name="USER1" value=""/>
	<input type="hidden" name="USER2" value=""/>
	<input type="hidden" name="USER3" value="<?php echo $chip_id; ?>"/>
	<input type="hidden" name="USER5" value="<?php echo $transaction; ?>"/>
	<input type="hidden" name="METHOD" value="CC"/>
	<input type="hidden" name="ECHODATA" value="True"/>
	<input type="hidden" name="VERBOSITY" value="HIGH"/>
	<input type="submit" value="Click Here to Purchase"/>
	<div class="smalltext"><b>Credit Card payment is processed securely by Verisign.</b></div>
</td>
</tr>
</table>
</form>

<form method="post" name="frmNoFee" id="frmNoFee" action="chip_owner_paid.php" style="display:none;">
	<input type="hidden" name="chip_id" value="<?php echo $chip_id; ?>" />
	<input type="hidden" name="transaction_id" value="<?php echo $transaction; ?>" />
</form>

<br><br>

</td>

<td valign="top">
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/cockatoo_help.jpg" />&nbsp;</div>
</td>

<?php
/************************ Page End ***********************/
require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>
