<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*   29/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';


    /************ Only allow logged in vets to this area ************/
	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}
	
	/********************* Page Functions *********************/
	function updateVetDetails($id, $data){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $response = $fm->update('Vet', $id, $data);
		if (!$response['success'])
        {
            // Redirect
			var_dump($response);
			die;
        }

        return;
    }

	function makeLogEntry($data){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $response = $fm->create('Audit', $data);
        return;
    }
	/********************* Page Defaults *********************/
	fDefaultParameter('vetid', $_POST, '');
	fDefaultParameter('vet_title', $_POST, '');
	fDefaultParameter('vet_firstname', $_POST, '');
	fDefaultParameter('vet_lastname', $_POST, '');
	fDefaultParameter('vet_direct', $_POST, '');
	fDefaultParameter('vet_fax', $_POST, '');
	fDefaultParameter('vet_emergency', $_POST, '');
	fDefaultParameter('vet_password1', $_POST, '');
	fDefaultParameter('vet_email', $_POST, '');
	fDefaultParameter('vet_address', $_POST, '');
	fDefaultParameter('vet_suburb', $_POST, '');
	fDefaultParameter('vet_state', $_POST, '');
	fDefaultParameter('vet_postcode', $_POST, '');

	// get values
	$vetid = $_POST['vetid'];

	// ensure logged-in user is updating their own details
	if ($_SESSION['VetID'] != $vetid){
		// Redirect if not authorised to update
		fRedirect('myaccount.php');
		fCleanup();
	}

	// update vet details
	$aUpdate = array(
		'vet_title' => $_POST['vet_title'],
		'vet_first_name' => $_POST['vet_firstname'],
		'vet_last_name' => $_POST['vet_lastname'],
		'vet_phone' => fReformatPhones($_POST['vet_direct']),
		'vet_fax' => fReformatPhones($_POST['vet_fax']),
		'vet_emergency' => fReformatPhones($_POST['vet_emergency']),
		'vet_email' => $_POST['vet_email'],
		'vet_password' => $_POST['vet_password1'],
		'vet_street' => $_POST['vet_address'],
		'vet_suburb' => $_POST['vet_suburb'],
		'vet_state' => $_POST['vet_state'],
		'vet_postcode' => $_POST['vet_postcode'],
	);
	$fmrVetUpdate =updateVetDetails($vetid,$aUpdate);

	// ADD TO LOG: updated vet details
	$entry = [];
	$entry = [
		"_sk_vet_id" => $_SESSION['VetID'],
		"description" => 'Updated Vet Details.',
		"is_web_admin_login" => isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0
	];
	makeLogEntry($entry);

	// Redirect
	fRedirect('myaccount.php');
	fCleanup();
?>
