<?php
    /***********************************************************************************
	*   Filename    : forms.php
	*   Description : Petsafe About Microchipping page
	*
	*   Date        Modification By      Description
	*   23/01/2009  Kenneth Ho           Initial Creation
	*   22/08/2022  John Muffett         Reworked for Data API
	*   16/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Download Forms';
	$gaPage['root_directory'] = '..';
		
	/********************* Page Functions *********************/
    function getWebContent($code){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "contentCode eq '".$code."'",
			'select' => ['content'],
            'count' => true
        ]);
        $response = $fm->get('webContent', $odataQuery ,$allPages = true );
        
        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=No'.$code.'WebContentRecord');
            fCleanup();
        }
		$content = $response['data']['value'][0]['content'];
       
		return $content;
    }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td>

<?php
    /************************ Page Start *************************/

    /****** Get all Petsafe Forms information ******/

	if ($_SESSION['LoggedIn'] != 1){

		echo '<br />' . html_entity_decode(getWebContent('FormsPublic')) . '<br />';
	} else {

		echo '<br />' . html_entity_decode(getWebContent('FormsLoggedIn')) . '<br />';
	}

	
?>

<div><img src="<?php echo $gaPage['root_directory']; ?>/images/petsafe_com_au.jpg" />&nbsp;</div>

</td>

<td valign="top">
<br/>
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/dog_forms.jpg" />&nbsp;</div>
</td>

<?php
/************************* Page End **************************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>