<?php
	// force not to cache!
    header( "Expires: Mon, 20 Dec 1998 01:00:00 GMT" );
    header( "Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT" );
    header( "Cache-Control: no-cache, must-revalidate" );
    header( "Pragma: no-cache" );

	/***********************************************************************************
	*   Description : Pay invoice by Paypal
    *
	*   Copyright Keysoft Pty Ltd 2009
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['colour'] = 'orange';
	$gaPage['root_directory'] = '..';

	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('id', $_GET, '');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
	// invalid page entry
	$invoiceid = $_POST['id'];
} elseif ($_SERVER["REQUEST_METHOD"] == "GET") {
	$invoiceid = $_GET['id'];
} else {
die;
}
	// create an array from submitted checkboxes
	$invoicelist = array();
	
	foreach($_POST as $key => $value){
    $invoicelist[] = $value;
	}
var_dump($invoicelist);
//die;
//	while (list($key,$value) = each($_GET)){
//		if (strpos($key,'invoice_') === false){
//		} else {
//			$invoicelist[] = $value;
//		}
//	}
	print_r($invoicelist);
	//die;

	if (count($invoicelist) == 0 and $invoiceid != ''){
		$invoicelist[] = $invoiceid;
	}

	if ($invoiceid == '' and count($invoicelist) < 1){
		fRedirect('invoice_list.php');
		fCleanup();
	}
	//die;

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<br/><h2 class="orangeheading">Invoice Payment</h2><br/>

<table class="tbl" width="100%" border="0" cellspacing="0" cellpadding="5">
<tr>
	<td class="tableheader"><b>Invoice Date</b></td>
	<td class="tableheader"><b>Invoice #</b></td>
	<td class="tableheader" align="right"><b>Amount inc GST</b></td>
	<td class="tableheader"><b>Status</b></td>
</tr>

<?php

	$rowstyle = "tr1";
	$totalAmount = 0;

	// get list of company ids valid to this vet
	$aRequest = array();
	$aRequest['_sk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
	$fmrCompanies = fFMPerformFind('petsafe', 'All Fields - Company_Vet_Relation', $aRequest);
	$fmcCompanies = $fmrCompanies["response"]["data"];
	$companyList = array();
	$ii = 0;
	foreach ($fmcCompanies as $companyrecord){
		$companyList[$ii] = $companyrecord['fieldData']['_sk_company_id'];
		$ii += 1;
	}


	// loop invoices
	foreach ($invoicelist as $id){
		//invalid invoice id check
		$aRequest = array();
		$aRequest['_pk_invoice_id'] = '="' . $id . '"';
		$fmrInvoice = fFMPerformFind('petsafe', 'Web - Invoice', $aRequest);
		if ($fmrInvoice === FALSE || $fmrInvoice["response"]["dataInfo"]["foundCount"] != 1){
			//fRedirect('invoice_list.php');
			//fCleanup();

		} else {
			// invoice exists - retrieve info
			$fmcInvoice = $fmrInvoice["response"]["data"][0];
            
			// check if authorised to pay for invoice
			if (array_search($fmcInvoice['fieldData']['client_id_for_company_c'],$companyList) === FALSE){
				// if not then throw user off
				fRedirect('invoice_list.php');
				fCleanup();
			}

			// get values
			$invoiceid = $fmcInvoice['fieldData']['_pk_invoice_id'];
			$invoicenumber = $fmcInvoice['fieldData']['invoice_no_c'];
			$company = $fmcInvoice['fieldData']['client_c'];
			$name = $fmcInvoice['fieldData']['contact_c'];
			$status = $fmcInvoice['fieldData']['invoice Status'];
			$invoicedate = $fmcInvoice['fieldData']['Invoice Date'];
			$duedate = $fmcInvoice['fieldData']['cPaymentDueDate'];
			$paiddate = $fmcInvoice['fieldData']['invoice_paid_date'];
			$reference = $fmcInvoice['fieldData']['payment_reference'];
			$amount = $fmcInvoice['fieldData']['amount_inc_gst_c'];
			$address = $fmcInvoice['fieldData']['invoice_Companies::Mailing Street'];
			$city = $fmcInvoice['fieldData']['invoice_Companies::Mailing Suburb'];
			$state = $fmcInvoice['fieldData']['invoice_Companies::Mailing State'];
			$postcode = $fmcInvoice['fieldData']['invoice_Companies::Mailing Postcode'];
			$country = 'AU';
			$phone = $fmcInvoice['fieldData']['invoice_Vet::vet_phone'];
			$email = $fmcInvoice['fieldData']['invoice_Vet::vet_email'];
			
			// get Member No, Pet Name, etc from item details.
			$bRequest = array();
			$bRequest['_sk_invoice_id'] = '="' . $invoiceid . '"';
			$fmrInvoiceItems = fFMPerformFind('petsafe', 'Web - Invoice Items', $bRequest);
			
			$MemberShipTo = '';
			$MemberNo = '';
			$MemberName = '';
			$MemberAddress = '';
			$MemberCity = '';
			$MemberState = '';
			$MemberPostcode = '';
			
			
			if($fmrInvoiceItems){
				$fmcInvoiceItem = $fmrInvoiceItems["response"]["data"][0];
				
				$MemberNo = $fmcInvoiceItem['fieldData']['_sk_member_id'];
				$MemberName = $fmcInvoiceItem['fieldData']['Member Full Name'];
				
				if(trim($MemberNo) != ''){
					$MemberShipTo = 'PS' . $MemberNo . ' - ' . $MemberName;
					$MemberAddress = $fmcInvoiceItem['fieldData']['invoiceitem_Owner_Lookup::Mailing Street'];
					$MemberCity = $fmcInvoiceItem['fieldData']['invoiceitem_Owner_Lookup::Mailing Suburb'];
					$MemberState = $fmcInvoiceItem['fieldData']['invoiceitem_Owner_Lookup::Mailing State'];
					$MemberPostcode = $fmcInvoiceItem['fieldData']['invoiceitem_Owner_Lookup::Mailing Postcode'];
				}
			}


			if ($paiddate == ''){
				$totalAmount += $amount;

				//output to table
				echo '<tr class="' . $rowstyle . '">';
				echo '<td>' . fReformatDate($invoicedate) . '</td>';
				echo '<td>' . $invoicenumber . '</td>';
				echo '<td align="right">' . formatDecimal($amount) . '</td>';
				echo '<td>Waiting</td>';
				echo '</tr>';

				if ($rowstyle == "tr1"){
					$rowstyle = "tr2";
				} else {
					$rowstyle = "tr1";
				}
			}
            
            // Get details of person logged in (person doing payent)
            $aRequest = array();
            $aRequest['_pk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
            $fmrPayer = fFMPerformFind('petsafe', 'All Fields - Vet', $aRequest);
            
            if ($fmrPayer === FALSE || $fmrPayer["response"]["dataInfo"]["foundCount"] != 1){
				// payer vet not found
				fRedirect('invoice_list.php');
				fCleanup();
            }else{
                $fmcPayer = $fmrPayer["response"]["data"][0];
                
                $payer_name = $fmcPayer['fieldData']['vet_first_name'] . ' ' . $fmcPayer['fieldData']['vet_last_name'];
                $payer_phone = $fmcPayer['fieldData']['vet_phone'];
                $payer_email = $fmcPayer['fieldData']['vet_email'];
                $payer_city = $fmcPayer['fieldData']['vet_mailing_suburb'];
                $payer_state = $fmcPayer['fieldData']['vet_mailing_state'];
                $payer_postcode = $fmcPayer['fieldData']['vet_mailing_postcode'];
                $payer_address = $fmcPayer['fieldData']['vet_mailing_street'];
                $payer_country = 'AU';
            }
		}
	}

?>

<tr>
	<td class="tablesummary" colspan="2" align="right"><b>Total</b></td>
	<td class="tablesummary" align="right"><b>$<?php echo formatDecimal($totalAmount); ?></b></td>
	<td class="tablesummary">(GST inc: $<?php echo formatDecimal($totalAmount - $totalAmount/1.1); ?>)</td>
</tr>
</table>

<br/>
<hr/>
<br/>

<table width="100%" border="0">
<tr>
<td><form method="get" action="invoice_list.php" name="frmCancel"><input type="submit" value=" Cancel " /></form></td></td>

<?php
if ($totalAmount > 0){
?>
<td align="right">
<form method="post" action="https://pilot-payflowlink.paypal.com">

<input type="hidden" name="LOGIN" value="PetsafeF"/>
<input type="hidden" name="PARTNER" value="VSA"/>
<input type="hidden" name="DESCRIPTION" value="PetSafe Invoice Payment (<?php echo implode(",", $invoicelist); ?>)"/>
<input type="hidden" name="AMOUNT" value="<?php echo $totalAmount; ?>"/>
<!-- See if this will suppress display of a single invoice number when paying for multiple invoices
<input type="hidden" name="INVOICE" value="<?php echo $invoicenumber; ?>"/>
-->
<input type="hidden" name="TYPE" value="S"/>

<input type="hidden" name="NAME" value="<?php echo $payer_name; ?>"/>
<input type="hidden" name="ADDRESS" value="<?php echo $payer_address; ?>"/>
<input type="hidden" name="CITY" value="<?php echo $payer_city; ?>"/>
<input type="hidden" name="STATE" value="<?php echo $payer_state; ?>"/>
<input type="hidden" name="PHONE" value="<?php echo $payer_phone; ?>"/>
<input type="hidden" name="ZIP" value="<?php echo $payer_postcode; ?>"/>
<input type="hidden" name="EMAIL" value="<?php echo $payer_email; ?>"/>

<?php
/*
<!-- to ship info -->
<!--
<input type="hidden" name="NAMETOSHIP" value="<?php echo $MemberShipTo; ?>"/>
<input type="hidden" name="ADDRESSTOSHIP" value="<?php echo $MemberAddress; ?>"/>
<input type="hidden" name="CITYTOSHIP" value="<?php echo $MemberCity; ?>"/>
<input type="hidden" name="STATETOSHIP" value="<?php echo $MemberState; ?>"/>
<input type="hidden" name="ZIPTOSHIP" value="<?php echo $MemberPostcode; ?>"/>
<input type="hidden" name="COUNTRYTOSHIP" value="<?php echo $country; ?>"/>
-->
*/
?>

<input type="hidden" name="USER1" value=""/>
<input type="hidden" name="USER2" value="<?php echo implode(",", $invoicelist); ?>"/>
<input type="hidden" name="USER3" value=""/>
<input type="hidden" name="METHOD" value="CC"/>
<input type="hidden" name="ECHODATA" value="True"/>
<input type="hidden" name="VERBOSITY" value="HIGH"/>

<input type="submit" value="Click Here to Pay" name="btnSubmit"/>
<div class="smalltext"><b>Credit Card payment is processed securely by Verisign.</b></div>
</form>
</td>
<?php
}
?>
</tr>
</table>

<br><br>

</td>

<td valign="top">
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/cockatoo_help.jpg" />&nbsp;</div>
</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>