<?php
	/***********************************************************************************
	*   Filename    : memberarea.php
	*   Description : Display member details
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   14/11/2019	John Muffett	     Clean up of code to get working with PHP 7
    *   29/07/2025  John Muffett         Reworked for oData API
    *
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'purple';

	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('owner_state', $_GET, '');
	fDefaultParameter('owner_suburb', $_GET, '');
	fDefaultParameter('mail_state', $_GET, '');
	fDefaultParameter('mail_suburb', $_GET, '');

	// check email - ajax call
	if (isset($_GET['ajax_check_email'])) {
		$email_error = '';
		if ( empty($_GET['email']) or $_GET['email'] == '' ) {
			$email_error = '<span style="color:red">Email address is mandatory!</span>';
		} else {
			$aRequest = array();
			$aRequest['Email'] = '="' . $_GET['email'] . '"';
			$fmrEmail = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
			$fmcEmail = $fmrEmail["response"]["data"];
			$countOwnerEmails = count($fmcEmail);
			$validCount = 0; // email being updated - there should be no other email like the updated value
			if ($countOwnerEmails > $validCount){
				$email_error = '<span style="color:red">An owner with this email address already exists on our records!<br/>Please enter a valid and unique email address OR <a href="memberlogin.php">login</a> with this email address and then register a pet.</span>';
			}
		}
		echo $email_error;
		die;
	}

	/************ Only allow logged in members to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['MemberID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}

	/****************** Fetch Member details if logged in ******************/
	$aRequest = array();
	$aRequest['_pk_member_id'] = '="' . $_SESSION['MemberID'] . '"';

	$fmrOwner = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
	$fmcOwner = $fmrOwner["response"]["data"][0];

	// get fields
	$owner_title = $fmcOwner['fieldData']['Title'];
	$owner_firstname = $fmcOwner['fieldData']['Given Name'];
	$owner_lastname = $fmcOwner['fieldData']['Last Name'];
	$owner_homephone = $fmcOwner['fieldData']['Home Phone'];
	$owner_workphone = $fmcOwner['fieldData']['Work Phone'];
	$owner_mobilephone = $fmcOwner['fieldData']['Mobile'];
	$owner_email = 	$fmcOwner['fieldData']['Email'];
	$owner_fax = $fmcOwner['fieldData']['Fax'];
	$owner_password = $fmcOwner['fieldData']['Password'];
	$owner_altperson1 = $fmcOwner['fieldData']['Alt Person A'];
	$owner_altphone1 = $fmcOwner['fieldData']['Phone A'];
	$owner_altperson2 = $fmcOwner['fieldData']['Alt Person B'];
	$owner_altphone2 = $fmcOwner['fieldData']['Phone B'];
	$street = $fmcOwner['fieldData']['Street'];
	$suburb = $fmcOwner['fieldData']['Suburb'];
	$state = $fmcOwner['fieldData']['State'];
	$postcode = $fmcOwner['fieldData']['Postcode'];
	$mailstreet = $fmcOwner['fieldData']['Mailing Street'];
	$mailsuburb = $fmcOwner['fieldData']['Mailing Suburb'];
	$mailstate = $fmcOwner['fieldData']['Mailing State'];
	$mailpostcode = $fmcOwner['fieldData']['Mailing Postcode'];
	$mailinglist = $fmcOwner['fieldData']['Mail List'];

    /****** Get Extra page info ******/

    $aRequest = array();
    $aRequest['code'] = '="MemberDetailsInfo"';

    $fmrMemberInfo = fFMPerformFind('petsafe', 'Web - WebContent', $aRequest);

	$fmcMemberInfo = $fmrMemberInfo["response"]["data"][0];
	$extraInfo = $fmcMemberInfo['fieldData']['Content'];

	// check if there is state
	// if yes, then prefill state
	// if no, get out
	// check if there is suburb
	// if yes, then prefill/select suburb
	// if no, get out
	// initialise the popups, so they can be echoed further down
	if (trim($state) != ""){
		// retrieve states and preselect

	    $states = ["ACT","NSW","NT","QLD","SA","TAS","WA","VIC"];
	    $state_popup = popup($states, 'owner_state', $state,'onchange="setSuburbValueList()"');
		$mailstate_popup = popup($states, 'mail_state', $mailstate,'onchange="setSuburbValueListMail()"');
	
		if (trim($suburb) != ""){
			// preselect suburb
			$aRequest = array();
	        $aRequest['State'] = '="' . $state . '"';
	        $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $suburbsData=$suburbsResult ['response']['data'];
            $suburbs = array();
            foreach ($suburbsData as $suburbsLine)
            {
                $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
               
            }
            asort($suburbs);
			$suburb_popup = popup($suburbs, 'owner_suburb', $suburb,'onchange="setPostcodeValueList()"');
			if (trim($postcode) != ""){
				// preselect postcode
		        $aRequest = array();
	            $aRequest['State'] = '=="' . $state . '"';
	            $aRequest['Suburb'] = '=="' . $suburb . '"';
	            $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
                $postcodeData=$postcodesResult['response']['data'];
                $postcodes = array();
                foreach ($postcodeData as $postcodeLine){
                    $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
                }
                asort($postcodes);
		    	$postcode_popup = popup($postcodes, 'owner_postcode', $postcode);
			}
		}
	}
	if (trim($mailstate) != ""){

		
		if (trim($mailsuburb) != ""){
			// preselect suburb
			$aRequest = array();
	        $aRequest['State'] = '="' . $mailstate . '"';
	        $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $suburbsData=$suburbsResult ['response']['data'];
            $suburbs = array();
            foreach ($suburbsData as $suburbsLine)
            {
                $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
               
            }
            asort($suburbs);
			$mailsuburb_popup = popup($suburbs, 'mail_suburb', $mailsuburb,'onchange="setPostcodeValueListMail()"');

			if (trim($mailpostcode) != ""){
				// preselect postcode
				$aRequest = array();
	            $aRequest['State'] = '="' . $mailstate . '"';
	            $aRequest['Suburb'] = '="' . $mailsuburb . '"';
	            $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
                $postcodeData=$postcodesResult['response']['data'];
                $postcodes = array();
                foreach ($postcodeData as $postcodeLine){
                    $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
                }
                asort($postcodes);
		    	$mailpostcode_popup = popup($postcodes, 'mail_postcode', $mailpostcode);
			}
		}
	}

	// fill suburbs
	if (isset($_GET['hello_from_ajax1'])) {
		if ( empty($_GET['owner_state']) ) {
			$suburb_popup = '<select name="owner_suburb" disabled="disabled"></select>';
		} else {

			$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['owner_state'] . '"';
	        $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $suburbsData=$suburbsResult ['response']['data'];
            $suburbs = array();
            foreach ($suburbsData as $suburbsLine)
            {
                $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
               
            }
            asort($suburbs);
			$suburb_popup = popup($suburbs, 'owner_suburb', $selected_suburb,'onchange="setPostcodeValueList()"');
		}
		echo $suburb_popup;
		die;
	}

	// fill postcodes
	if (isset($_GET['hello_from_ajax2'])) {
		if ( empty($_GET['owner_suburb']) ) {
			$postcode_popup = '<select name="owner_postcode" disabled="disabled"></select>';
		} else {

			$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['owner_state'] . '"';
            $aRequest['Suburb'] = '="' . $_GET['owner_suburb'] . '"';
	        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $postcodeData=$postcodesResult['response']['data'];
            $postcodes = array();
            foreach ($postcodeData as $postcodeLine){
                $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
            }
            asort($postcodes);
            
            if (count($postcodes) == 1){
				$selected_postcode = $postcodes[0];
			}
	    	$postcode_popup = popup($postcodes, 'owner_postcode', $selected_postcode);
		}
		echo $postcode_popup;
		die;
	}

	// fill suburbs - mailing
	if (isset($_GET['hello_from_ajax1m'])) {
		if ( empty($_GET['mail_state']) ) {
			$mailsuburb_popup = '<select name="mail_suburb" disabled="disabled"></select>';
		} else {
			$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['mail_state'] . '"';
	        $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $suburbsData=$suburbsResult ['response']['data'];
            $suburbs = array();
            foreach ($suburbsData as $suburbsLine)
            {
                $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
               
            }
            asort($suburbs);
			$mailsuburb_popup = popup($suburbs, 'mail_suburb', $selected_mailsuburb,'onchange="setPostcodeValueListMail()"');
		}
		echo $mailsuburb_popup;
		die;
	}

	// fill postcodes - mailing
	if (isset($_GET['hello_from_ajax2m'])) {
		if ( empty($_GET['mail_suburb']) ) {
			$mailpostcode_popup = '<select name="mail_postcode" disabled="disabled"></select>';
		} else {

			$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['mail_state'] . '"';
            $aRequest['Suburb'] = '="' . $_GET['mail_suburb'] . '"';
	        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $postcodeData=$postcodesResult['response']['data'];
            $postcodes = array();
            foreach ($postcodeData as $postcodeLine){
                $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
            }
            asort($postcodes);
            
            if (count($postcodes) == 1){
				$selected_mailpostcode = $postcodes[0];
			}
	    	$mailpostcode_popup = popup($postcodes, 'mail_postcode', $selected_mailpostcode);
		}
		echo $mailpostcode_popup;
		die;
	}

	// default values
	if (empty($_POST['owner_state'])) {
		$selected_state = '';
	} else {
		$selected_state = $_POST['owner_state'];
	}
	if (empty($_POST['owner_suburb'])) {
		$selected_suburb = '';
	} else {
		$selected_suburb = $_POST['owner_suburb'];
	}
	if (empty($_POST['owner_postcode'])) {
		$selected_postcode = '';
	} else {
		$selected_postcode = $_POST['owner_postcode'];
	}
	if (empty($_POST['mail_state'])) {
		$selected_mailstate = '';
	} else {
		$selected_mailstate = $_POST['mail_state'];
	}
	if (empty($_POST['mail_suburb'])) {
		$selected_mailsuburb = '';
	} else {
		$selected_mailsuburb = $_POST['mail_suburb'];
	}
	if (empty($_POST['mail_postcode'])) {
		$selected_mailpostcode = '';
	} else {
		$selected_mailpostcode = $_POST['mail_postcode'];
	}


	// initialise lists on first load - if empty
	if (trim($state) == ''){
		$state_popup = popup($states, 'owner_state', $selected_state,'onchange="setTypeValueList()"');
	}
	if (trim($suburb) == ''){
		$suburb_popup = '<select name="owner_suburb" disabled="disabled"></select>';
	}
	if (trim($postcode) == ''){
		$postcode_popup = '<select name="owner_postcode" disabled="disabled"></select>';
	}
	if (trim($mailstate) == ''){
		$mailstate_popup = popup($states, 'mail_state', $selected_mailstate,'onchange="setTypeValueListMail()"');
	}
	if (trim($mailsuburb) == ''){
		$mailsuburb_popup = '<select name="mail_suburb" disabled="disabled"></select>';
	}
	if (trim($mailpostcode) == ''){
		$mailpostcode_popup = '<select name="mail_postcode" disabled="disabled"></select>';
	}

	// function to create select list dynamically
	function popup($values, $name, $selected_value = '', $extras = '') {
		$popup = '<select name="' . $name . '" ' . $extras . '>';
		$popup.= '<option value="">- Please select -</option>';
		foreach($values as $value) {
			if (strtoupper($value) == strtoupper($selected_value)) {
				$selected = 'selected="selected"';
			} else {
				$selected = '';
			}
			$popup.= '<option value="' . $value . '" ' . $selected . '>' . $value . '</option>';
		}
		$popup.= '</select>';
		return $popup;
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<script type="text/javascript" src="../javascripts/prototype.js"></script>
<script type="text/javascript" src="../javascripts/common.js"></script>

<style type="text/css">
	.instructions{display:block}
	.instructions *{
	display:block;
	height:1px;
	overflow:hidden;
	font-size:.01em;
	background:#CC99FF}
	.instructions1{
	margin-left:3px;
	margin-right:3px;
	padding-left:1px;
	padding-right:1px;
	border-left:1px solid #e9d3ff;
	border-right:1px solid #e9d3ff;
	background:#d8b2ff}
	.instructions2{
	margin-left:1px;
	margin-right:1px;
	padding-right:1px;
	padding-left:1px;
	border-left:1px solid #f9f4ff;
	border-right:1px solid #f9f4ff;
	background:#d5acff}
	.instructions3{
	margin-left:1px;
	margin-right:1px;
	border-left:1px solid #d5acff;
	border-right:1px solid #d5acff;}
	.instructions4{
	border-left:1px solid #e9d3ff;
	border-right:1px solid #e9d3ff}
	.instructions5{
	border-left:1px solid #d8b2ff;
	border-right:1px solid #d8b2ff}
	.instructionsfg{
	background:#CC99FF;
	padding: 3px;}
</style>

<script type="text/javascript">
	// handler to fill suburbs
	function setSuburbValueList(){
		var state_popup = document.forms[0].elements['owner_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['owner_suburb'];
		var postcode_popup = document.forms[0].elements['owner_postcode'];
		suburb_popup.disabled = false;
		postcode_popup.options.length = 0;
		postcode_popup.disabled = true;
		suburb_popup.options[suburb_popup.length] = new Option('loading...','');
		suburb_popup.selectedIndex = suburb_popup.length-1;
		var url = 'memberarea.php?hello_from_ajax1=true&owner_state='+selected_state;
		var target = 'suburb_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		suburb_popup.focus();
	}

	// handler to fill postcodes
	function setPostcodeValueList(){
		var state_popup = document.forms[0].elements['owner_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['owner_suburb'];
		var selected_suburb = suburb_popup.value;
		var postcode_popup = document.forms[0].elements['owner_postcode'];
		postcode_popup.disabled = false;
		postcode_popup.options[postcode_popup.length] = new Option('loading...','');
		postcode_popup.selectedIndex = postcode_popup.length-1;
		var url = 'memberarea.php?hello_from_ajax2=true&owner_suburb='+selected_suburb+'&owner_state='+selected_state;
		var target = 'postcode_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		postcode_popup.focus();
	}

	// handler to fill suburbs - mailing
	function setSuburbValueListMail(){
		var state_popup = document.forms[0].elements['mail_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['mail_suburb'];
		var postcode_popup = document.forms[0].elements['mail_postcode'];
		suburb_popup.disabled = false;
		postcode_popup.options.length = 0;
		postcode_popup.disabled = true;
		suburb_popup.options[suburb_popup.length] = new Option('loading...','');
		suburb_popup.selectedIndex = suburb_popup.length-1;
		var url = 'memberarea.php?hello_from_ajax1m=true&mail_state='+selected_state;
		var target = 'mailsuburb_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		suburb_popup.focus();
	}

	// handler to fill postcodes - mailing
	function setPostcodeValueListMail(){
		var state_popup = document.forms[0].elements['mail_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['mail_suburb'];
		var selected_suburb = suburb_popup.value;
		var postcode_popup = document.forms[0].elements['mail_postcode'];
		postcode_popup.disabled = false;
		postcode_popup.options[postcode_popup.length] = new Option('loading...','');
		postcode_popup.selectedIndex = postcode_popup.length-1;
		var url = 'memberarea.php?hello_from_ajax2m=true&mail_suburb='+selected_suburb+'&mail_state='+selected_state;
		var target = 'mailpostcode_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		postcode_popup.focus();
	}

	function validateForm(myform) {
		var error1 = 'Please complete the following mandatory field(s):\n';
		var error2 = 'Your password is too short.\nPlease re-enter your password - at least 3 characters.';
		var error3 = 'The two Petsafe Password fields do not match!\nPlease re-enter your password.';
		var error4 = 'Please enter a valid email address.';
		var error5 = 'Your home phone number must be 10 digits long.';
		var error6 = 'Your work phone number must be 10 digits long.';
		var error7 = 'Your mobile phone number must be 10 digits long.';
		var error8 = 'Your fax number must be 10 digits long.';
		var mandatory_err = 0;

		// check mandatory fields
		// owner_suburb, owner_state, owner_homephone, 
		// owner_password1, owner_password2, pet_name, pet_suburb, pet_state
		if (trim(myform.owner_address.value) == ''){
			myform.owner_address.value = '';
			error1 = error1 + '\n- Owner\'s Street Address';
			mandatory_err = 1;
		}
		if (myform.owner_state.selectedIndex == 0){
			error1 = error1 + '\n- Owner\'s State';
			mandatory_err = 1;
		}
		if (myform.owner_suburb.selectedIndex == 0){
			error1 = error1 + '\n- Owner\'s Suburb';
			mandatory_err = 1;
		}
		if (myform.owner_postcode.selectedIndex == 0){
			error1 = error1 + '\n- Owner\'s Postcode';
			mandatory_err = 1;
		}

		//var myhomephone;
		//myhomephone = getNumber(myform.owner_homephone.value);
		//alert(myhomephone.toString());

		if (trim(myform.owner_homephone.value) == ''){
			myform.owner_homephone.value = '';
			error1 = error1 + '\n- Owner\'s Telephone(H)';
			mandatory_err = 1;
		}
		//if (trim(myform.owner_email.value) == ''){
		//	myform.owner_email.value = '';
		//	error1 = error1 + '\n- Owner\'s E-mail';
		//	mandatory_err = 1;
		//}
		if (trim(myform.owner_password1.value) == '' || trim(myform.owner_password2.value) == ''){
			myform.owner_password1.value = '';
			myform.owner_password2.value = '';
			error1 = error1 + '\n- PetSafe Password';
			mandatory_err = 1;
		}

		if (mandatory_err != 0){
			alert(error1);
			return false;
		}

		// check if phone numbers, if defined, are 10 digits
		if (myform.owner_homephone.value.replace(/\D/g,'').length != 10){
			alert(error5);
			myform.owner_homephone.focus();
			return false;
		}
		if (trim(myform.owner_workphone.value) != '' && myform.owner_workphone.value.replace(/\D/g,'').length != 10){
			alert(error6);
			myform.owner_workphone.focus();
			return false;
		}
		if (trim(myform.owner_mobilephone.value) != '' && myform.owner_mobilephone.value.replace(/\D/g,'').length != 10){
			alert(error7);
			myform.owner_mobilephone.focus();
			return false;
		}
		if (trim(myform.owner_fax.value) != '' && myform.owner_fax.value.replace(/\D/g,'').length != 10){
			alert(error8);
			myform.owner_fax.focus();
			return false;
		}

		// check if password is long enough
		if (myform.owner_password1.value.length < 3) {
			alert(error2);
			myform.owner_password1.value = '';
			myform.owner_password2.value = '';
			myform.owner_password1.focus();
			return false;
		}

		// check if passwords match
		if (myform.owner_password1.value != myform.owner_password2.value){
			alert(error3);
			myform.owner_password1.value = '';
			myform.owner_password2.value = '';
			myform.owner_password1.focus();
			return false;
		}

		// check for email address duplication
		if (trim(document.getElementById('email_err').innerHTML) != ''){
			alert(error4);
			myform.owner_email.focus();
			return false;
		}

		return true;
	}

	function checkEmail(){
		var owneremail = document.forms[0].elements['owner_email'];
		var selected_owneremail = owneremail.value;
		var originalemail = document.forms[0].elements['original_email'];
		var selected_originalemail = originalemail.value;
		if (trim(selected_owneremail) == trim(selected_originalemail) || trim(selected_owneremail) == ''){
			document.getElementById('email_err').innerHTML = '';
		} else if (trim(selected_owneremail) != ''){
			var url = 'memberarea.php?ajax_check_email=true&email='+selected_owneremail;
			var target = 'email_err';
			var result = new Ajax.Updater(target, url,{method: 'get'});
		}
	}

</script>

</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<?php

	echo '<br/><h2 class="purpleheading">Petsafe Registration for ' . $fmcOwner['fieldData']['cFullName'] . '</h2><br/>';

?>

<style>
    .members-area-table tr td{
        padding: 2px;
    }
    
    .members-area-table tr td:first-child{
        width: 190px;
        box-sizing: border-box;
    }
</style>

<form action="memberarea_submit.php" method="post" name="frmMember" id="frmMember">
	<table border="0" width="90%" cellspacing="0" cellpadding="0" class="members-area-table">
		<tr>
			<td>Member ID</td>
			<td valign="top">
				<b>PS<?php echo $_SESSION['MemberID']; ?></b>
			</td>
		</tr>
		<tr>
			<td>Name</td>
			<td valign="top">
				<?php echo $owner_title . ' ' . $owner_firstname . ' ' . $owner_lastname; ?>
			</td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td><span style="color:red"><sup>*</sup></span> Street Address</td>
			<td valign="top">
				Unit/Street No &nbsp;&nbsp;Street Name<br/>
				<input type="text" size="30" value="<?php echo $street; ?>" name="owner_address" />
			</td>
		</tr>
		<tr>
			<td valign="top"><span style="color:red"><sup>*</sup></span> State</td>
			<td valign="top">
				<?php echo $state_popup ?>
			</td>
		</tr>
		<tr>
			<td valign="top"><span style="color:red"><sup>*</sup></span> Suburb</td>
			<td valign="top">
				<div id="suburb_container"><?php echo $suburb_popup ?></div>
			</td>
		</tr>
		<tr>
			<td valign="top"><span style="color:red"><sup>*</sup></span> Postcode</td>
			<td valign="top">
				<div id="postcode_container"><?php echo $postcode_popup ?></div>
			</td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td style="padding-bottom:10px;" colspan="2"><input type="checkbox" name="match_mailaddr" value="1" onclick="if (this.checked){document.getElementById('mailaddr').style.display = 'none'; document.getElementById('mailaddr').style.visibility = 'hidden'; } else { document.getElementById('mailaddr').style.display = ''; document.getElementById('mailaddr').style.visibility = 'visible'; }" /> Mailing address same as above</td>
		</tr>
		<tr>
			<td colspan="2" style="padding:0px;">
				<div id="mailaddr" name="mailaddr">
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td>Mailing Address</td>
					<td valign="top">
						<input type="text" size="30" value="<?php echo $mailstreet; ?>" name="mail_address" />
					</td>
				</tr>
				<tr>
					<td valign="top">State</td>
					<td valign="top">
						<?php echo $mailstate_popup ?>
					</td>
				</tr>
				<tr>
					<td valign="top">Suburb</td>
					<td valign="top">
						<div id="mailsuburb_container"><?php echo $mailsuburb_popup ?></div>
					</td>
				</tr>
				<tr>
					<td valign="top">Postcode</td>
					<td valign="top">
						<div id="mailpostcode_container"><?php echo $mailpostcode_popup ?></div>
					</td>
				</tr>
				</table>
				</div>
			</td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td valign="top"><span style="color:red"><sup>*</sup></span> Tel (H)</td>
			<td valign="top">
				<input type="text" size="12" value="<?php echo $owner_homephone; ?>" name="owner_homephone" />
				&nbsp;
				Tel (W)
				<input type="text" size="12" value="<?php echo $owner_workphone; ?>" name="owner_workphone" />
			</td>
		</tr>
		<tr>
			<td valign="top">Mobile</td>
			<td valign="top">
				<input type="text" size="12" value="<?php echo $owner_mobilephone; ?>" name="owner_mobilephone" />
				&nbsp;&nbsp;&nbsp;
				Fax
				<input type="text" size="12" value="<?php echo $owner_fax; ?>" name="owner_fax" />
			</td>
		</tr>
		<tr>
			<td valign="top">E-mail address</td>
			<td valign="top"><input type="text" size="40" value="<?php echo $owner_email; ?>" name="owner_email" />
			<input type="hidden" name="original_email" value="<?php echo $owner_email; ?>" />
			<!--- check for unique email //--->
			<div id="email_err"></div></td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td valign="top">Alternative person 1</td>
			<td valign="top">
				<input type="text" size="19" value="<?php echo $owner_altperson1; ?>" name="owner_altperson1" />
				&nbsp;
				Tel
				<input type="text" size="10" value="<?php echo $owner_altphone1; ?>" name="owner_altphone1" />
			</td>
		</tr>
		<tr>
			<td valign="top">Alternative person 2</td>
			<td valign="top">
				<input type="text" size="19" value="<?php echo $owner_altperson2; ?>" name="owner_altperson2" />
				&nbsp;
				Tel
				<input type="text" size="10" value="<?php echo $owner_altphone2; ?>" name="owner_altphone2" />
			</td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td valign="top" nowrap="nowrap"><span style="color:red"><sup>*</sup></span> Enter your Petsafe Password</td>
			<td valign="top">
				<input type="password" size="15" maxlength="12" value="<?php echo $owner_password; ?>" name="owner_password1" />
			</td>
		</tr>
		<tr>
			<td valign="top"><span style="color:red"><sup>*</sup></span> Re-Enter Password</td>
			<td valign="top">
				<input type="password" size="15" maxlength="12" value="<?php echo $owner_password; ?>" name="owner_password2" />
			</td>
		</tr>
		<tr>
			<td valign="top">&nbsp;</td>
			<td valign="top">
				The password can contain a combination of letters & numbers both in lower case
				and upper case.<br/>Please limit password to no more than 12 characters.
			</td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td valign="top">Join PetSafe Mailing List?</td>
			<td valign="top">
				<input type="radio" name="mailing_list" <?php if (strtoupper($mailinglist) == 'YES') echo 'checked="checked"'; ?> value="YES"/> Yes
				&nbsp;&nbsp;
				<input type="radio" name="mailing_list" <?php if ($mailinglist == '') echo 'checked="checked"'; ?> value="NO"/> No
				<br/>
				<span class="smalltext"><a href="privacysecurity.php" target="_blank"><b>Privacy Policy</b></a></span>
			</td>
		</tr>
		<tr>
			<td valign="top" colspan="2">
				<input type="hidden" name="memberid" value="<?php echo $_SESSION['MemberID']; ?>" />
				<br/><input type="submit" value="Update Contact Details" class="button" onclick="javascript: if(!validateForm(this.form)) return false;" />
			</td>
		</tr>
	</table>
</form>

<br/>
<hr/>
<table class="bodytext" border="0">
	<tr>
		<td valign="top"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_purple.jpg" />&nbsp;</td>
		<td><a href="register.php"><b>Register a New Pet</b></a><br/>&nbsp;</td>
	</tr>
	<tr>
		<td valign="top"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_purple.jpg" />&nbsp;</td>
		<td><a href="pets.php"><b>View / Change Pet Details</b></a><br/>&nbsp;</td>
	</tr>
	<tr>
		<td valign="top"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_purple.jpg" />&nbsp;</td>
		<td><a href="pets.php"><b>Print Certificates</b></a><br/>&nbsp;</td>
	</tr>
</table>

<br/><br/>

</td>

<td valign="top">

<br/><br/>

<div style="width: 400px;">
  <b class="instructions">
  <b class="instructions1"><b></b></b>
  <b class="instructions2"><b></b></b>
  <b class="instructions3"></b>
  <b class="instructions4"></b>
  <b class="instructions5"></b></b>

  <div class="instructionsfg">
    <?php echo html_entity_decode($extraInfo) . '<br />'; ?>
	<div style="position:relative;left:-73px;"><img src="<?php echo $gaPage['root_directory']; ?>/images/dog_ball_sm.png" /></div>
  </div>

  <b class="instructions">
  <b class="instructions5"></b>
  <b class="instructions4"></b>
  <b class="instructions3"></b>
  <b class="instructions2"><b></b></b>
  <b class="instructions1"><b></b></b></b>
</div>

</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>