<?php
//error_reporting(E_ALL);
//ini_set('display_errors', 1);
    /***********************************************************************************
    *   Filename : microchip_registrations_by_date.php
	*   Description : Microchip Registrations By Date Report
	* 
	*   Date        Modification By      Description
	*   23/01/2009  Kenneth Ho           Initial Creation
	*   22/08/2022  John Muffett         Reworked for Data API
   	*
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Microchip Report';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code',          $_GET, '');

	$start_date        = isset($_GET['start_date']) ? $_GET['start_date'] : '';
	$finish_date       = isset($_GET['finish_date']) ? $_GET['finish_date'] : '';
	
	//filemaker takes date as mm/dd/yyyy, so change it to that.
	$start_date_arr = explode( "/", $start_date);
	$finish_date_arr = explode( "/", $finish_date);
	
	//validate dates
	if(count($start_date_arr) == 3){
		$start_date_fm = $start_date_arr[1] . "/" . $start_date_arr[0] . "/" . $start_date_arr[2];
	}else{
		$start_date_fm = '';
		$start_date = '';
	}
	
	if(count($finish_date_arr) == 3){
		$finish_date_fm = $finish_date_arr[1] . "/" . $finish_date_arr[0] . "/" . $finish_date_arr[2];
	}else{
		$finish_date_fm = '';
		$finish_date = '';
	}
	
	//form FM date range string
	$date_range = $start_date_fm;
	
	if($start_date_fm != '' or $finish_date_fm != ''){
		$date_range .= "...";
	}
	
	$date_range .= $finish_date_fm;

    /************ Only allow logged in vets to this area ************/
	
	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('myaccount.php?err_code=NotAuthorised');
		fCleanup();
	}
	
	// Check vet is main vet
	$aRequest = array();
	$aRequest['_sk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
	$aRequest['vet_main_contact'] = '="Yes"';
	$fmrCompanies = fFMPerformFind('petsafe', 'All Fields - Company_Vet_Relation', $aRequest);
	if ($fmrCompanies === FALSE || $fmrCompanies["response"]["dataInfo"]["foundCount"] < 1){
		fRedirect('myaccount.php?err_code=NotAuthorised');
	} else {
		$fmcCompanies = $fmrCompanies["response"]['data'];
	
		// get company's that vet is the main vet
		foreach ($fmcCompanies as $companyrecord){
			$aRequest = array();
			$aRequest['_pk_company_id'] = '="' . $companyrecord['fieldData']['_sk_company_id'] . '"';
			$aRequest['dont_show_on_web'] = '=';
	
			$vet_clinics[] = $companyrecord['fieldData']['_sk_company_id'];
		}	
		
	}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<style>
	.chip-list-tbl{
		border-collapse:separate;
		overflow:hidden;
		border-radius:3px;
		box-shadow:0 0 3px rgba(0,0,0,0.15);
	}
	
	.chip-list-tbl tr td{
		border-bottom:1px solid #f0f0f0;
		padding:5px;
	}
	
	.chip-list-tbl thead th{
		border-bottom:1px solid #000;
		background-color:#1D6799;
		padding:10px;
		padding-left:5px;
		color:#fff;
		font-size:14px;
	}
	
	.chip-list-tbl .clinic-name-subheading{
		background-color:#FFF3B3;
		font-weight:bold;
		border-top:solid 1px #fff;
	}
	
	.chip-list-tbl tbody tr:nth-child(odd) {
		background-color: #f5f5f5;
	}
	
	.no-clinics-assigned{
		padding:10px;
		border:1px solid red;
		color:red;
		border-radius:1px;	
	}
	
	.txt-finish-date, .txt-start-date{
		width:100px;	
	}
	
	.date-range-indicator{
		background-color:#B70000;
		color:#fff;
		border-radius:2px;
		display:inline-block;
		margin-bottom:5px;
		padding:3px 4px;
		font-weight:bold;
		letter-spacing:1px;
	}
</style>

<script language=javascript>

</script>

</head>

<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td valign="top">

<br/>

<?php
    /*************************** Page Start ***************************/

?>


<?php
/*
echo '<pre>';
print_r($fmrChips->getFoundSetCount());
echo '</pre>';
die();
*/
?>



<h2 class="orangeheading">Microchip Registrations By Date</h2>

<form method="get">
<table>
	<tr>
		<td>Select Date Range (dd/mm/yyyy):&nbsp;</td>
        <td>
        <input type="text" name="start_date" id="start_date" class="txt-start-date" value="" />&nbsp;&nbsp;to&nbsp;&nbsp;<input type="text" value="" name="finish_date" class="txt-finish-date" id="finish_date"/>
        </td>
		<td>
			<button type="submit" style="margin-left:10px;">Continue</button>
		</td>
	</tr>
</table>
</form>

<br />

<?php
	$found_chips = false;
	
	$aSort = array();
	$aSort[0] = ['fieldName'=>'chip_Clinic::_pk_company_id', 'sortOrder'=>'ascend'];
	$aSort[1] = ['fieldName'=>'implanted_date', 'sortOrder'=>'ascend'];
	$aSort[2] = ['fieldName'=>'_pk_chip_id', 'sortOrder'=>'ascend'];
	
	if($start_date != '' or $finish_date != '' or (isset($_GET['start_date']) and isset($_GET['finish_date']) and $date_range == '')){
		$aRequestA = array();
		// Get all chips for vet's clinics
		$fmcVetCompanies = $fmrVetCompanies["response"]["data"];
		$aRequestB = array();

		foreach ($fmcCompanies as $companyrecord){
			$aRequestB['chip_Clinic::_pk_company_id'] = $companyrecord['fieldData']['_sk_company_id'];
			$aRequestB['implanted_date'] = $date_range;
			$aRequestA[] = $aRequestB;
		}
		
		//Find chips all vet's clinics
		$fmrChips = fFMCompoundFind('petsafe', 'Web - Chips', $aRequestA, $aSort);
		
		if ($fmrChips === FALSE || $fmrChips["response"]["dataInfo"]["foundCount"] < 1){
			$found_chips = false;
		} else {
			$found_chips = true;
			$fmcChips = $fmrChips['response']['data'];
		}
		
		if($date_range == ''){
			echo '<div class="date-range-indicator">All</div>';
		}else{
			echo '<div class="date-range-indicator">'. $start_date . '&nbsp;&nbsp;to&nbsp;&nbsp;' . $finish_date .'</div>';
		}
		

		echo '<table border="0" cellpadding="2" cellspacing="0" width="100%" class="chip-list-tbl">';
		echo '<thead>';
		echo '<tr>';
		echo '<th>&nbsp;</th>';
		echo '<th>Implant Date</th>';
		echo '<th>Microchip No.</th>';
		echo '<th>Implanter #</th>';
		echo '<th>Member Name</th>';
		echo '<th>Pet Name</th>';
		echo '</tr>';
		echo '</thead>';
		
		$colspan = 7;
		
		if($found_chips){
			$chip_count = 0;
			$clinic_id_group = '';
			
			foreach ($fmcChips as $chip){
				$chip_count++;
				
				// Get values
				$clinic_id = $chip['fieldData']['chip_Clinic::_pk_company_id'];
				$clinic_name = $chip['fieldData']['chip_Clinic::Company Name'];
				$microchip_no = $chip['fieldData']['Chip No'];
				$member_no = $chip['fieldData']['c_Pet_Owner'];
				$member_name = $chip['fieldData']['c_Pet_Owner Name'];
				$pet_name = $chip['fieldData']['chip_Pets::Name'];
				$implant_date = fReformatDate($chip['fieldData']['implanted_date']);
				$implanter_id = $chip['fieldData']['chip_Vet::implanter_number'];
				$implanter_name = $chip['fieldData']['chip_Vet::full_name_c'];
				$invoice_no = $chip['fieldData']['chip_InvoiceItem::cInvoiceNo'];
				
				if($clinic_id != $clinic_id_group){
					echo '<tr><td class="clinic-name-subheading" colspan="' . $colspan . '" style="padding:10px;">' . $clinic_name . '</td></tr>';	
				}
				
				echo '<tr>';
				echo '<td style="font-size:8px; width:30px;">' . $chip_count . '</td>';
				echo '<td>' . $implant_date . '</td>';
				echo '<td>' . $microchip_no . '</td>';
				echo '<td>' . $implanter_id . ' - ' . $implanter_name . '</td>';
				echo '<td>' . $member_name . '</td>';
				echo '<td>' . $pet_name . '</td>';
				echo '</tr>';
	
				$clinic_id_group = $clinic_id;
			}
		}else{
			echo '<tr><td colspan="' . $colspan . '" style="padding:10px;">No chips found.</td></tr>';
		}
	
		echo '</table>';
		echo '<br />';
	
	}
?>

<?php
/************************* Page End **************************/
require '../phpobjects/templates/common/page_footer.php';
?>

<script>
	document.getElementById('start_date').focus();
</script>
</html>
<?php fCleanup(); ?>