<?php
	/***********************************************************************************
	*   Filename    : vetarea.php
	*   Description : Vet main page after login
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	* 	23/08/2022  John Muffett         Reworked for Data API
	*   29/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';


    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');

	/********************* Page Functions *********************/
	/****** Get all Petsafe About Microchipping information ******/
    function getWebContent($code){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "contentCode eq '".$code."'",
			'select' => ['content'],
            'count' => true
        ]);
        $response = $fm->get('webContent', $odataQuery ,$allPages = true );
        
		$content = $response['data']['value'][0]['content'];
       
		return $content;
    }
	function getVetByVetID($id){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_pk_vet_id eq ".$id,
            'count' => true
        ]);
        $response = $fm->get('Vet', $odataQuery ,$allPages = true );
        
		
		$vet = $response['data']['value'][0];
       
		return $vet;
    }
	function getVetCompaniesByVetID($id){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_sk_vet_id eq ".$id." and vet_main_contact eq 'Yes'",
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );
       
		return $response;
    }
	function getVetClinicsByVetID($id){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_sk_vet_id eq ".$id." and dontDisplayOnWeb eq null",
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );
       
		return $response;
    }
    /************ Only allow logged in vets to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}

	// get vet details	
	$fmcVet = getVetByVetID($_SESSION['VetID']);

	// get company details, if main vet
	$fmrVetCompanies = getVetCompaniesByVetID($_SESSION['VetID']);

	// get authorised clinics for vet
	$fmrVetAuthClinics = getVetClinicsByVetID($_SESSION['VetID']);

    /****** Get Extra page info ******/
	$extraInfo = getWebContent("VetInfoPanel");

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<style type="text/css">
	.instructions{display:block}
	.instructions *{
	display:block;
	height:1px;
	overflow:hidden;
	font-size:.01em;
	background:#FFCC66}
	.instructions1{
	margin-left:3px;
	margin-right:3px;
	padding-left:1px;
	padding-right:1px;
	border-left:1px solid #ffe9bd;
	border-right:1px solid #ffe9bd;
	background:#ffd88c}
	.instructions2{
	margin-left:1px;
	margin-right:1px;
	padding-right:1px;
	padding-left:1px;
	border-left:1px solid #fff9ef;
	border-right:1px solid #fff9ef;
	background:#ffd583}
	.instructions3{
	margin-left:1px;
	margin-right:1px;
	border-left:1px solid #ffd583;
	border-right:1px solid #ffd583;}
	.instructions4{
	border-left:1px solid #ffe9bd;
	border-right:1px solid #ffe9bd}
	.instructions5{
	border-left:1px solid #ffd88c;
	border-right:1px solid #ffd88c}
	.instructionsfg{
	background:#FFCC66;
	padding: 3px;}
	
	.welcome-message{
		color:#333;
		padding: 15px;
		padding-bottom: 10px;
		font-size: 15px;
		border-radius: 2px;
		margin-bottom: 25px;
		display: inline-block;
		background-color: #fafafa;
		border:1px solid #f0f0f0;
		box-shadow: 1px 1px 3px rgba(0,0,0,.2);
	}

	.welcome-message-title{
		display: block;
		font-size: 18px;
		margin-bottom: 5px;
	}

	.welcome-message .authorised-clinic{
		font-size: 13px;
		padding: 3px 3px 3px 12px;
	}
</style>

</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<?php

	echo '<br/><h2 class="orangeheading">Vet / Pound Login</h2>';

?>

<div class="welcome-message">
    <?php
        echo '<span class="welcome-message-title">Welcome ' . $fmcVet['title_full_name_c'] . ',</span><div style="padding:3px;">You are authorised to register pets for the following clinics</div>';
        
        if ($fmrVetAuthClinics['success'] === FALSE || $fmrVetAuthClinics["data"]['count'] < 1){
            // do nothing
            echo '<div class="authorised-clinic">- No clinics found.</div>';
        } else {
            $fmcVetAuthClinics = $fmrVetAuthClinics["data"];
            foreach ($fmcVetAuthClinics['value'] as $clinic_record){
                echo '<div class="authorised-clinic">- ' . $clinic_record['companyName'] . '</div>';
            }
        }
    ?>
</div>


<table class="bodytext" border="0" width="560">
<?php
if (strtoupper($_SESSION['VetAllowSearch']) == 'YES'){
?>
	<tr>
		<td valign="top" width="18"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_orange.jpg" />&nbsp;</td>
		<td><a href="index.php#chipsearch"><b>Microchip/Tag Search</b></a><br/>&nbsp;</td>
	</tr>
<?php
}
?>
	<tr>
		<td valign="top" width="18"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_orange.jpg" />&nbsp;</td>
		<td><a href="register.php"><b>Enter New Registration</b></a><br/>&nbsp;</td>
	</tr>
	<tr>
		<td valign="top" width="18"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_orange.jpg" />&nbsp;</td>
		<td><a href="register.php?type=breeder"><b>Breeder Registrations</b></a><br/>&nbsp;</td>
	</tr>
<?php
	$is_main_vet = false;
	
	if ($fmrVetCompanies['success'] === FALSE || $fmrVetCompanies["data"]['count'] < 1){
		// do nothing
	} else {
	// show invoices to main vets only
	$is_main_vet = true;
?>
	<tr>
		<td valign="top" width="18"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_orange.jpg" />&nbsp;</td>
		<td><a href="invoice_list.php"><b>View / Pay Invoices</b></a><br/>&nbsp;</td>
	</tr>
<?php
	}
?>
	<tr>
		<td valign="top" width="18"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_orange.jpg" />&nbsp;</td>
		<td><a href="editvet.php?vetid=<?php echo $_SESSION['VetID']; ?>"><b>Edit Vet Account</b></a><br/>&nbsp;</td>
	</tr>
    
	<tr>
		<td valign="top" width="18"><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/bullet_orange.jpg" />&nbsp;</td>
		<td>
        	<b>Reports</b>
            
            <ul>
            	<li><a href="microchip_by_clinic.php">Microchip Report By Clinic</a></li>
                <?php
				if($is_main_vet === true){
					echo '<li><a href="microchip_registrations_by_date.php">Microchip Registrations By Date</a></li>';
				}
                ?>
            </ul>
        </td>
	</tr>

<?php
	if ($fmrVetCompanies['success'] === FALSE || $fmrVetCompanies["data"]['count'] < 1){
		// do nothing

	} else {
		$fmcVetCompanies = $fmrVetCompanies["data"];

		foreach ($fmcVetCompanies['value'] as $companyrecord){
			// get company details
			echo '<tr><td valign="top" width="18"><img align="right" src="' . $gaPage['root_directory'] . '/images/bullet_orange.jpg" />&nbsp;</td>';
			echo '<td><b>' . $companyrecord['companyName'] . '</b>';
			echo '<ul>';
			echo '<li><a href="editcompany.php?companyid=' . $companyrecord['_sk_company_id'] . '">Edit Clinic Details</a></li>';
			echo '<li><a href="companyvets.php?companyid=' . $companyrecord['_sk_company_id'] . '">View/Remove Vets</a></li>';
			echo '<li><a href="addvet.php?companyid=' . $companyrecord['_sk_company_id'] . '">Add New Vet</a></li>';
			echo '</ul></td></tr>';
		}
	}
?>
</table>

</td>

<td valign="top">

<br/><br/>

<div style="width: 400px;">
  <b class="instructions">
  <b class="instructions1"><b></b></b>
  <b class="instructions2"><b></b></b>
  <b class="instructions3"></b>
  <b class="instructions4"></b>
  <b class="instructions5"></b></b>

  <div class="instructionsfg">
    <?php echo html_entity_decode($extraInfo) . '<br />'; ?>
  </div>

  <b class="instructions">
  <b class="instructions5"></b>
  <b class="instructions4"></b>
  <b class="instructions3"></b>
  <b class="instructions2"><b></b></b>
  <b class="instructions1"><b></b></b></b>
</div>

<br/><br/>

</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>