<?php
    /***********************************************************************************
	*   Filename    : vetsearchresults.php
	*   Description : Petsafe Search Results from Participating Vets page
	*
	*   Date        Modification By      Description
	*   28/01/2009  Kenneth Ho           Initial Creation
	*   22/08/2022  John Muffett         Reworked for Data API
	*   16/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';
	require_once '../phpobjects/objects/table.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Vet Results';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

     /********************* Page Defaults *********************/
    fDefaultParameter('state', $_GET, '');
    fDefaultParameter('postcode', $_GET, '');
    fDefaultParameter('vid', $_GET, '');

    $getVetID = $_GET['vid'];               // VET ID in url
    $getStateValue = $_GET['state'];        // Get STATE value
    $getPostcodeValue = $_GET['postcode'];  // Get POSTCODE value

    // Global $vet array
    $vet = array();

    // Global $table variable
    $table;
    /*************************** Page Functions ***********************/

    // Fill the global $vet array with the name of each vet person in the specified company
    function getVetNames($id)
    {
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
            'filter' => "_sk_company_id eq ".$id,
            'orderby' => "vet_main_contact desc",
            'select' => "vet_main_contact, vet_name_c",
            'top' => 6,
            'count' => true
        ]);
        $response = $fm->get('company_Company_Vet_Relation', $odataQuery ,$allPages = true );

        // Check for not found
       if (!$response['success'] || $response["data"]['count'] < 1){

            $vet['Vet1'] = '';
            $vet['Vet2'] = '';
            $vet['Vet3'] = '';
            $vet['Vet4'] = '';
            $vet['Vet5'] = '';
            $vet['Vet6'] = '';

        } else {

        $vetList = $response["data"];

        $i = 1;
        foreach ($vetList['value'] as $record)
            {
                $vet['Vet' . $i] = $record['vet_name_c'];
                $i++;
            }

        }

        return $vet;
    }

    // For creating the global table variable for display
    function makeTable($fmac, $noOfRec)
    {
        global $table;
        global $getStateValue;
        global $getPostcodeValue;

        // Paging
	    $PageSize = 20;
	    $PageNo   = (array_key_exists('t_vet_list_pageno', $_GET) ? $_GET['t_vet_list_pageno'] : 1);

        $StartRow = ($PageNo - 1) * $PageSize;
	    $EndRow   = min($PageNo * $PageSize, $noOfRec);

        if ($getStateValue != ''){
            // Create the table
	        $table = array(
		             "TableName"    => "t_vet_list"
		           , "TemplateLink" => "vetsearchresults.php?state=" . $getStateValue
		           , "Scrollable"   => "N"
		           , "Selectable"   => "N"
                   , "PageNo"       => $PageNo
		           , "PageSize"     => $PageSize
		           , "TotalRecords" => $noOfRec
                   , "Width"        => "770"
		           , "Height"       => "600"
	        );
	        fTBInit($table);
        } else {
            // Create the table
	        $table = array(
		             "TableName"    => "t_vet_list"
		           , "TemplateLink" => "vetsearchresults.php?postcode=" . $getPostcodeValue
		           , "Scrollable"   => "N"
		           , "Selectable"   => "N"
                   , "PageNo"       => $PageNo
		           , "PageSize"     => $PageSize
		           , "TotalRecords" => $noOfRec
                   , "Width"        => "770"
		           , "Height"       => "600"
	        );
	        fTBInit($table);
        }

	    // Add the header
	    fTBAddRow($table, array("RowType" => "header"));
	    //fTBHighlightRow($table);
	    fTBAddCol($table, array("ColData" => "Suburb"));
	    fTBAddCol($table, array("ColData" => "Clinic ID"));
	    fTBAddCol($table, array("ColData" => "Vet Name"));
	    fTBAddCol($table, array("ColData" => "Company Name"));
	    fTBAddCol($table, array("ColData" => "See Details"));

        // This variable is for skipping records in the following foreach
        // loop for the array
        $fmcCount = 0;

        // Add data rows
	    foreach ($fmac['value'] as $fmc)
	    {
            if ($fmcCount < $EndRow)
            {
                if ($fmcCount >= $StartRow)
                {
					// Add row to table
					fTBAddRow($table, array());
					fTBAddCol($table, array("ColData" => $fmc['Suburb']));
					fTBAddCol($table, array("ColData" => $fmc['myob_account_no']));
					fTBAddCol($table, array("ColData" => $fmc['mainVet_c']));
					fTBAddCol($table, array("ColData" => $fmc['Company Name']));
					fTBAddCol($table, array("ColData" => '<a href="vetsearchresults.php?vid=' . $fmc['_pk_company_id'] . '">See Details</a>'));

                }

                $fmcCount++;
            }
            else
                break;
	    }
    }
    
    // Get vet by id
    function getCompanyByID($id){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
            'filter' => "_pk_company_id eq ".$id,
            'count' => true
        ]);
        $response = $fm->get('Companies', $odataQuery ,$allPages = true );

        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=VetCompanyDetailNotFound');
            fCleanup();
        }
        return $response;
    }

    // Get vets by state
    function getCompanyByState($state){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
            'filter' => "State eq '".$state."' and dont_show_on_web eq null" ,
            'count' => true
        ]);
        $response = $fm->get('Companies', $odataQuery ,$allPages = true );

        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=VetCompaniesStateNotFound');
            fCleanup();
        }
        return $response;
    }
    
    // Get vets by postcode
    function getCompanyByPostcode($postcode){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
            'filter' => "Postcode eq '".$postcode."' and dont_show_on_web eq null" ,
            'count' => true
        ]);
        $response = $fm->get('Companies', $odataQuery ,$allPages = true );

        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=VetCompaniesPostcodeNotFound');
            fCleanup();
        }
        return $response;
    }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
<link rel="stylesheet" type="text/css" href="<?php echo $gaPage['root_directory']; ?>/styles/additional.css" />
</head>

<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td>

<?php
    /*********************** Page Start ***********************/

    //------------------------- IF --------------------------------//
    // If there is a COMPANY ID provided, we will display the details
    // of the specific CLINIC (was vet; changed to company)

    if ($getVetID != ''){
        /************* Fetch data from FileMaker **************/
        $vetQuery= getCompanyByID($getVetID);
        $vets= $vetQuery["data"];
        $vetDetails = $vets["value"][0];

        $vetArray= getVetNames($getVetID);
        // Now we will output all the information gathered below
?>

		<br/><h2 class="orangeheading">Participating Vet Details</h2>

		<div style="overflow:hidden;">
        <table width="48%" align="left" border="0" cellspacing="0" cellpadding="4">
         <tr class="tr1"> <td class="boldtext" width="130">Company Name:</td><td width="10">&nbsp;</td><td><?php echo $vetDetails['Company Name']; ?></td> </tr>
         <tr> <td class="boldtext">Clinic ID:</td><td>&nbsp;</td><td><b><?php echo $vetDetails['myob_account_no']; ?></b></td> </tr>
         <tr class="tr1"> <td class="boldtext">Telephone:</td><td>&nbsp;</td><td><?php echo $vetDetails['Phone']; ?></td> </tr>
         <tr> <td class="boldtext" valign="top">Address:</td><td>&nbsp;</td><td><?php echo $vetDetails['Street']; ?></td> </tr>
         <tr class="tr1"> <td class="boldtext">Suburb:</td><td>&nbsp;</td><td><?php echo $vetDetails['Suburb']; ?></td> </tr>
         <tr> <td class="boldtext">State:</td><td>&nbsp;</td><td><?php echo $vetDetails['State']; ?></td> </tr>
         <tr class="tr1"> <td class="boldtext">Postcode:</td><td>&nbsp;</td><td><?php echo $vetDetails['Postcode']; ?></td> </tr>
         <tr> <td class="boldtext">Fax:</td><td>&nbsp;</td><td><?php echo $vetDetails['Fax']; ?></td> </tr>
         <tr class="tr1"> <td class="boldtext">Week Days:</td><td>&nbsp;</td><td><?php echo $vetDetails['Weekdays']; ?></td> </tr>
         <tr> <td class="boldtext">Saturday:</td><td>&nbsp;</td><td><?php echo $vetDetails['Saturday']; ?></td> </tr>
         <tr class="tr1"> <td class="boldtext">Sunday:</td><td>&nbsp;</td><td><?php echo $vetDetails['Sunday']; ?></td> </tr>
         <tr> <td class="boldtext">House calls:</td><td>&nbsp;</td><td><?php echo $vetDetails['House Calls']; ?></td> </tr>
        </table>

        <table width="48%" align="right" border="0" cellspacing="0" cellpadding="4">
         <tr class="tr1"> <td class="boldtext">Emergency Service:</td><td>&nbsp;</td><td><?php echo $vetDetails['Emergency Service']; ?></td> </tr>
         <tr> <td class="boldtext">Specialities:</td><td>&nbsp;</td><td><?php echo $vetDetails['Specialities']; ?></td> </tr>
         <tr class="tr1"> <td class="boldtext">Other:</td><td>&nbsp;</td><td><?php echo $vetDetails['Other Info']; ?></td> </tr>
         <tr> <td class="boldtext">Email:</td><td>&nbsp;</td><td><a href="mailto:<?php echo $vetDetails['Email']; ?>"><?php echo $vetDetails['Email']; ?></a></td> </tr>
         <tr class="tr1"> <td class="boldtext">Web Site:</td><td>&nbsp;</td><td><a href="<?php echo "http://".$vetDetails['Web Site']; ?>" target="_blank"><?php echo $vetDetails['Web Site']; ?></a></td> </tr>

		 <tr> <td class="boldtext">Vet 1:</td><td>&nbsp;</td><td><b><?php echo $vetArray['Vet1']; ?></b></td> </tr>

		 <tr class="tr1"> <td class="boldtext">Vet 2:</td><td>&nbsp;</td><td><?php echo $vetArray['Vet2']; ?></td> </tr>
         <tr> <td class="boldtext">Vet 3:</td><td>&nbsp;</td><td><?php echo $vetArray['Vet3']; ?></td> </tr>
         <tr class="tr1"> <td class="boldtext">Vet 4:</td><td>&nbsp;</td><td><?php echo $vetArray['Vet4']; ?></td> </tr>
         <tr> <td class="boldtext">Vet 5:</td><td>&nbsp;</td><td><?php echo $vetArray['Vet5']; ?></td> </tr>
         <tr class="tr1"> <td class="boldtext">Vet 6:</td><td>&nbsp;</td><td><?php echo $vetArray['Vet6']; ?></td> </tr>
		</table>
		&nbsp;
		</div>

		<div style="overflow:hidden;">
		<br />
		<a href="javascript:history.go(-1);"><b>Return to Search Results</b></a>
		<br/><br/>
		</div>

<?php

    }elseif($getStateValue != ''){
        /**************** If State Query Form *****************/
        $vetQuery= getCompanyByState($getStateValue);
        $vets= $vetQuery["data"];

        echo '<br/><h2 class="orangeheading">Participating Vets found for ' . $getStateValue . '</h2>';

        makeTable($vets, $vets['count']);
        
        // Now we will output all the information contained in the constructed table
        echo '<br/>';
        fTBWriteTable($table);
		echo '<br/>';
		echo '<a href="vets.php"><b>Search Again</b></a>';
		echo '<br/><br/>';

    }elseif($getPostcodeValue != ''){
        /*************** If Postcode Query Form ***************/
        $vetQuery= getCompanyByPostcode($getPostcodeValue);
        $vets= $vetQuery["data"];

        echo '<br/><h2 class="orangeheading">Participating Vets found for ' . $getPostcodeValue . '</h2>';

        makeTable($vets, $vets['count']);

        // Now we will output all the information contained in the constructed table
        echo '<br/>';
        fTBWriteTable($table);
		echo '<br/>';
		echo '<a href="vets.php"><b>Search Again</b></a>';
		echo '<br/><br/>';
    }
    
?>

</td>

<?php
/************************* Page End **************************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>