<?php
	use setasign\Fpdi\Tcpdf\Fpdi;

	function generate_invoice_from_buffer($fn) {
		global $gaPrintDir;

		/********************** End Output Buffering *************/
		$sHtmlContent = ob_get_clean();


		require_once('tcpdf/tcpdf.php');
        require_once('fpdi/src/autoload.php');

		$pdf = new Fpdi(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// set font
		$pdf->SetFont('dejavusans', '', 10);

		// add a page
		$pdf->AddPage();

		// output the HTML content
		$pdf->writeHTML($sHtmlContent, true, false, true, false, '');
		$fileName = $gaPrintDir.'/'.$fn.'.pdf';
		$pdf->Output($fileName, 'I');
        var_dump($pdf);
        die;
	}
	
	function generate_pdf_from_buffer($fn) {
		global $gaPrintDir;


		/********************** End Output Buffering *************/
		$sHtmlContent = ob_get_clean();

        
		require_once('tcpdf/tcpdf.php');
        require_once('fpdi/src/autoload.php');

		$pdf = new Fpdi(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// set font
		$pdf->SetFont('dejavusans', '', 10);

		// add a page
		$pdf->AddPage();

		// output the HTML content
		$pdf->writeHTML($sHtmlContent, true, false, true, false, '');
		$fileName = $gaPrintDir.'/'.$fn.'.pdf';
		$pdf->Output($fileName, 'F');
		
	
        $cert = new Fpdi();

        $cert->setSourceFile($fileName);
        $templateId = $cert->importPage(1);
        $cert->AddPage();
        $cert->useImportedPage($templateId);

		//Change the following line when promoting the file to the server
       // $cert->setSourceFile('/home/petsafeweb/public_html/forms/Petsafe_Change_Address.pdf');
		$cert->setSourceFile('/Users/johnmuffett/Documents/VS Codium Projects/Petsafe/forms/Petsafe_Change_Address.pdf');	// ! FIX
        $templateId = $cert->importPage(1);

        $cert->AddPage();
        $cert->useImportedPage($templateId);
	
		//Close and output PDF document
        $cert->Output($fn.'.pdf','I');

	}

	function email_pdf_from_buffer($fn) {
		global $gaPrintDir, $owner_email, $petname;

		/********************** End Output Buffering *************/
		$sHtmlContent = ob_get_clean();
	

		require_once('tcpdf/tcpdf.php');
        require_once('fpdi/src/autoload.php');

		$pdf = new Fpdi(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// set font
		$pdf->SetFont('dejavusans', '', 10);

		// add a page
		$pdf->AddPage();

		// output the HTML content
		$pdf->writeHTML($sHtmlContent, true, false, true, false, '');

		//Close and output PDF document
		$fileName = $gaPrintDir.'/'.$fn.'.pdf';
		$pdf->Output($fileName, 'F');
        
        $cert = new Fpdi();

        $cert->setSourceFile($fileName);
        $templateId = $cert->importPage(1);
        $cert->AddPage();
        $cert->useImportedPage($templateId);

        $cert->setSourceFile('/home/petsafeweb/public_html/forms/Petsafe_Change_Address.pdf');
        $templateId = $cert->importPage(1);

        $cert->AddPage();
        $cert->useImportedPage($templateId);
	
		//Close and output PDF document
		$attachment = $cert->Output($fileName, 'F');

		if($owner_email == ''){
			echo 'Email address is empty. Cannot send email.';
			exit;
		}
		
		//email the pdf
		if(!empty($fileName)){

       			$theEmail = SendCertificate($owner_email,$fileName,$petname);
    		}else{
        		print_r('Could not trace file path');
    		}     
	}
	
	function SendCertificate($EmailAddress,$FileNamePath,$Petname){

		$to = $EmailAddress;
		$petname = $Petname;
		$subject = 'PetSafe Certificate for "' . $petname . '".';
		$body = 'Attached is your PetSafe Certificate for "' . $petname . '".';
		$attachments = array($FileNamePath);               

        $result = send_mail($subject, $body, $to, $attachments );
		if($result){
			echo '<br>';
			echo 'Certificates have been sent to <b>' . $to . '</b>';
		}else{
			echo 'Certificates NOT sent to <b>' . $to . '</b>';	
		}
    }
?>