<?php
    /***********************************************************************************
	*   Filename    : articles.php
	*   Description : Petsafe Articles page
	*
	*   Date        Modification By      Description
	*   25/01/2009  Kenneth Ho           Initial Creation
	*   22/08/2022  John Muffett         Reworked for Data API
    *   15/07/2025  John Muffett         Reworked for oData API
    *
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Articles';
	$gaPage['root_directory'] = '..';

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('cat', $_GET, '');
    fDefaultParameter('aid', $_GET, '');

    $getCatValue = $_GET['cat'];
    $getArtValue = $_GET['aid'];

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>
<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td valign="top">
<br/>

<?php
    /*************************** Page Functions ***********************/
    // Get all categories
    function getArticleCategories(){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
            'orderby' => 'Category asc',
            'select' => ['Category'],
            'count' => true
        ]);
        $response = $fm->get('articleCategories', $odataQuery ,$allPages = true );
   
        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=NoArticleCatRecord');
            fCleanup();
        }
        return $response;
    }

    // Get all articles according to provided category parameter
    function getArticlesByCat($cat){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
            'filter' => "Category eq '".$cat."'",
            //'orderby' => 'Category asc',
            //'top' => 50,
            //'expand' => 'Company',
            'select' => ['_pk_id','articleName'],
            'count' => true
        ]);
        $response = $fm->get('Articles', $odataQuery ,$allPages = true );

        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=NoArticleCatRecord');
            fCleanup();
        }
        return $response;
    }

    // Get articles by article id
    function getArticleByID($id){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
            'filter' => "_pk_id eq ".$id,
            'select' => ['articleName','articleContent'],
            'count' => true
        ]);
        $response = $fm->get('Articles', $odataQuery ,$allPages = true );

        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=NoArticleCatRecord');
            fCleanup();
        }
        return $response;
    }

    /*************************** Page Start ***************************/


If($getCatValue == '' & $getArtValue == ''){
    $categoryQuery= getArticleCategories();
    $categories = $categoryQuery["data"];
	echo '<h2 class="greenheading">Articles</h2>';
	echo '<div class="bodytext">';
	echo 'We have put together a range of articles to help you and your pet get the most out of your relationship.';
	echo '</div>';
    foreach($categories['value'] as $category){
        $catName = $category['Category'];                        // Category field value
        if ($getCatValue == '') echo '<br /><a href="articles.php?cat=' . $catName.  '"><b>' . $catName . '</b></a><br />';
    }
}elseif($getArtValue == ''){
    /**** If there is a category param, display the relevant articles ***/

    $articleQuery= getArticlesByCat($getCatValue);
    $articles = $articleQuery["data"];

    echo '<h2 class="greenheading">Articles for ' . $getCatValue . '</h2>';
    foreach ($articles['value'] as $article){

        $id = $article['_pk_id'];        // RecordID field value
        $title = $article['articleName'];     // Article Name field value

        echo '<a href="articles.php?&aid=' . $id . '"><b>' .$title . '</b></a><br /><br />';
    }
}elseif($getArtValue != ''){
    /**** If there is a article param, display the relevant article ***/

    $articleQuery= getArticleById($getArtValue);
    $articles = $articleQuery['data'];

    foreach($articles['value'] as $article){
        echo '<h2 class="greenheading">' . $article['articleName']. '</h2>';
        echo html_entity_decode($article['articleContent']) . '<br />';
    }

}


   
?>

<br/><br/><br/><br/><br/><br/>
<div><img src="<?php echo $gaPage['root_directory']; ?>/images/petsafe_com_au.jpg" />&nbsp;</div>
</td>

<?php
if ($getArtValue == '') {
	echo '<td valign="top">';
	echo '<div><img align="right" src="' . $gaPage['root_directory'] . '/images/dog_reading.jpg" />&nbsp;</div>';
	echo '</td>';
}

/************************* Page End **************************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>