<?php
    /***********************************************************************************
    *   Filename    : invoice_search.php
	*   Description : Invoice List page
	* 
	*   Date        Modification By      Description
	*   23/01/2009  Kenneth Ho           Initial Creation
	*   22/08/2022  John Muffett         Reworked for Data API
   	*
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Invoice Search';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('view', $_GET, '');
	$view = $_GET['view'];


    /************ Only allow logged in vets to this area ************/
	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('myaccount.php?err_code=NotAuthorised');
		fCleanup();
	}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
<script language="JavaScript" type="text/javascript"><!--
	function checkForm(myform)
	{
		// Check the invoice date from
		if (myform.elements['invoice_date_from'].value != '')
		{
			invoice_date_from = parseDateString(myform.elements['invoice_date_from'].value);
			if (invoice_date_from == null)
			{
				alert('Invalid invoice date from entered!\n\nPlease enter the date in the format dd/mm/yyyy.');
				myform.elements['invoice_date_from'].select();
				return false
			}
		}

		// Check the invoice date to
		if (myform.elements['invoice_date_to'].value != '')
		{
			invoice_date_to = parseDateString(myform.elements['invoice_date_to'].value);
			if (invoice_date_to == null)
			{
				alert('Invalid invoice date to entered!\n\nPlease enter the date in the format dd/mm/yyyy.');
				myform.elements['invoice_date_to'].select();
				return false
			}
		}

		// Check invoice date to is after invoice date from
		if (myform.elements['invoice_date_to'].value != '' && myform.elements['invoice_date_to'].value != '')
		{
			if (invoice_date_to < invoice_date_from)
			{
				alert('The invoice date to must be after the invoice date from.');
				myform.elements['invoice_date_to'].select();
				return false
			}
		}

		// Check the due date from
		if (myform.elements['due_date_from'].value != '')
		{
			due_date_from = parseDateString(myform.elements['due_date_from'].value);
			if (due_date_from == null)
			{
				alert('Invalid due date from entered!\n\nPlease enter the date in the format dd/mm/yyyy.');
				myform.elements['due_date_from'].select();
				return false
			}
		}

		// Check the due date to
		if (myform.elements['due_date_to'].value != '')
		{
			due_date_to = parseDateString(myform.elements['due_date_to'].value);
			if (due_date_to == null)
			{
				alert('Invalid due date to entered!\n\nPlease enter the date in the format dd/mm/yyyy.');
				myform.elements['due_date_to'].select();
				return false
			}
		}

		// Check due date to is after due date from
		if (myform.elements['due_date_to'].value != '' && myform.elements['due_date_to'].value != '')
		{
			if (due_date_to < due_date_from)
			{
				alert('The due date to must be after the due date from.');
				myform.elements['due_date_to'].select();
				return false
			}
		}

		return true;
	}

	function parseDateString(v)
	{
		if(v == '')
		{
			return null;
		}

		// Split into day month year
		adv = v.split('/');
		if (adv.length != 3)
		{
			return null;
		}

		// Check they are all numeric
		if (isNaN(parseInt(adv[0], 10)) || isNaN(parseInt(adv[1], 10)) || isNaN(parseInt(adv[2], 10)))
		{
			return null;
		}

		// Check year is valid
		if (parseInt(adv[2], 10) < 2000 || parseInt(adv[2], 10) > 3000)
		{
			return null;
		}

		// Create Date
		dt =  new Date(parseInt(adv[2], 10), parseInt(adv[1], 10) - 1, parseInt(adv[0], 10));

		// Check is valid
		if (dt.getDate() != parseInt(adv[0], 10))
		{
			return null;
		}

		return dt;
	}
//--></script>
</head>

<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td valign="top">

<br/>

<h2 class="orangeheading">Invoice Search</h2>

<form action="invoice_list.php" method="get" onsubmit="return checkForm(this);">
<input type="hidden" name="show" value="search">
<input type="hidden" name="view" value="<?php echo $view; ?>">
<table border="0" cellpadding="2" cellspacing="0" width="70%">
	<tr><td colspan="2"><table border="0" cellpadding="2" cellspacing="0" width="100%">
		<tr>
			<td align="left"><a href="invoice_list.php?view=<?php echo $view; ?>"><b>Invoices Due</b></a> &nbsp; | &nbsp; <a href="invoice_list.php?show=paid&view=<?php echo $view; ?>"><b>Invoices Paid</b></a> &nbsp; | &nbsp; <a href="invoice_search.php?view=<?php echo $view; ?>"><b>Search</b></a></td>
		</tr>
	</table></td></tr>

	<tr><td colspan="2"><hr/></td></tr>
	<tr>
		<td><b>Status</b></td>
		<td><table border="0" cellpadding="2" cellspacing="0">
			<tr>
				<td><input type="radio" name="invoice_status" value="All" checked>&nbsp;All</td>
				<td><input type="radio" name="invoice_status" value="Paid">&nbsp;Paid</td>
				<td><input type="radio" name="invoice_status" value="Unpaid">&nbsp;Unpaid</td>
			</tr>
		</table></td>
	</tr>
	<tr>
		<td><b>Invoices Date</b></td>
		<td><table border="0" cellpadding="2" cellspacing="0">
			<tr>
				<td>From:</td>
				<td><input type="text" name="invoice_date_from" size="10" /></td>
				<td>To:</td>
				<td><input type="text" name="invoice_date_to" size="10" /></td>
			</tr>
		</table></td>
	</tr>
	<tr>
		<td><b>Due Date Date</b></td>
		<td><table border="0" cellpadding="2" cellspacing="0">
			<tr>
				<td>From:</td>
				<td><input type="text" name="due_date_from" size="10" /></td>
				<td>To:</td>
				<td><input type="text" name="due_date_to" size="10" /></td>
			</tr>
		</table></td>
	</tr>
	<tr>
		<td><b>&nbsp;</b></td>
		<td><input type="submit" name="submit" value=" Search " /></td>
	</tr>

	<tr><td colspan="2"><hr/></td></tr>
</table>
</form>

<br/><br/>

<?php
/************************* Page End **************************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>