<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   14/11/2019	John Muffett	     Clean up of code to get working with PHP 7
	*   22/08/2022  John Muffett         Reworked for Data API
   	*
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Defaults *********************/
	fDefaultParameter('memberid', $_POST, '');
	fDefaultParameter('password', $_POST, '');
	fDefaultParameter('query', $_POST, '');
	fDefaultParameter('searchtype', $_POST, '');

	$getMemberID = $_POST['memberid'];
	$getPassword = $_POST['password'];
	$getQueryValue = $_POST['query'];
	$getSearchType = $_POST['searchtype'];

	/*********************** Processing Start **********************/
	/************ Login Member ************/

	//if ($_SESSION['LoggedIn'] != 0){
		// Redirect
	//	fRedirect('index.php?err_code=LoggedIn');
	//	fCleanup();
	//}

	// check if valid member
	// if yes, create/refresh session vars
	// if not, reset session and throw user to login page

	if ($getMemberID == '' or $getPassword == ''){
		// Redirect
		fRedirect('memberlogin.php');
		fCleanup();
	}
	else {
        $aRequest = array();
		// check login
		if (strpos($getMemberID,'@') === false){
	        $aRequest['_pk_member_id'] = '="' . str_ireplace('PS','',$getMemberID) . '"'; // login is an ID
		}
		else {
			//$aRequest['Email'] = '="' . $getMemberID . '"'; // login is an Email
		}
		if ($getPassword != $gaFM['petsafe']['master_password']){
			// check password if NOT master password
	        $aRequest['Password'] = '=="' . $getPassword . '"';
		}

        $fmrLogin = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);

		if ($fmrLogin === FALSE || $fmrLogin["response"]["dataInfo"]["foundCount"] != 1){
			//no results
			// Redirect
			fRedirect('memberlogin.php?err_code=Incorrect');
			fCleanup();
		}
		else {
			// valid user - log the user in
			$fmcLogin = $fmrLogin["response"]["data"][0];

			// set session vars
			$_SESSION['LoggedIn'] = 1;
			$_SESSION['MemberID'] = $fmcLogin['fieldData']['_pk_member_id'];
            $_SESSION['cookieid'] = '';
            
			if ($getPassword == $gaFM['petsafe']['master_password']){
				$_SESSION['IsAdminLogin'] = 1; // was an admin login
			}

			// ADD TO LOG: login action
	        $aInsert['_sk_member_id'] = $_SESSION['MemberID'];
			$aInsert['description'] = 'Logged in as Owner';
			$aInsert['is_web_admin_login'] = isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0;
			
			$fmrLog = fFMPerformInsert('petsafe', 'Web - Audit', $aInsert);

			// redirect to memberarea
			if ($getQueryValue == ''){
				fRedirect('memberarea.php');
				fCleanup();
			}
			else {
				// redirect to search results
				fRedirect('indexsearchresults.php?getquery=' . $getQueryValue . '&searchtype=' . $getSearchType);
				fCleanup();
			}
		}
	}



/************************ Processing End ***********************/

fCleanup();

?>