<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	* 	23/08/2022  John Muffett         Reworked for Data API
    *
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/*********************** My Account page **********************/
	/************ Forward Member or Vet to the correct area ************/

	if ($_SESSION['LoggedIn'] == 0){
		// Not authorised - Redirect
		fRedirect('index.php?err_code=NotLoggedIn');
		fCleanup();
	}

	if ($_SESSION['VetID'] != ''){
		// throw to vet area
		fRedirect('vetarea.php');
		fCleanup();
	}
	else if ($_SESSION['MemberID'] != ''){
		// throw to member area
		fRedirect('memberarea.php');
		fCleanup();
	}
	else {
		// Not authorised - Redirect
		fRedirect('logout.php');
		fCleanup();
	}


/************************ Processing End ***********************/

fCleanup();

?>