<?php
    /***********************************************************************************
	*   Filename    : pets.php
	*   Description : List pets for member
	*
	*   Date        Modification By      Description
	*   25/01/2009  Kenneth Ho           Initial Creation
	*   23/08/2022  John Muffett         Rework to support Data API
	* 
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Pets List';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'purple';

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');

    /************ Only allow logged in members to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['MemberID'] == ''){
		// Redirect
		fRedirect('myaccount.php?err_code=NotAuthorised');
		fCleanup();
	}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td valign="top">

<br/>

<h2 class="purpleheading">Your Registered Pets</h2>

<table border="0" cellpadding="2" cellspacing="0" width="70%">

<?php
    /*************************** Page Start ***************************/

	// Get all pets under the member's ownership
	$aRequest = array();
    $aRequest['_sk_member_id'] = '="' . $_SESSION['MemberID'] . '"';
//	$aSort = array();
//	$Sort[0] = 'creation_date';

    $fmrPets = fFMPerformFind('petsafe', 'Web - Pets', $aRequest);
	if ($fmrPets === FALSE || $fmrPets["response"]["dataInfo"]["foundCount"] < 1){
		// no pets
		echo '<tr><td colspan="4">&nbsp;</td></tr>';
		echo '<tr><td colspan="4">None.</td></tr>';
		echo '<tr><td colspan="4">&nbsp;</td></tr>';

	} else {
		$fmcPetsList = $fmrPets["response"]["data"];
		$fmcPetsList = array_reverse($fmcPetsList);

		// Loop and show details of each pet
		foreach ($fmcPetsList as $pet_record)
		{
			// get chip/clinic details
			$aRequest = array();
			$aRequest['_sk_pet_id'] = '="' . $pet_record['fieldData']['_pk_pet_id'] . '"';
			$aSort = array();
			$Sort[0] = 'implanted_date';
			//$aRequest['Registered'] = '="Yes"';

			$fmrChip = fFMPerformFind('petsafe', 'Web - Chips', $aRequest, $aSort, null, FALSE);
			if ($fmrChip === FALSE || $fmrChip["response"]["dataInfo"]["foundCount"] < 1){
				$microchip = '';
				$microchip2 = '';
				$clinicID = '';
				$accountnumber = '';
				$clinicname = '';

			} else {
				$fmcChip = $fmrChip["response"]["data"];
				$i = 0;
				$microchip2 = '';
				foreach ($fmcChip as $chip_record){
					$i++;
					if ($i == 1){
						$microchip = $chip_record['fieldData']['Chip No'];
						$clinicID = $chip_record['fieldData']['_sk_implanter_clinic_id'];
						$accountnumber = $chip_record['fieldData']['chip_Clinic::myob_account_no'];
						$clinicname = $chip_record['fieldData']['chip_Clinic::Company Name'];
						$ImplantDate = $chip_record['fieldData']['implanted_date'];
					} else {
						$microchip2 = $chip_record['fieldData']['Chip No'];
						break;
					}
				}
			}

			// get values
			$petid = $pet_record['fieldData']['_pk_pet_id'];
			$petname = $pet_record['fieldData']['Name'];
			$species = $pet_record['fieldData']['Type'];
			$colour = $pet_record['fieldData']['Colour'];
			$breed = $pet_record['fieldData']['Breed'];
			$dob = $pet_record['fieldData']['DOB'];
			$sex = $pet_record['fieldData']['Sex'];
			$desexed = $pet_record['fieldData']['Desexed'];
			$savage = $pet_record['fieldData']['Savage'];

			$BreederID = $pet_record['fieldData']['breederID'];
			$DistinguishingMarks = $pet_record['fieldData']['distinguishingMarks'];
			//$ImplantDate = $pet_record['fieldData']['Implant Date'];

			$petsafetag = $pet_record['fieldData']['Tag'];
			$street = $pet_record['fieldData']['displayStreet'];
			$suburb = $pet_record['fieldData']['displaySuburb'];
			$state = $pet_record['fieldData']['displayState'];
			$postcode = $pet_record['fieldData']['displayPostcode'];

			// create table
			echo '<tr><td class="boldtext">Pet\'s Name</td><td>&nbsp;' . $petname . '</td><td class="boldtext">Microchip No.</td><td>&nbsp;' . $microchip . '</td></tr>';
			echo '<tr><td class="boldtext">Species</td><td>&nbsp;' . $species . '</td><td class="boldtext">Microchip No. (2)</td><td>&nbsp;' . $microchip2 . '</td></tr>';
			echo '<tr><td class="boldtext">Colour</td><td>&nbsp;' . $colour . '</td><td class="boldtext">PetSafe Tag No.</td><td>&nbsp;' . $petsafetag . '</td></tr>';
			echo '<tr><td class="boldtext">Breed</td><td>&nbsp;' . $breed . '</td><td class="boldtext">Clinic ID / Name</td><td>&nbsp;' . $accountnumber . ': ' . $clinicname . '</td></tr>';
			echo '<tr><td class="boldtext">DOB</td><td>&nbsp;' . fReformatDate($dob) . '</td><td class="boldtext">Street</td><td>&nbsp;' . $street . '</td></tr>';
			echo '<tr><td class="boldtext">Sex</td><td>&nbsp;' . $sex . '</td><td class="boldtext">Suburb</td><td>&nbsp;' . $suburb . '</td></tr>';
			echo '<tr><td class="boldtext">Desexed</td><td>&nbsp;' . $desexed . '</td><td class="boldtext">State</td><td>&nbsp;' . $state . '</td></tr>';
			echo '<tr><td class="boldtext">Savage Status</td><td>&nbsp;' . $savage . '</td><td class="boldtext">Postcode</td><td>&nbsp;' . $postcode . '</td></tr>';
			echo '<tr><td class="boldtext">Breeder ID</td><td>&nbsp;' . $BreederID . '</td><td class="boldtext">Implant Date</td><td>&nbsp;' . fReformatDate($ImplantDate). '</td></tr>';
			echo '<tr><td class="boldtext">Distinguishing Marks</td><td colspan="3">&nbsp;' . $DistinguishingMarks . '</td></tr>';
			echo '<tr><td colspan="4"><br/><form name="form' . $petid . '" method="post" action="pets_certificate.php" target="_blank">';
			echo '<a href="pets_detail.php?petid=' . $petid . '"><b>Change Pet Details</b></a>';
			echo '&nbsp; | &nbsp;';
			echo '<input type="submit" name="print' . $petid . '" value="View & Print Certificate" />';

				echo '&nbsp; | &nbsp;';
				echo '<input type="submit" name="email" value="Email Certificate"/>';

			echo '<input type="hidden" name="petid" value="' . $petid . '" />';
			echo '<input type="hidden" name="mid" value="' . $_SESSION['MemberID'] . '" />';
			echo '</form></td></tr>';
			echo '<tr><td colspan="4">&nbsp;</td></tr>';
			echo '<tr><td colspan="4"><hr/></td></tr>';
			echo '<tr><td colspan="4">&nbsp;</td></tr>';
		}
    }
?>

</table>

<?php
/************************* Page End **************************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>