<?php
	/***********************************************************************************
	*   Copyright Keysoft Pty Ltd 2009
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';

	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('id', $_GET, '');

	// invalid page entry
	$cookieid = $_GET['id'];
	if (trim($cookieid) == ''){
		fRedirect('register.php');
		fCleanup();
	}

	//invalid cookie id check
	$aRequest = array();
	$aRequest['cookie_transaction_id'] = '="' . $cookieid . '"';
	$fmrTransaction = fFMPerformFind('petsafe', 'All Fields - Web_Payments', $aRequest);
	if ($fmrTransaction === FALSE || $fmrTransaction["response"]["dataInfo"]["foundCount"] != 1){
		// invalid cookie id
		fRedirect('register.php');
		fCleanup();

	} else {
		// cookie exists - retrieve info
		$fmcTransaction = $fmrTransaction["response"]["data"][0];
		if ($_SESSION['LoggedIn'] != 1){
			$name = $fmcTransaction['fieldData']['owner_first_name'] . ' ' . $fmcTransaction['fieldData']['owner_last_name'];
			$address = $fmcTransaction['fieldData']['owner_street'];
			$city = $fmcTransaction['fieldData']['owner_suburb'];
			$state = $fmcTransaction['fieldData']['owner_state'];
			$postcode = $fmcTransaction['fieldData']['owner_postcode'];
			$country = 'AUSTRALIA';
			$phone = $fmcTransaction['fieldData']['owner_home_phone'];
			$email = $fmcTransaction['fieldData']['owner_email'];

			// get payment details

			$aRequest['item_code'] = '=="PSRP"';
			$fmrPrice = fFMPerformFind('petsafe', 'All Fields - Item_Type', $aRequest);
			$fmcPrice = $fmrPrice["response"]["data"][0];
			$price = $fmcPrice['fieldData']['price'];

		} else if ($_SESSION['VetID'] != '') {
			// get vet details
			$aRequest = array();
			$aRequest['_pk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
			$fmrVet = fFMPerformFind('petsafe', 'All Fields - Vet', $aRequest);
			$fmcVet = $fmrVet["response"]["data"][0];
			$name = $fmcVet['fieldData']['vet_first_name'] . ' ' . $fmcVet['fieldData']['vet_last_name'];
			$country = 'AUSTRALIA';
			$phone = $fmcVet['fieldData']['vet_phone'];
			$email = $fmcVet['fieldData']['vet_email'];
			$address = $fmcVet['fieldData']['vet_street'];
			$city = $fmcVet['fieldData']['vet_suburb'];
			$state = $fmcVet['fieldData']['vet_state'];
			$postcode =  $fmcVet['fieldData']['vet_postcode'];
			$companyid = $fmcTransaction['fieldData']['_sk_company_id'];
			
			$aRequest = array();
			$aRequest['_pk_company_id'] = '="' . $companyid . '"';
			$fmrCompany = fFMPerformFind('petsafe', 'All Fields - Companies', $aRequest);
			$fmcCompany = $fmrCompany["response"]["data"][0];
			$pricebracket = $fmcCompany['fieldData']['price_bracket'];

			// get payment details
			if ($pricebracket != ''){
				$aRequest = array();
				$aRequest['pbq_Price_Bracket::price_bracket'] = '=="' . $pricebracket . '"';
				$aRequest['pbq_Price_Bracket::item_code'] = '=="PSRV"';
				$aSort[]=["fieldName" => "qty", "sortOrder" => "ascend"];
				$fmrPrice = fFMPerformFind('petsafe', 'WEB - Price_Bracket_Qty', $aRequest, $aSort);
				if ($fmrPrice === FALSE || $fmrPrice["response"]["dataInfo"]["foundCount"] < 1){
					// get default pricing because price bracket not found
					$aRequest = array();
					$aRequest['item_code'] = '=="PSRV"';
					$fmrPrice = fFMPerformFind('petsafe', 'All Fields - Item_Type', $aRequest);
					$fmcPrice = $fmrPrice["response"]["data"][0];
					$price = $fmcPrice['fieldData']['price'];
				} else {
					$fmcPrice = $fmrPrice["response"]["data"][0];
					$price = $fmcPrice['fieldData']['price'];
				}
			} else {
				// get default pricing because price bracket not found
				$aRequest = array();
				$aRequest['item_code'] = '=="PSRV"';
				$fmrPrice = fFMPerformFind('petsafe', 'All Fields - Item_Type', $aRequest);
				$fmcPrice = $fmrPrice["response"]["data"][0];
				$price = $fmcPrice['fieldData']['price'];
			}

		} else if ($_SESSION['MemberID'] != '') {
			$aRequest = array();
			$aRequest['_pk_member_id'] = '="' . $_SESSION['MemberID'] . '"';
			$fmrOwner = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
			$fmcOwner = $fmrOwner["response"]["data"][0];
			// get member details
			$name = $fmcOwner['fieldData']['Given Name'] . ' ' . $fmcOwner['fieldData']['Last Name'];
			$address = $fmcOwner['fieldData']['Street'];
			$city = $fmcOwner['fieldData']['Suburb'];
			$state = $fmcOwner['fieldData']['State'];
			$postcode = $fmcOwner['fieldData']['Postcode'];
			$country = 'AUSTRALIA';
			$phone = $fmcOwner['fieldData']['Home Phone'];
			$email = $fmcOwner['fieldData']['Email'];

			// get payment details
			$aRequest = array();
			$aRequest['item_code'] = '=="PSRP"';
			$fmrPrice = fFMPerformFind('petsafe', 'All Fields - Item_Type', $aRequest);
			$fmcPrice = $fmrPrice["response"]["data"][0];
			$price = $fmcPrice['fieldData']['price'];
		}
	}
	$price = round($price * 1.1,2); // plus gst

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<br/><h2 class="greenheading">New Registration: Payment</h2><br/>

<div>Your new pet registration will cost $<?php echo $price; ?>.</div>
<br/>
<form method="POST" action="https://pilot-payflowlink.paypal.com">

<input type="hidden" name="LOGIN" value="PetsafeF"/>
<input type="hidden" name="PARTNER" value="VSA"/>
<input type="hidden" name="DESCRIPTION" value="PetSafe Registration"/>
<input type="hidden" name="AMOUNT" value="<?php echo $price; ?>"/>
<input type="hidden" name="TYPE" value="S"/>
<input type="hidden" name="NAME" value="<?php echo $name; ?>"/>
<input type="hidden" name="PHONE" value="<?php echo $phone; ?>"/>
<input type="hidden" name="EMAIL" value="<?php echo $email; ?>"/>
<input type="hidden" name="ADDRESS" value="<?php echo $address; ?>"/>
<input type="hidden" name="CITY" value="<?php echo $city; ?>"/>
<input type="hidden" name="ZIP" value="<?php echo $postcode; ?>"/>
<!--
<input type="hidden" name="NAMETOSHIP" value="<?php echo $name; ?>"/>
<input type="hidden" name="ADDRESSTOSHIP" value="<?php echo $address; ?>"/>
<input type="hidden" name="CITYTOSHIP" value="<?php echo $city; ?>"/>
<input type="hidden" name="STATETOSHIP" value="<?php echo $state; ?>"/>
<input type="hidden" name="ZIPTOSHIP" value="<?php echo $postcode; ?>"/>
<input type="hidden" name="COUNTRYTOSHIP" value="<?php echo $country; ?>"/>
-->
<input type="hidden" name="USER1" value="<?php echo $cookieid; ?>"/>
<input type="hidden" name="USER2" value=""/>
<input type="hidden" name="USER3" value=""/>
<input type="hidden" name="METHOD" value="CC"/>
<input type="hidden" name="ECHODATA" value="True"/>
<input type="hidden" name="VERBOSITY" value="HIGH"/>

<input type="submit" value="Click Here to Purchase"/>
<div class="smalltext"><b>Credit Card payment is processed securely by Verisign.</b></div>
</form>

<br><br>

</td>

<td valign="top">
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/cockatoo_help.jpg" />&nbsp;</div>
</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>
