<?php

	function &fTBGetSearchData(&$aArguments){
		// Defaults
		fRequireParameter("Prefix",      $aArguments);
		fDefaultParameter("Postfix",     $aArguments, "");
		fDefaultParameter("InvalidPage", $aArguments, "");

		// Check search data exists
		if (!array_key_exists('s_'.$aArguments['Prefix'].'list'.$aArguments['Postfix'], $_SESSION['SearchData']))
		{
			// Redirect to the search page
			header("Location: ".$aArguments['InvalidPage']);
		}

		// Get the search data
		$aSearchData = &$_SESSION['SearchData']['s_'.$aArguments['Prefix'].'list'.$aArguments['Postfix']];
		$aSearchData['PageSize'] = fTBGetPageSize($aSearchData);
		$aSearchData['PageNo']   = fTBGetPageNo($aSearchData);
		$aSearchData['StartRow'] = ($aSearchData['PageNo'] - 1) * $aSearchData['PageSize'];
		$aSearchData['EndRow']   = $aSearchData['PageNo'] * $aSearchData['PageSize'];

		return $aSearchData;
	}

	function &fTBCreateSearchData(&$aArguments){
		// Defaults
		fRequireParameter("Prefix",      $aArguments);
		fDefaultParameter("Postfix",     $aArguments, "");
		fRequireParameter("SortBy",      $aArguments);
		fRequireParameter("SortDir",     $aArguments);
		fRequireParameter("OrderBy",     $aArguments);

		// Create the search data
		$aSearchData = array();

		$aSearchData['TableName'] = 't_'.$aArguments['Prefix'].'list'.$aArguments['Postfix'];
		$aSearchData['SortBy']    = $aArguments['SortBy'];
		$aSearchData['SortDir']   = $aArguments['SortDir'];
		$aSearchData['OrderBy']   = $aArguments['OrderBy'];
		
		// Save to the session
		$_SESSION['SearchData']['s_'.$aArguments['Prefix'].'list'.$aArguments['Postfix']] = &$aSearchData;

		// Return the search data
		return $aSearchData;
	}

	function fTBGetPageNo(&$aSearchData){
		// Set the current page
		if (array_key_exists($aSearchData['TableName'].'_pageno', $_GET))
		{
			$PageNo = $_GET[$aSearchData['TableName'].'_pageno'];
		}
		else if (array_key_exists('PageNo', $aSearchData))
		{
			$PageNo =  $aSearchData['PageNo'];
		}
		else
		{
			$PageNo = 1;
		}

		return $PageNo;
	}

	function fTBGetPageSize(&$aSearchData){
		// Set the page size
		if (array_key_exists('PageSize', $aSearchData))
		{
			$PageSize = $aSearchData['PageSize'];
		}
		else
		{
			$PageSize = $_SESSION['SearchData']['Defaults']['PageSize'];
		}

		return $PageSize;
	}

	function fTBInit(&$aTableData){
		// Globals
		global $gaPage;

		// Get a unique tables no (per request)
		fDefaultParameter("TableNo", $gaPage, "0");
		$gaPage['TableNo'] = $gaPage['TableNo'] + 1;

		// Defaults
		fDefaultParameter("TableName",     $aTableData, "");
		fDefaultParameter("Scrollable",    $aTableData, "N");
		fDefaultParameter("Selectable",    $aTableData, "N");
		fDefaultParameter("Width",         $aTableData, "580");
		fDefaultParameter("Height",        $aTableData, "340");
		fDefaultParameter("SortLink",      $aTableData, "");
		fDefaultParameter("FilterLink",    $aTableData, "");
		fDefaultParameter("SortBy",        $aTableData, "");
		fDefaultParameter("SortDir",       $aTableData, "");
		fDefaultParameter("ExportLink",    $aTableData, "");
		fDefaultParameter("SearchLink",    $aTableData, "");
		fDefaultParameter("IndexLink",     $aTableData, "");
		fDefaultParameter("TemplateLink",  $aTableData, "");
		fDefaultParameter("PageNo",        $aTableData, "");
		fDefaultParameter("PageSize",      $aTableData, "");
		fDefaultParameter("TotalRecords",  $aTableData, "");
		fDefaultParameter("ShowHeader",    $aTableData, "Y");

		// Initialise
		$aTableData['TableNo']       = $gaPage['TableNo'];
		$aTableData['TotalColSpan']  = 0;
		$aTableData['Rows']          = array();

		// Template Link
		if (strpos($aTableData['TemplateLink'], "?") !== false)
		{
			$aTableData['TemplateLink'] = $aTableData['TemplateLink'] . "&";
		}
		else
		{
			$aTableData['TemplateLink'] = $aTableData['TemplateLink'] . "?";
		}

		// Write to Onload Event
		$gaPage['onload'] = "tbl_i(" . $aTableData['TableNo'] . ");" . $gaPage['onload'];
	}

	function fTBHighlightRow(&$aTableData){
		$i = count($aTableData['Rows']);
		$n = $aTableData['TableNo'];
		$r = $aTableData['Rows'][$i - 1];

		// Write to Onload Event
		$gaPage['onload'] = $gaPage['onload'] & "tbl_sR(" . $n . ", " . $i . ", 1, " . count($r['Columns']) . ");";
	}

	function fTBAddRow(&$aTableData, $aArguments){
		// Defaults
		fDefaultParameter("RowType", $aArguments, "data");

		// Add the row
		$i = count($aTableData['Rows']);
		$aTableData['Rows'][$i] = array();
		$aTableData['Rows'][$i]['Columns'] = array();
		$aTableData['Rows'][$i]['RowType'] = $aArguments['RowType'];
	}

	function fTBAddCol(&$aTableData, $aArguments){
		// Defaults
		fDefaultParameter("ColType",     $aArguments, "string");
		fDefaultParameter("ColData",     $aArguments, "");
		fDefaultParameter("ColAction",   $aArguments, "");
		fDefaultParameter("ColLink",     $aArguments, "");
		fDefaultParameter("ColTarget",   $aArguments, "");
		fDefaultParameter("ColAlign",    $aArguments, "");
		fDefaultParameter("ColSpan",     $aArguments, "");
		fDefaultParameter("Colour",      $aArguments, "");
		fDefaultParameter("Sort",        $aArguments, "");
		fDefaultParameter("FilterValue", $aArguments, "");
		fDefaultParameter("Width",       $aArguments, "");

		// Add the column
		$i = count($aTableData['Rows']);
		$j = count($aTableData['Rows'][$i - 1]['Columns']);
		$o = array();
		$o['ColType']      = $aArguments['ColType'];
		$o['ColData']      = $aArguments['ColData'];
		$o['ColAction']    = $aArguments['ColAction'];
		$o['ColLink']      = $aArguments['ColLink'];
		$o['ColTarget']    = $aArguments['ColTarget'];
		$o['ColAlign']     = $aArguments['ColAlign'];
		$o['ColSpan']      = $aArguments['ColSpan'];
		$o['Colour']       = $aArguments['Colour'];
		$o['Sort']         = $aArguments['Sort'];
		$o['FilterValue']  = $aArguments['FilterValue'];
		$o['Width']        = $aArguments['Width'];

		if (count($aTableData['Rows']) == 1)
		{
			$aTableData['TotalColSpan'] = $aTableData['TotalColSpan'] + max($o['ColSpan'], 1);
		}

		$aTableData['Rows'][$i - 1]['Columns'][$j] = $o;
	}

	function fTBWriteTable(&$aTableData){
		// Globals
		global $gaPage;

		?>

		<?php if ($aTableData['FilterLink'] != "") { ?><form name="flt<?php echo $aTableData['TableNo']; ?>" method="post" action="<?php echo $aTableData['FilterLink']; ?>" style="padding: 0px; margin: 0px;"><?php } ?>
		<?php if ($aTableData['ShowHeader'] == "Y" && $aTableData['Scrollable'] == "Y") { ?>
		<table id="tbl<?php echo $aTableData['TableNo']; ?>_h" cellspacing="0" cellpadding="0" border="0" style="display: none; z-index: 1; position: absolute; left: 0; top: 0;">
			<?php fTBWriteRow($aTableData, array("RowId"=>1, "Header"=>"_h")); ?>
		</table>
		<?php } ?>
		<?php if ($aTableData['Scrollable'] == "Y") { ?><div id="d_tbl<?php echo $aTableData['TableNo']; ?>" style="overflow:auto; height:<?php echo $aTableData['Height']; ?>px;"><?php } ?>
		<table id="tbl<?php echo $aTableData['TableNo']; ?>" cellspacing="0" cellpadding="0" border="0" class="tbl">
		<?php
			$aTableData['DataRows'] = 0;
			for ($i = 0; $i < count($aTableData['Rows']); $i++)
			{
				fTBWriteRow($aTableData, array("RowId" => ($i + 1)));
			}
			$sFooter = "";
			$sTableFooter = array();
			for ($f = 0; $f < 2; $f++)
			{
				ob_start();
		?>
			<tr id="tbl<?php echo $aTableData['TableNo']; ?>_trf<?php echo $sFooter; ?>" class="trf">
			<?php if ($aTableData['PageSize'] != "" or $aTableData['SearchLink'] != "" or $aTableData['ExportLink'] != "") { ?>
				<td colspan="<?php echo $aTableData['TotalColSpan']; ?>" class="hdb1"><table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 0px 0px 0px 0px;"><tr>
					<td class="hdbc1" width="1%"  align="left" >
					<table cellpadding="0" cellspacing="0" border="0" style="margin: 0px 0px 0px 0px;"><tr>
				<?php echo '<br/>';
				if ($aTableData['PageSize'] != "" && ($aTableData['PageNo'] > 1 || $aTableData['PageNo'] * $aTableData['PageSize'] < $aTableData['TotalRecords'])) { ?>
					<?php if ($aTableData['PageNo'] > 1) { ?>
						<td style="padding: 1px 1px 1px 1px;"><a class="habc1" href="<?php echo $aTableData['TemplateLink'] . $aTableData['TableName']; ?>_pageno=1" title="First"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_first.png"); ?>" width="24" height="24" border="0" alt="First" style="padding:1px 1px 1px 1px;"></a></td>
						<td style="padding: 1px 1px 1px 1px;"><a class="habc1" href="<?php echo $aTableData['TemplateLink'] . $aTableData['TableName']; ?>_pageno=<?php echo intval($aTableData['PageNo'] - 1); ?>" title="Previous"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_previous.png"); ?>" width="24" height="24" border="0" alt="Previous" style="padding:1px 1px 1px 1px;"></a></td>
					<?php } else { ?>
						<td style="padding: 1px 1px 1px 1px;"><span class="hpbc1"><img style="opacity:0.25;filter:alpha(opacity=25)" src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_first_d.png"); ?>" width="24" height="24" border="0" alt="First" style="padding:1px 1px 1px 1px;"></span></td>
						<td style="padding: 1px 1px 1px 1px;"><span class="hpbc1"><img style="opacity:0.25;filter:alpha(opacity=25)" src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_previous_d.png"); ?>" width="24" height="24" border="0" alt="Previous" style="padding:1px 1px 1px 1px;"></span></td>
					<?php } ?>
					<?php if ($aTableData['PageNo'] * $aTableData['PageSize'] < $aTableData['TotalRecords']) { ?>
						<td style="padding: 1px 1px 1px 1px;"><a class="habc1" href="<?php echo $aTableData['TemplateLink'] . $aTableData['TableName']; ?>_pageno=<?php echo intval($aTableData['PageNo'] + 1); ?>" title="Next"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_next.png"); ?>" width="24" height="24" border="0" alt="Next" style="padding:0px 0px 0px 0px;"></a></td>
						<td style="padding: 1px 1px 1px 1px;"><a class="habc1" href="<?php echo $aTableData['TemplateLink'] . $aTableData['TableName']; ?>_pageno=<?php echo ceil($aTableData['TotalRecords'] / $aTableData['PageSize']); ?>" title="Last"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_last.png"); ?>" width="24" height="24" border="0" alt="Last" style="padding:0px 0px 0px 0px;"></a></td>
					<?php } else { ?>
						<td style="padding: 1px 1px 1px 1px;"><span class="hpbc1"><img style="opacity:0.25;filter:alpha(opacity=25)" src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_next_d.png"); ?>" width="24" height="24" border="0" alt="Next" style="padding:0px 0px 0px 0px;"></span></td>
						<td style="padding: 1px 1px 1px 1px;"><span class="hpbc1"><img style="opacity:0.25;filter:alpha(opacity=25)" src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/go_last_d.png"); ?>" width="24" height="24" border="0" alt="Last" style="padding:0px 0px 0px 0px;"></span></td>
					<?php } ?>
					<?php if ($aTableData['IndexLink'] != "") { ?>
						<?php if ($aTableData['PageNo'] > 1 or $aTableData['PageNo'] * $aTableData['PageSize'] < $aTableData['TotalRecords']) { ?>
						<td><img src="<?php echo $gaPage['root_directory']; ?>/graphics/spacer.gif" width="8" height="16" border="0" alt="" style="padding:0px 0px 0px 0px;"></td>
						<td><a class="habc1" href="<?php echo $aTableData['IndexLink']; ?>" onclick="tbl_ti_d('<?php echo $aTableData['IndexLink']; ?>'); return false;" title="Index"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/index.png"); ?>" width="16" height="16" border="0" alt="Index" style="padding:0px 0px 0px 0px;"></a></td>
						<?php } else { ?>
						<td><img src="<?php echo $gaPage['root_directory']; ?>/graphics/spacer.gif" width="8" height="16" border="0" alt="" style="padding:0px 0px 0px 0px;"></td>
						<td><span class="hpbc1"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/index_d.png"); ?>" width="16" height="16" border="0" alt="Index" style="padding:0px 0px 0px 0px;"></span></td>
						<?php } ?>
					<?php } ?>
				<?php } ?>
				<?php if ($aTableData['SearchLink'] != "") { ?>
						<td><img src="<?php echo $gaPage['root_directory']; ?>/graphics/spacer.gif" width="8" height="16" border="0" alt="" style="padding:0px 0px 0px 0px;"></td>
						<td><a class="habc1" href="<?php echo $aTableData['SearchLink']; ?>" title="Search"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/search.png"); ?>" width="16" height="16" border="0" alt="Search" style="padding:0px 0px 0px 0px;"></a></td>
				<?php } ?>
				<?php if ($aTableData['ExportLink'] != "") { ?>
						<td><img src="<?php echo $gaPage['root_directory']; ?>/graphics/spacer.gif" width="8" height="16" border="0" alt="" style="padding:0px 0px 0px 0px;"></td>
						<td><a class="habc1" href="<?php echo $aTableData['ExportLink']; ?>.csv" title="Export"><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/export.png"); ?>" width="16" height="16" border="0" alt="Export" style="padding:0px 0px 0px 0px;"></a></td>
				<?php } ?>
				</tr></table></td>
				<?php if ($aTableData['PageSize'] != "") { ?>
					<td class="hdbc1" align="left" ><span class="hpbc1"><img src="<?php echo $gaPage['root_directory']; ?>/graphics/spacer.gif" width="16" height="16" border="0" style="padding:0px 0px 0px 0px;"></span></td>
					<td class="hdbc1" align="right"><p style="padding:5px 5px 5px 5px;" class="hp1">Showing records&nbsp;<?php echo min(($aTableData['PageNo'] - 1) * $aTableData['PageSize'] + 1, $aTableData['TotalRecords']); ?>&nbsp;to&nbsp;<?php echo min($aTableData['PageNo'] * $aTableData['PageSize'], $aTableData['TotalRecords']); ?>&nbsp;of&nbsp;<?php echo intval($aTableData['TotalRecords']); ?> results found</p></td>
				<?php } ?>
				</tr></table></td>
			<?php } else { ?>
				<td colspan="<?php echo $aTableData['TotalColSpan']; ?>" class="tdf"><img src="<?php echo $gaPage['root_directory']; ?>/graphics/spacer.gif" width="<?php echo $aTableData['Width']; ?>" height="1" style="padding:0px 0px 0px 0px;"></td>
			<?php }
			$sFooter = "_f";
			?>
			</tr>
			<?php
				$sTableFooter[$f] = ob_get_clean();
			}
			?>
			<?php echo $sTableFooter[0]; ?>
			<tr>
				<td colspan="<?php echo $aTableData['TotalColSpan']; ?>"><img src="<?php echo $gaPage['root_directory']; ?>/graphics/spacer.gif" width="<?php echo $aTableData['Width']; ?>" height="1" style="padding:0px 0px 0px 0px;"></td>
			</tr>
		</table>
		<?php if ($aTableData['Scrollable'] == "Y") { ?></div>
		<table id="tbl<?php echo $aTableData['TableNo']; ?>_f" cellspacing="0" cellpadding="0" border="0" style="display: none; z-index: 1; position: absolute; left: 0; top: 0;">
			<?php echo $sTableFooter[1]; ?>
		</table>
		<?php } ?>
		<?php if ($aTableData['FilterLink'] != "") { ?></form><?php } ?>
	<?php
	}

	function fTBWriteRow(&$aTableData, $aArguments){
		// Defaults
		fRequireParameter("RowId",  $aArguments);
		fDefaultParameter("Header", $aArguments, "");

		$i = $aArguments['RowId'];
		$n = $aTableData['TableNo'];
		$r = $aTableData['Rows'][$i - 1];

		switch($r['RowType'])
		{
			case "header":
				?><tr id="tbl<?php echo $n . "_tr" . $i . $aArguments['Header']; ?>"><?php
				for ($k = 1; $k <= count($r['Columns']); $k++)
				{
					fTBWriteCol($aTableData, array("RowId"=>$i, "RowNo"=>0, "ColId"=>$k, "Header"=>$aArguments['Header']));
				}
				?></tr><?php
				break;
			case "data":
				$aTableData['DataRows'] = $aTableData['DataRows'] + 1;
				$j = $aTableData['DataRows'] % 2 + 1;
				if ($aTableData['Selectable'] == "Y")
				{
					$sOnclick = "onclick=\"tbl_sR(event, " . $n . "," . $i . "," . $j . "," . count($r['Columns']) . ");\"";
				} 
				else 
				{
					$sOnclick = "";
				}
				?><tr id="tbl<?php echo $n . "_tr" . $i; ?>" class="tr<?php echo $j; ?>" <?php echo $sOnclick; ?>><?php
				for ($k = 1; $k <= count($r['Columns']); $k++)
				{
					fTBWriteCol($aTableData, array("RowId"=>$i, "RowNo"=>$j, "ColId"=>$k));
				}
				?></tr><?php
				break;
			case "filter":
				?><tr id="tbl<?php echo $n . "_tr" . $i; ?>"><?php
				for ($k = 1; $k <= count($r['Columns']); $k++)
				{
					fTBWriteCol($aTableData, array("RowId"=>$i, "RowNo"=>0, "ColId"=>$k));
				}
				?></tr><?php
				break;
		}
	}

	function fTBWriteCol(&$aTableData, $aArguments){
		// Globals
		global $gaPage;

		// Defaults
		fRequireParameter("RowId",  $aArguments);
		fRequireParameter("RowNo",  $aArguments);
		fRequireParameter("ColId",  $aArguments);
		fDefaultParameter("Header", $aArguments, "");

		$i = $aArguments['RowId'];
		$j = $aArguments['RowNo'];
		$k = $aArguments['ColId'];
		$n = $aTableData['TableNo'];
		$r = $aTableData['Rows'][$i - 1];
		$c = $r['Columns'][$k - 1];
		$l = $k == count( $r['Columns'] ) ? "l" : "";

		// Set the sorting
		if ($r['RowType'] == "header" and $c['Sort'] != "" and $aTableData['SortLink'] != "")
		{
			if (strpos($aTableData['SortLink'], "?") !== false)
			{
				$sTD = "onclick=\"document.location.href='" . $aTableData['SortLink'] . "&sort_by=" . urlencode($c['ColData']) . "'\"";
			}
			else
			{
				$sTD = "onclick=\"document.location.href='" . $aTableData['SortLink'] . "?sort_by=" . urlencode($c['ColData']) . "'\"";
			}
			if ($aTableData['SortBy'] == $c['ColData'])
			{
				$sSI = '<img src="'.fPNG2GIF($gaPage['root_directory'].'/graphics/buttons/sort_'.strtolower($aTableData['SortDir']).'.png').'" width="7" height="4" vspace="3" border="0" align="right" style="padding:0px 0px 0px 0px;">';
			}
			else
			{
				$sSI = '<img src="'.$gaPage['root_directory'].'/graphics/spacer.gif" width="7" height="10" border="0" align="right" style="padding:0px 0px 0px 0px;">';
			}
		}
		else 
		{
			$sTD = "";
			$sSI = '<img src="'.$gaPage['root_directory'].'/graphics/spacer.gif" width="7" height="10" border="0" align="right" style="padding:0px 0px 0px 0px;">';
		}
		// Set the script
		$sP     = "p";
		$sClass = "tp";
		if (($c['ColAction'] != "" || $c['ColLink'] != "") && ($c['ColType'] == "string" || $c['ColType'] == "button"))
		{
			$sOC = "href=\"\"";
			if ($c['ColLink'] != "")
			{
				$sOC = "href=\"" . $c['ColLink'] . "\"";
			}
			if ($c['ColAction'] != "")
			{
				$sOC = $sOC . " onclick=\"" . $c['ColAction'] . "\"";
			}
			if ($c['ColTarget'] != "")
			{
				$sOC = $sOC . " target=\"" . $c['ColTarget'] . "\"";
			}
			$sP = "a";
			$sClass = "tl";
		}
		else if ($c['ColAction'] != "")
		{
			$sOC = "onclick=\"" . $c['ColAction'] . "\"";
		}
		else
		{
			$sOC = "";
		}

		// Set the width
		if ($c['Width'] != "")
		{
			$sW1 = "width=\"" . $c['Width'] . "\" ";
			$sW2 = "width:" . $c['Width'] . "; ";
		}
		else if ($c['ColType'] == "button") 
		{
			$sW1 = "width=\"1%\"";
			$sW2 = "";
		}
		else
		{
			$sW1 = "";
			$sW2 = "";
		}

		if ($r['RowType'] == "header")
		{
			if ($c['ColAlign'] == "center")
			{
				?><td colspan="<?php echo $c['ColSpan']; ?>" class="hd<?php echo $l; ?>1" align="center" <?php echo $sW1 . $sTD; ?>><p class="hp1"><?php echo $sSI; ?>&nbsp;<?php echo $c['ColData']; ?>&nbsp;</p></td><?php
			} 
			else if ($c['ColAlign'] == "right") 
			{
				?><td colspan="<?php echo $c['ColSpan']; ?>" class="hd<?php echo $l; ?>1" align="right" <?php echo $sW1 . $sTD; ?>><p class="hp1"><?php echo $sSI; ?>&nbsp;&nbsp;&nbsp;<?php echo $c['ColData']; ?></p></td><?php
			} 
			else 
			{
				?><td colspan="<?php echo $c['ColSpan']; ?>" class="hd<?php echo $l; ?>1" align="left" <?php echo $sW1 . $sTD; ?>><p class="hp1"><?php echo $sSI; ?><?php echo $c['ColData']; ?>&nbsp;&nbsp;&nbsp;</p></td><?php
			}
		} 
		else if ($c['ColType'] == "button") 
		{
			?><td id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_td<?php echo $k; ?><?php echo $aArguments['Header']; ?>" class="td<?php echo $l . $j; ?>" <?php echo $sW1; ?>><<?php echo $sP; ?> id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_tp<?php echo $k; ?>" <?php echo $sOC; ?> class="<?php echo $sClass . $j; ?>" <?php echo $c['Colour'] != "" ? "style=\"color: #" . $c['Colour'] . ";\"" : ""; ?>><img src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/" . $c['ColData']); ?>" width="16" height="16" border="0" style="padding:0px 0px 0px 0px;"></<?php echo $sP; ?>></td><?php
		} 
		else if ($r['RowType'] == "filter")
		{
			if ($k == 1)
			{
			?><td <?php echo $sW1; ?> align="center"><input type="image" name="filter" value="f" src="<?php echo fPNG2GIF($gaPage['root_directory'] . "/graphics/buttons/filter.png"); ?>" border="0" width="16" height="16"></td><?php
			}
			else
			{
			?><td <?php echo $sW1; ?>><input type="text" name="<?php echo $c['ColData']; ?>" value="<?php echo $c['FilterValue']; ?>" style="<?php echo $sW2; ?>"></td><?php
			}
		}
		else
		{
			if ($c['ColAlign'] == "center")
			{
				?><td id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_td<?php echo $k; ?><?php echo $aArguments['Header']; ?>" class="td<?php echo $l . $j; ?>" align="center" <?php echo $sW1; ?>><<?php echo $sP; ?> id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_tp<?php echo $k; ?>" <?php echo $sOC; ?> class="tp<?php echo $sClass . $j; ?>" <?php echo $c['Colour'] != "" ? "style=\"color: #" . $c['Colour'] . ";\"" : ""; ?>>&nbsp;<?php echo $c['ColData']; ?>&nbsp;</<?php echo $sP; ?>></td><?php
			}
			else if ($c['ColAlign'] == "right")
			{
				?><td id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_td<?php echo $k; ?><?php echo $aArguments['Header']; ?>" class="td<?php echo $l . $j; ?>" align="right" <?php echo $sW1; ?>><<?php echo $sP; ?> id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_tp<?php echo $k; ?>" <?php echo $sOC; ?> class="<?php echo $sClass . $j; ?>" <?php echo $c['Colour'] != "" ? "style=\"color: #" . $c['Colour'] . ";\"" : ""; ?>>&nbsp;&nbsp;&nbsp;<?php echo $c['ColData']; ?></<?php echo $sP; ?>></td><?php
			}
			else
			{
				?><td id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_td<?php echo $k; ?><?php echo $aArguments['Header']; ?>" class="td<?php echo $l . $j; ?>" <?php echo $sW1; ?>><<?php echo $sP; ?> id="tbl<?php echo $n; ?>_tr<?php echo $i; ?>_tp<?php echo $k; ?>" <?php echo $sOC; ?> class="<?php echo $sClass . $j; ?>" <?php echo $c['Colour'] != "" ? "style=\"color: #" . $c['Colour'] . ";\"" : ""; ?>><?php echo $c['ColData']; ?>&nbsp;&nbsp;&nbsp;</<?php echo $sP; ?>></td><?php
			}
		}
	}
?>