<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*   29/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

	/************ Only allow logged in vets to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}
	
	/********************* Page Functions *********************/
	function isVetMainContact($vetId, $companyID){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_sk_vet_id eq ".$vetId." and _sk_company_id eq ".$companyID,
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );
       
		return $response;
    }

	function getVetByLicenceNumber($licenceNumber){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "vet_license_number eq '".$licenceNumber."'",
            'count' => true
        ]);
        $response = $fm->get('Vet', $odataQuery ,$allPages = true );
       
		return $response;
    }
	
	function getVetByImplanterNumber($implanterNumber){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "implanter_number eq '".$implanterNumber."'",
            'count' => true
        ]);
        $response = $fm->get('Vet', $odataQuery ,$allPages = true );
       
		return $response;
    }
	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('vetid', $_GET, '');
	fDefaultParameter('companyid', $_GET, '');
	fDefaultParameter('vet_state', $_GET, '');
	fDefaultParameter('vet_suburb', $_GET, '');
	fDefaultParameter('vet_license', $_POST, '');
	fDefaultParameter('implanter_number', $_POST, '');
	fDefaultParameter('section', $_GET, '1');

	$err_code = $_GET['err_code'];
	$section = $_GET['section'];
	$submitText = 'Search for Vets';
	$vetLicense = $_POST['vet_license'];
	$implanterNumber = $_POST['implanter_number'];

	// default - vetExists = false
	$vetExists = 0;
	$vetName = '';
	$vetID = '';

	if (trim($vetLicense) != '' or trim($implanterNumber) != ''){
		$section = 2;
		$submitText = 'Add Vet to Clinic';
		// look for vet
		$aRequestVet = array();
		if (trim($vetLicense) != ''){
			//$aRequestVet['vet_license_number'] = '="' . $vetLicense . '"';
			//$fmrVet = fFMPerformFind('petsafe', 'All Fields - Vet', $aRequestVet);
			$fmrVet = getVetByLicenceNumber($vetLicense);
		} else {
			//$aRequestVet['implanter_number'] = '="' . $implanterNumber . '"';
			//$fmrVet = fFMPerformFind('petsafe', 'All Fields - Vet', $aRequestVet);
			$fmrVet = getVetByImplanterNumber($implanterNumber);
		}

		if ($fmrVet['success'] === FALSE || $fmrVet["data"]['count'] != 1){
			$vetExists = 0; // no vet found - new vet
			//override - show section 1
			$section = 1;
			$err_code = 'VetNotFound';
		} else {
			$vetExists = 1; // vet found - can add directly
			$fmcVet = $fmrVet['data']['value'][0];
			$vetName = $fmcVet['vet_title'] . ' ' . $fmcVet['vet_first_name'] . ' ' . $fmcVet['vet_last_name'];
			$vetID = $fmcVet['_pk_vet_id'];
			$vetLicense = $fmcVet['vet_license_number'];
			$implanterNumber = $fmcVet['implanter_number'];
		}
	}

	// ensure logged-in user is the main vet
	$companyid = $_GET['companyid'];
	// get company details
	$fmrVet = isVetMainContact( $_SESSION['VetID'] , $companyid);
	$fmcVet = $fmrVet['data']['value'][0];

	if ($fmcVet['vet_main_contact'] != 'Yes'){
		// Redirect if not authorised to update
		fRedirect('myaccount.php');
		fCleanup();
	} else {
		$companyName = $fmcVet['companyName'];
	}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<script type="text/javascript" src="../javascripts/prototype.js"></script>
<script type="text/javascript" src="../javascripts/common.js"></script>

<script language="javascript">

	function trim(mystring){
		return mystring.replace(/^\s+|\s+$/g, '') ;
	}

	function validateForm(myform) {

		var error1 = 'Please complete the following mandatory field(s):\n';
		var error2 = 'Your password is too short.\nPlease re-enter your password - at least 3 characters.';
		var error3 = 'The two Petsafe Password fields do not match!\nPlease re-enter your password.';
		var error4 = 'Please enter a valid email address.';
		var mandatory_err = 0;

<?php
if ($section == 1){
?>
		// check mandatory fields
		// vet_firstname, vet_lastname, vet_email, 
		// vet_password1, vet_password2
		if (trim(myform.vet_license.value) == '' && trim(myform.implanter_number.value) == ''){
			myform.vet_license.value = '';
			myform.implanter_number.value = '';
			error1 = error1 + '\n- Vet License No. OR Implanter Number is required';
			mandatory_err = 1;
		}
<?php
}
?>
		if (mandatory_err != 0){
			alert(error1);
			return false;
		}

		return true;
	}

</script>

</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<?php

	echo '<br/><h2 class="orangeheading">Add New Vet</h2><br/>';

?>

<?php
if ($section == 1){
// initial form
	if ($err_code == 'VetNotFound'){
		echo '<span style="color: red">The Vet you searched for was NOT found! Please try again.</span>';
	}
?>
<form action="addvet.php?companyid=<?php echo $companyid; ?>" method="post" name="frmVet" id="frmVet">
<table border="0" width="60%">
	<tr>
		<td><b>Clinic</b></td>
		<td valign="top">
			<b><?php echo $companyName; ?></b>
		</td>
	</tr>
	<tr>
		<td>Vet License Number</td>
		<td><input type="text" size="20" value="" name="vet_license" /><span style="color:red"><sup>*</sup></span></td>
	</tr>
	<tr>
		<td>Implanter Number</td>
		<td><input type="text" size="20" value="" name="implanter_number" /><span style="color:red"><sup>*</sup></span></td>
	</tr>
	<tr>
		<td>&nbsp;</td><td><span class="smalltext">Please enter at least ONE of the fields above</span></td>
	</tr>
<?php
} else if ($vetExists == 0 and $section == 2){
	// override - redirect to section 1 with error no vet found.
	fRedirect('addvet.php?err_code=VetNotFound&companyid=' . $companyid);
	fCleanup();
// new vet info required
?>
<?php
} else if ($vetExists == 1 and $section == 2){
// show found vet info here
?>
<form action="addvet_submit.php" method="post" name="frmVet" id="frmVet">
<table border="0" width="60%">
	<tr>
		<td><b>Clinic</b></td>
		<td valign="top">
			<b><?php echo $companyName; ?></b>
		</td>
	</tr>
	<tr>
		<td><b>Vet License Number</b></td>
		<td><b><?php echo $vetLicense; ?></b><input type="hidden" name="vet_license" value="<?php echo $vetLicense; ?>" /></td>
	</tr>
	<tr>
		<td><b>Implanter Number</b></td>
		<td><b><?php echo $implanterNumber; ?></b><input type="hidden" name="implanter_number" value="<?php echo $implanterNumber; ?>" /></td>
	</tr>
	<tr>
		<td><b>Vet Name</b></td>
		<td><b><?php echo $vetName; ?></b></td>
	</tr>
<?php
}
?>
	<tr>
		<td valign="top">&nbsp;</td>
		<td valign="top">
			<input type="hidden" name="vetid" id="vetid" value="<?php echo $vetID; ?>" />
			<input type="hidden" name="companyid" id="companyid" value="<?php echo $companyid; ?>" />
			<br/><input type="submit" value="<?php echo $submitText; ?>" class="button" onclick="javascript: if(!validateForm(this.form)){ return false; }" />
			<input type="button" value="Cancel" class="button" onclick="javascript: window.location.href = 'myaccount.php';" />
		</td>
	</tr>
</table>
</form>

<br/><br/>

</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>