<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*   30/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';

	/********************* Page Functions *********************/
	function isVetMainContact($vetId, $companyID){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_sk_vet_id eq ".$vetId." and _sk_company_id eq ".$companyID,
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );
       
		return $response;
    }

	function isVetLinkedToClinic($vetId, $companyID){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_sk_vet_id eq ".$vetId." and _sk_company_id eq ".$companyID,
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );
		$foundCount = $response['data']['count'];

		if ($foundCount > 0){
			return true;
		}else{
			return false;
		}
		
    }

	function insertVet($data){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $response = $fm->create('Company_Vet_Relation', $data);
		if (!$response['success'])
        {
            // Redirect
			var_dump($response);
			die;
        }

        return;
    }

	/************ Only allow logged in vets to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}

	/********************* Page Defaults *********************/
	fDefaultParameter('companyid', $_POST, '');
	fDefaultParameter('vetid', $_POST, '');
	fDefaultParameter('vet_license', $_POST, '');
	fDefaultParameter('implanter_number', $_POST, '');

	// get values
	$companyid = $_POST['companyid'];
	$vetid = $_POST['vetid'];
	$vetLicense = $_POST['vet_license'];
	$implanterNumber = $_POST['implanter_number'];

	// get vet record
	// check if user is the main vet for this company
	$fmrVet = isVetMainContact( $_SESSION['VetID'] , $companyid);
	$fmcVet = $fmrVet['data']['value'][0];

	if ($fmcVet['vet_main_contact'] != 'Yes'){
		// Redirect if not authorised to update
		fRedirect('myaccount.php');
		fCleanup();
	}

	if ($vetid == ''){
		// currently do not allow new vets
		fRedirect('myaccount.php');
		fCleanup();

	} else {

		// check if vet is already linked to company
		$isLinked = isVetLinkedToClinic($vetid, $companyid);

		if ($isLinked ) {
			// link exists - redirect

			fRedirect('companyvets.php?companyid=' . $companyid);
			fCleanup();
		}
	}

	$insertData = array(
		// Cast the ids to be integers as they have been changed to strings
		'_sk_vet_id' => (int) $vetid,
		'_sk_company_id' => (int) $companyid,
	);

	// insert vet details
	$fmrInsertLink = insertVet($insertData);

	// ADD TO LOG: added new vet
	$entry = [];
	$entry = [
		"_sk_vet_id" => $_SESSION['VetID'],
		"description" => 'Added new Vet. Vet added is: ',
		"is_web_admin_login" => isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0
	];
	makeLogEntry($entry);
	
	// Redirect
	fRedirect('companyvets.php?companyid=' . $companyid);
	fCleanup();
?>
