<?php
	/***********************************************************************************
	*   Filename    : chip_owner_change.php
	*   Description : Display form to change chip owner
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

	/***********************************************************************************
	*   TODO: Resolve Postcode lists
	***********************************************************************************/


	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['onload'] = 'retrieveOwnerValues(document.frmregister, \'current\');';


	// Check logged in using global password
	if ($_SESSION['IsAdminLogin'] != 1)
	{
		fRedirect('index.php');
		fCleanup();
	}

	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	$err_code = $_GET['err_code'];

	/********************* AJAX Calls *********************/

	// check email - ajax call
	if (isset($_GET['ajax_check_email'])) {
		$email_error = '';
		if ( empty($_GET['email']) or $_GET['email'] == '' ) {
			$email_error = '<span style="color:red">Email address is empty!</span>';
		} else {
			$aRequest = array();
			$aRequest['Email'] = '="' . $_GET['email'] . '"';
			$fmrEmail = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
			$fmcEmail = $fmrEmail["response"]["data"];
			$countOwnerEmails = count($fmcEmail);
			$validCount = 0; // email being updated - there should be no other email like the updated value
			if ($countOwnerEmails > $validCount){
				$email_error = '<span style="color:red">An owner with this email address already exists on our records!<br/>Please enter a valid and unique email address OR <a href="memberlogin.php">login</a> with this email address and then register a pet.</span>';
			}
		}
		echo $email_error;
		die;
	}

	// check tag - ajax call
	if (isset($_GET['ajax_check_tag'])) {
		$tag_error = '';
		if ( empty($_GET['tag']) or $_GET['tag'] == '' ) {
			$tag_error = '<span style="color:red">Petsafe Tag is empty!</span>';
		} else {
			$aRequest = array();
			$aRequest['Tag'] = '="' . $_GET['tag'] . '"';
			$fmrTag = fFMPerformFind('petsafe', 'Web - Pets', $aRequest);
			//$fmcTag = $fmrTag->getRecords();
			//$countTags = count($fmcTag);
			//$validCount = 0; // tag being entered - there should be no such tag linked to a pet
			//if ($countTags > $validCount){
			//	$tag_error = '<span style="color:red">This Tag number is already attached to a Pet on our database!<br/>Please enter a unique Tag number for this pet registration.</span>';
			//}
			if ($fmrTag === FALSE || count($fmrTag) < 1){
				//do nothing
			} else {
				$tag_error = '<span style="color:red">This Tag number is already attached to a Pet on our database!<br/>Please enter a unique Tag number for this pet registration.</span>';
			}
		}
		echo $tag_error;
		die;
	}

	// check chip - ajax call
	if (isset($_GET['ajax_check_chip'])) {
		$chip_error = '';
		if ( empty($_GET['chip']) or $_GET['chip'] == '' ) {
			$chip_error = '<span style="color:red">Microchip is empty!</span>';
		} else {
			$aRequest = array();
			$aRequest['Chip No'] = '="' . $_GET['chip'] . '"';

			$fmrChip = fFMPerformFind('petsafe', 'Web - Chips', $aRequest);
			if ($fmrChip === FALSE || count($fmrChip) < 1){
				// no duplicates
				$chip_error = '';
			} else {
				// POSSIBLE duplicate found
				$fmcChip = $fmrChip["response"]["data"];
				$duplicate = 0;
				foreach ($fmcChip as $chip){
					$petid = $chip["fieldData"]['_sk_pet_id'];
					if (trim($petid) != ''){
						$duplicate = 1;
						break;
					}
				}
				if ($duplicate == 1){
					// duplicate found - confirmed
					$chip_error = '<span style="color:red">This Chip number is already attached to a Pet on our database!<br/>Please enter a unique Microchip number for this pet registration.</span>';
				}
			}
		}
		echo $chip_error;
		die;
	}

	// fill suburbs
	if (isset($_GET['hello_from_ajax1'])) {
		if ( empty($_GET['owner_state']) ) {
			$suburb_popup = '<select name="owner_suburb" disabled="disabled"></select>';
		} else {
		$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['owner_state'] . '"';
	        $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $suburbsData=$suburbsResult ['response']['data'];
            $suburbs = array();
            foreach ($suburbsData as $suburbsLine)
            {
                If (!in_array($suburbsLine["fieldData"]['Suburb'], $suburbs)) {
                    $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
                }
            }
            asort($suburbs);
			$suburb_popup = popup($suburbs, 'owner_suburb', $selected_suburb,'onchange="setPostcodeValueList()"');
		}
		echo $suburb_popup;
		die;
	}

	// fill postcodes
	if (isset($_GET['hello_from_ajax2'])) {
		if ( empty($_GET['owner_suburb']) ) {
			$postcode_popup = '<select name="owner_postcode" disabled="disabled"></select>';
		} else {
		    
        	$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['owner_state'] . '"';
            $aRequest['Suburb'] = '="' . $_GET['owner_suburb'] . '"';
	        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $postcodeData=$postcodesResult['response']['data'];
            $postcodes = array();
            foreach ($postcodeData as $postcodeLine){
                $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
            }
            asort($postcodes);
            
            if (count($postcodes) == 1){
				$selected_postcode = $postcodes[0];
			}
	    	$postcode_popup = popup($postcodes, 'owner_postcode', $selected_postcode);

		}
		echo $postcode_popup;
		die;
	}

	// fill suburbs - pets
	if (isset($_GET['hello_from_ajax1p'])) {
		if ( empty($_GET['pet_state']) ) {
			$petsuburb_popup = '<select name="pet_suburb" disabled="disabled"></select>';
		} else {
			$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['pet_state'] . '"';
	        $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $suburbsData=$suburbsResult ['response']['data'];
            $suburbs = array();
            foreach ($suburbsData as $suburbsLine)
            {
                If (!in_array($suburbsLine["fieldData"]['Suburb'], $suburbs)) {
                    $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
                }
            }
            asort($suburbs);
			$petsuburb_popup = popup($suburbs, 'pet_suburb', $selected_petsuburb,'onchange="setPostcodeValueListPet()"');
		}
		echo $petsuburb_popup;
		die;
	}

	// fill postcodes - pets
	if (isset($_GET['hello_from_ajax2p'])) {
		if ( empty($_GET['pet_suburb']) ) {
			$petpostcode_popup = '<select name="pet_postcode" disabled="disabled"></select>';
		} else {
			$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['pet_state'] . '"';
            $aRequest['Suburb'] = '="' . $_GET['pet_suburb'] . '"';
	        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $postcodeData=$postcodesResult['response']['data'];
            $postcodes = array();
            foreach ($postcodeData as $postcodeLine){
                $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
            }
            asort($postcodes);
            if (count($postcodes) == 1){
				$selected_mailpostcode = $postcodes[0];
			}
			$petpostcode_popup = popup($postcodes, 'pet_postcode', $selected_petpostcode);
		}
		echo $petpostcode_popup;
		die;
	}

	// fill suburbs - mailing
	if (isset($_GET['hello_from_ajax1m'])) {
		if ( empty($_GET['mail_state']) ) {
			$mailsuburb_popup = '<select name="mail_suburb" disabled="disabled"></select>';
		} else {
	        $aRequest = array();
	        $aRequest['State'] = '="' . $_GET['mail_state'] . '"';
	        $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $suburbsData=$suburbsResult ['response']['data'];
            $suburbs = array();
            foreach ($suburbsData as $suburbsLine)
            {
                If (!in_array($suburbsLine["fieldData"]['Suburb'], $suburbs)) {
                    $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
                }
            }
            asort($suburbs);
			$mailsuburb_popup = popup($suburbs, 'mail_suburb', $selected_mailsuburb,'onchange="setPostcodeValueListMail()"');
		}
		echo $mailsuburb_popup;
		die;
	}

	// fill postcodes - mailing
	if (isset($_GET['hello_from_ajax2m'])) {
		if ( empty($_GET['mail_suburb']) ) {
			$mailpostcode_popup = '<select name="mail_postcode" disabled="disabled"></select>';
		} else {
			$aRequest = array();
	        $aRequest['State'] = '="' . $_GET['mail_state'] . '"';
            $aRequest['Suburb'] = '="' . $_GET['mail_suburb'] . '"';
	        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
            $postcodeData=$postcodesResult['response']['data'];
            $postcodes = array();
            foreach ($postcodeData as $postcodeLine){
                $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
            }
            asort($postcodes);
            if (count($postcodes) == 1){
				$selected_mailpostcode = $postcodes[0];
			}
			$mailpostcode_popup = popup($postcodes, 'mail_postcode', $selected_mailpostcode);
		}
		echo $mailpostcode_popup;
		die;
	}

	// Check Inputs
	fRequireParameter('chip_id', $_POST);

	$aRequest = array();
	$aRequest['_pk_chip_id'] = '="' . $_POST['chip_id'] . '"';

	$fmrChip = fFMPerformFind('petsafe', 'Web - Chips', $aRequest);

	/************ Check for not found or duplicate ************/
	if ($fmrChip === FALSE || $fmrChip["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Redirect if tag found but linked chip not found
		fRedirect('index.php?err_code=ChipNotFound#chipsearch');
		fCleanup();
	}

	$fmcChip = $fmrChip["response"]["data"][0]["fieldData"];

	// Get the pet details
	$aRequest = array();
	$aRequest['_pk_pet_id'] = '="' . $fmcChip['_sk_pet_id'] . '"';

	$fmrPet = fFMPerformFind('petsafe', 'Web - Pets', $aRequest);

	/************ Check for not found or duplicate ************/
	if ($fmrPet === FALSE || $fmrPet["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Redirect if tag found but linked chip not found
		fRedirect('index.php?err_code=PetNotFound#chipsearch');
		fCleanup();
	}

	$fmcPet = $fmrPet["response"]["data"][0]["fieldData"];
	$member_id = $fmcPet['_sk_member_id'];
	$pet_id    = $fmcChip['_sk_pet_id'];

	// Get the owner details
	$aRequest = array();
	$aRequest['_pk_member_id'] = '="' . $member_id . '"';
    $fmrOwner = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);

	/************ Check for not found or duplicate ************/
	if ($fmrOwner === FALSE || $fmrOwner["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Redirect if tag found but linked chip not found
		fRedirect('index.php?err_code=OwnerNotFound#chipsearch');
		fCleanup();
	}
	$fmcOwner = $fmrOwner["response"]["data"][0]["fieldData"];
	$fmcOwnerID = $fmrOwner["response"]["data"][0]["recordId"];

	// default values
	if (empty($_GET['owner_state'])) {
		$selected_state = '';
	} else {
		$selected_state = $_GET['owner_state'];
	}
	if (empty($_POST['owner_suburb'])) {
		$selected_suburb = '';
	} else {
		$selected_suburb = $_GET['owner_suburb'];
	}
	if (empty($_POST['owner_postcode'])) {
		$selected_postcode = $fmcOwner['Postcode'];
	} else {
		$selected_postcode = $_GET['owner_postcode'];
	}
	if (empty($_POST['mail_state'])) {
		$selected_mailstate = '';
	} else {
		$selected_mailstate = $_POST['mail_state'];
	}
	if (empty($_POST['mail_suburb'])) {
		$selected_mailsuburb = '';
	} else {
		$selected_mailsuburb = $_POST['mail_suburb'];
	}
	if (empty($_POST['mail_postcode'])) {
		$selected_mailpostcode = '';
	} else {
		$selected_mailpostcode = $_POST['mail_postcode'];
	}

	if (empty($_POST['pet_state'])) {
		$selected_petstate = $fmcPet['Display State'];
	} else {
		$selected_petstate = $_POST['pet_state'];
	}
	if (empty($_POST['pet_suburb'])) {
		$selected_petsuburb = $fmcPet['Display Suburb'];
	} else {
		$selected_petsuburb = $_POST['pet_suburb'];
	}
	if (empty($_POST['pet_postcode'])) {
		$selected_petpostcode = $fmcPet['Display Postcode'];
	} else {
		$selected_petpostcode = $_POST['pet_postcode'];
	}

    
	$states = ["ACT","NSW","NT","QLD","SA","TAS","WA","VIC"];
	   
	// initialise lists on first load

if (trim($state) == ''){
	    $state_popup = popup($states, 'owner_state', $selected_state,'onchange="setTypeValueList()"');
	}
	if (trim($suburb) == ''){
	$suburb_popup = '<select name="owner_suburb" disabled="disabled"></select>';
	}
	if (trim($postcode) == ''){
	$postcode_popup = '<select name="owner_postcode" disabled="disabled"></select>';
	}
	if (trim($mailstate) == ''){
	$mailstate_popup = popup($states, 'mail_state', $selected_mailstate,'onchange="setTypeValueListMail()"');
	}
	if (trim($mailsuburb) == ''){
	$mailsuburb_popup = '<select name="mail_suburb" disabled="disabled"></select>';
	}
	if (trim($mailpostcode) == ''){
	$mailpostcode_popup = '<select name="mail_postcode" disabled="disabled"></select>';
	}
    if (trim($petstate) == ''){
	$petstate_popup = popup($states, 'pet_state', $selected_petstate,'onchange="setTypeValueListPet()"');
    }
    if (trim($petsuburb) == ''){
	$petsuburb_popup = '<select name="pet_suburb" disabled="disabled"></select>';
    }
    if (trim($petpostcode) == ''){
	$petpostcode_popup = '<select name="pet_postcode" disabled="disabled"></select>';
    }
 


	if  (empty($selected_petsuburb) || empty($selected_petstate)) {
		$petsuburb_popup = '<div id="petsuburb_container"><select name="pet_suburb" disabled="disabled"></select></div>';
	} else {
	    $aRequest = array();
	    $aRequest['State'] = '="' . $selected_petstate . '"';
	    $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
        $suburbsData=$suburbsResult ['response']['data'];
        $suburbs = array();
        foreach ($suburbsData as $suburbsLine)
        {
            If (!in_array($suburbsLine["fieldData"]['Suburb'], $suburbs)) {
                    $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
            }
        }
        asort($suburbs);
		$petsuburb_popup = popup($suburbs, 'pet_suburb', $selected_petsuburb,'onchange="setPostcodeValueListPet()"');
		
	}
	
	if  (empty($selected_petpostcode) || empty($selected_petsuburb)) {
		$petpostcode_popup = '<div id="petpostcode_container"><select name="pet_postcode" disabled="disabled"></select></div>';
	} else {
        $aRequest = array();
	    $aRequest['State'] = '=="' . $selected_petstate . '"';
        $aRequest['Suburb'] = '=="' . $selected_petsuburb . '"';
        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
        $postcodeData=$postcodesResult['response']['data'];
        $postcodes = array();
        foreach ($postcodeData as $postcodeLine){
            $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
        }
		$petpostcode_popup = popup($postcodes, 'pet_postcode', $selected_petpostcode);
	}

	if ( $fmcOwner['State'] == '' ) {
		$current_suburb_popup = '<select name="owner_suburb" disabled="disabled"></select>';
	} else {
	    $aRequest = array();
	    $aRequest['State'] = '="' . $fmcOwner['State'] . '"';
	    $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
        $suburbsData=$suburbsResult['response']['data'];
        $suburbs = array();
        foreach ($suburbsData as $suburbsLine)
        {
            If (!in_array($suburbsLine["fieldData"]['Suburb'], $suburbs)) {
            $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
            }
        }
        asort($suburbs);
		$current_suburb_popup = popup($suburbs, 'owner_suburb', $selected_suburb,'onchange="setPostcodeValueList()"');
	}

	if ( $fmcOwner['Suburb'] == '' ) {
		$current_postcode_popup = '<select name="owner_postcode" disabled="disabled"></select>';
	} else {
        $aRequest = array();
	    $aRequest['State'] = '=="' . $fmcOwner['State'] . '"';
        $aRequest['Suburb'] = '=="' . $fmcOwner['Suburb'] . '"';
        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
        $postcodeData=$postcodesResult['response']['data'];

        $postcodes = array();
        foreach ($postcodeData as $postcodeLine){
            $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
        }
		if (count($postcodes) == 1)
		{
			$selected_postcode = $postcodes[0];
		}
		$current_postcode_popup = popup($postcodes, 'owner_postcode', $selected_postcode);

	}
	
	if ( $fmcOwner['Mailing State'] == '' ) {
		$current_mailsuburb_popup = '<select name="mail_suburb" disabled="disabled"></select>';
	} else {
	    $aRequest = array();
	    $aRequest['State'] = '="' . $fmcOwner['Mailing State'] . '"';
	    $suburbsResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
        $suburbsData=$suburbsResult ['response']['data'];
        $suburbs = array();
        foreach ($suburbsData as $suburbsLine)
        {
                If (!in_array($suburbsLine["fieldData"]['Suburb'], $suburbs)) {
                    $suburbs[]= $suburbsLine["fieldData"]['Suburb'];  
                } 
        }
        asort($suburbs);
		$current_mailsuburb_popup = popup($suburbs, 'mail_suburb', $selected_mailsuburb,'onchange="setPostcodeValueListMail()"');
	}


	if ( $fmcOwner['Mailing Suburb'] == '' ) {
		$current_mailpostcode_popup = '<select name="mail_postcode" disabled="disabled"></select>';
	} else {
        $aRequest = array();
	    $aRequest['Suburb'] = '=="' . $fmcOwner['Mailing Suburb'] . '"';
        $aRequest['State'] = '=="' . $fmcOwner['Mailing State'] . '"';
        $postcodesResult = fFMPerformFind('petsafe', 'Web - Dynamic Suburbs', $aRequest);
        $postcodeData=$postcodesResult['response']['data'];
        $postcodes = array();
        foreach ($postcodeData as $postcodeLine){
            $postcodes[]= $postcodeLine["fieldData"]['Postcode'];  
        }
		if (count($postcodes) == 1)
		{
			$selected_mailpostcode = $postcodes[0];
		}
		$current_mailpostcode_popup = popup($postcodes, 'mail_postcode', $selected_mailpostcode);
	}

	// Determine if the mailing address matches the physical address
	$current_match_mailaddr = '';
	if ( 
	    $fmcOwner['Street'] == $fmcOwner['Mailing Street']
			&& $fmcOwner['Suburb'] == $fmcOwner['Mailing Suburb']
			&& $fmcOwner['State'] == $fmcOwner['Mailing State']
			&& $fmcOwner['Postcode'] == $fmcOwner['Mailing Postcode']
		) {
		$current_match_mailaddr = '1';
	}
    
    $current_match_petaddr = '';
    
    if($fmcPet['Address Same As Owner'] == 'Yes'){
        $current_match_petaddr = '1';
    }

	// function to create select list dynamically
	function popup($values, $name, $selected_value = '', $extras = '') {
		$popup = '<select name="' . $name . '" ' . $extras . '>';
		$popup.= '<option value="">- Please select -</option>';
		foreach($values as $value) {
			if ($value == $selected_value) {
				$selected = 'selected';
			} else {
				$selected = '';
			}
			$popup.= '<option value="' . $value . '" ' . $selected . '>' . $value . '</option>';
		}
		$popup.= '</select>';
		return $popup;
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<script type="text/javascript" src="../javascripts/prototype.js"></script>
<script type="text/javascript" src="../javascripts/common.js"></script>

<style type="text/css">
.instructions{display:block}
.instructions *{
  display:block;
  height:1px;
  overflow:hidden;
  font-size:.01em;
  background:#99CC99}
.instructions1{
  margin-left:3px;
  margin-right:3px;
  padding-left:1px;
  padding-right:1px;
  border-left:1px solid #d3e9d3;
  border-right:1px solid #d3e9d3;
  background:#b2d8b2}
.instructions2{
  margin-left:1px;
  margin-right:1px;
  padding-right:1px;
  padding-left:1px;
  border-left:1px solid #f4f9f4;
  border-right:1px solid #f4f9f4;
  background:#acd5ac}
.instructions3{
  margin-left:1px;
  margin-right:1px;
  border-left:1px solid #acd5ac;
  border-right:1px solid #acd5ac;}
.instructions4{
  border-left:1px solid #d3e9d3;
  border-right:1px solid #d3e9d3}
.instructions5{
  border-left:1px solid #b2d8b2;
  border-right:1px solid #b2d8b2}
.instructionsfg{
  background:#99CC99;
  padding: 3px 15px 3px 15px;
  }
</style>

<script type="text/javascript">
	// handler to fill suburbs
	function setTypeValueList(){
		var state_popup = document.forms[0].elements['owner_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['owner_suburb'];
		var postcode_popup = document.forms[0].elements['owner_postcode'];
		suburb_popup.disabled = false;
		postcode_popup.options.length = 0;
		postcode_popup.disabled = true;
		suburb_popup.options[suburb_popup.length] = new Option('loading...','');
		suburb_popup.selectedIndex = suburb_popup.length-1;
		var url = 'chip_owner_change.php?hello_from_ajax1=true&owner_state='+selected_state;
		var target = 'suburb_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		suburb_popup.focus();
	}

	// handler to fill postcodes
	function setPostcodeValueList(){
		var state_popup = document.forms[0].elements['owner_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['owner_suburb'];
		var selected_suburb = suburb_popup.value;
		var postcode_popup = document.forms[0].elements['owner_postcode'];
		postcode_popup.disabled = false;
		postcode_popup.options[postcode_popup.length] = new Option('loading...','');
		postcode_popup.selectedIndex = postcode_popup.length-1;
		var url = 'chip_owner_change.php?hello_from_ajax2=true&owner_suburb='+selected_suburb+'&owner_state='+selected_state;
		var target = 'postcode_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		postcode_popup.focus();
	}

	// handler to fill suburbs - pets
	function setTypeValueListPet(){
		var state_popup = document.forms[0].elements['pet_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['pet_suburb'];
		var postcode_popup = document.forms[0].elements['pet_postcode'];
		suburb_popup.disabled = false;
		postcode_popup.options.length = 0;
		postcode_popup.disabled = true;
		suburb_popup.options[suburb_popup.length] = new Option('loading...','');
		suburb_popup.selectedIndex = suburb_popup.length-1;
		var url = 'chip_owner_change.php?hello_from_ajax1p=true&pet_state='+selected_state;
		var target = 'petsuburb_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		suburb_popup.focus();
	}

	// handler to fill postcodes - pets
	function setPostcodeValueListPet(){
		var state_popup = document.forms[0].elements['pet_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['pet_suburb'];
		var selected_suburb = suburb_popup.value;
		var postcode_popup = document.forms[0].elements['pet_postcode'];
		postcode_popup.disabled = false;
		postcode_popup.options[postcode_popup.length] = new Option('loading...','');
		postcode_popup.selectedIndex = postcode_popup.length-1;
		var url = 'chip_owner_change.php?hello_from_ajax2p=true&pet_suburb='+selected_suburb+'&pet_state='+selected_state;
		var target = 'petpostcode_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		postcode_popup.focus();
	}

	// handler to fill suburbs - mailing
	function setTypeValueListMail(){
		var state_popup = document.forms[0].elements['mail_state'];
		var selected_state = state_popup.value;
		var suburb_popup = document.forms[0].elements['mail_suburb'];
		var postcode_popup = document.forms[0].elements['mail_postcode'];
		suburb_popup.disabled = false;
		postcode_popup.options.length = 0;
		postcode_popup.disabled = true;
		suburb_popup.options[suburb_popup.length] = new Option('loading...','');
		suburb_popup.selectedIndex = suburb_popup.length-1;
		var url = 'chip_owner_change.php?hello_from_ajax1m=true&mail_state='+selected_state;
		var target = 'mailsuburb_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		suburb_popup.focus();
	}

	// handler to fill postcodes - mailing
	function setPostcodeValueListMail(){
		var suburb_popup = document.forms[0].elements['mail_suburb'];
		var selected_suburb = suburb_popup.value;
		var postcode_popup = document.forms[0].elements['mail_postcode'];
		postcode_popup.disabled = false;
		postcode_popup.options[postcode_popup.length] = new Option('loading...','');
		postcode_popup.selectedIndex = postcode_popup.length-1;
		var url = 'chip_owner_change.php?hello_from_ajax2m=true&mail_suburb='+selected_suburb;
		var target = 'mailpostcode_container';
		var result = new Ajax.Updater(target, url,{method: 'get'});
		postcode_popup.focus();
	}

	function setMatchMailAddr()
	{
		if (document.forms[0].elements['match_mailaddr'].checked) {
			document.getElementById('mailaddr').style.display = 'none';
			document.getElementById('mailaddr').style.visibility = 'hidden';
		} else {
			document.getElementById('mailaddr').style.display = '';
			document.getElementById('mailaddr').style.visibility = 'visible';
		}
	}
    
	function setMatchPetAddr()
	{
		if (document.forms[0].elements['match_petaddr'].checked) {
			document.getElementById('petaddr').style.display = 'none';
			document.getElementById('petaddr').style.visibility = 'hidden';
		} else {
			document.getElementById('petaddr').style.display = '';
			document.getElementById('petaddr').style.visibility = 'visible';
		}
	}

	function validateForm(myform) {
		var error1 = 'Please complete the following mandatory field(s):\n';
		var error2 = 'Your password is too short.\nPlease re-enter your password - at least 3 characters.';
		var error3 = 'The two Petsafe Password fields do not match!\nPlease re-enter your password.';
		var error4 = 'Please enter a valid email address.';
		var error5 = 'The Microchip No must be 10 characters long and alphanumeric only (A-F and/or 0-9), OR 15 characters long and numeric only.';
		var error6 = 'Please enter a valid PetSafe tag number.';
		var error7 = 'Please enter a valid Microchip number.';
		var error8 = 'Your home phone number must be 10 digits long.';
		var error9 = 'Your work phone number must be 10 digits long.';
		var error10 = 'Your mobile phone number must be 10 digits long.';
		var error11 = 'Your fax number must be 10 digits long.';
		var mandatory_err = 0;

		// check mandatory fields
		// owner_firstname, owner_lastname, owner_suburb, owner_state, owner_homephone, 
		// owner_password1, owner_password2, pet_name, pet_suburb, pet_state
		if (myform.owner_title.selectedIndex == 0){
			error1 = error1 + '\n- Owner\'s Title';
			mandatory_err = 1;
		}
		if (trim(myform.owner_firstname.value) == ''){
			myform.owner_firstname.value = '';
			error1 = error1 + '\n- Owner\'s Given Name';
			mandatory_err = 1;
		}
		if (trim(myform.owner_lastname.value) == ''){
			myform.owner_lastname.value = '';
			error1 = error1 + '\n- Owner\'s Last Name';
			mandatory_err = 1;
		}
		if (trim(myform.owner_address.value) == ''){
			myform.owner_address.value = '';
			error1 = error1 + '\n- Owner\'s Street Address';
			mandatory_err = 1;
		}
		if (myform.owner_state.selectedIndex == 0){
			error1 = error1 + '\n- Owner\'s State';
			mandatory_err = 1;
		}
		if (myform.owner_suburb.selectedIndex == 0){
			error1 = error1 + '\n- Owner\'s Suburb';
			mandatory_err = 1;
		}
		if (myform.owner_postcode.selectedIndex == 0){
			error1 = error1 + '\n- Owner\'s Postcode';
			mandatory_err = 1;
		}
		if (trim(myform.owner_homephone.value) == ''){
			myform.owner_homephone.value = '';
			error1 = error1 + '\n- Owner\'s Telephone(H)';
			mandatory_err = 1;
		}
		if (trim(myform.owner_password1.value) == '' || trim(myform.owner_password2.value) == ''){
			myform.owner_password1.value = '';
			myform.owner_password2.value = '';
			error1 = error1 + '\n- PetSafe Password';
			mandatory_err = 1;
		}
		if (trim(myform.pet_name.value) == ''){
			myform.pet_name.value = '';
			error1 = error1 + '\n- Pet\'s Name';
			mandatory_err = 1;
		}
		if (trim(myform.pet_sex.value) == ''){
			myform.pet_sex.value = '';
			error1 = error1 + '\n- Pet\'s Sex';
			mandatory_err = 1;
		}
		if (trim(myform.pet_colour.value) == ''){
			myform.pet_colour.value = '';
			error1 = error1 + '\n- Pet\'s Colour';
			mandatory_err = 1;
		}
		if (trim(myform.pet_breed.value) == ''){
			myform.pet_breed.value = '';
			error1 = error1 + '\n- Pet\'s Breed';
			mandatory_err = 1;
		}
		if (trim(myform.pet_dob_dd.value) == '' || trim(myform.pet_dob_mm.value) == '' || trim(myform.pet_dob_yyyy.value) == ''){
			error1 = error1 + '\n- Pet\'s DOB';
			mandatory_err = 1;
		}
		else {
			// validate date
			if (! checkDate(myform.pet_dob_dd.value,myform.pet_dob_mm.value,myform.pet_dob_yyyy.value)){
				myform.pet_dob_dd.value = '';
				myform.pet_dob_mm.value = '';
				myform.pet_dob_yyyy.value = '';
				error1 = error1 + '\n- Pet\'s DOB (invalid date!)';
				mandatory_err = 1;
			}
			else {
				// do not allow future dates
				var sysDate = new Date(); 
				var dobDate = new Date(myform.pet_dob_mm.value+"/"+ myform.pet_dob_dd.value + "/"+myform.pet_dob_yyyy.value); 
				if (dobDate > sysDate) {
					error1 = error1 + '\n- Pet\'s DOB (date cannot be in the future!)';
					mandatory_err = 1;
				}
			}
		}
		if (! myform.match_petaddr.checked) {
			if (myform.pet_state.selectedIndex == 0){
				error1 = error1 + '\n- Pet\'s State';
				mandatory_err = 1;
			}
			if (myform.pet_suburb.selectedIndex == 0){
				error1 = error1 + '\n- Pet\'s Suburb';
				mandatory_err = 1;
			}
			if (myform.pet_postcode.selectedIndex == 0){
				error1 = error1 + '\n- Pet\'s Postcode';
				mandatory_err = 1;
			}
		}
		
		if (mandatory_err != 0){
			alert(error1);
			return false;
		}

		// check for email address duplication
		if (trim(document.getElementById('email_err').innerHTML) != ''){
			alert(error4);
			myform.owner_email.focus();
			return false;
		}
		// check if phone numbers, if defined, are 10 digits
		if (myform.owner_homephone.value.replace(/\D/g,'').length != 10){
			alert(error8);
			myform.owner_homephone.focus();
			return false;
		}
		if (trim(myform.owner_workphone.value) != '' && myform.owner_workphone.value.replace(/\D/g,'').length != 10){
			alert(error9);
			myform.owner_workphone.focus();
			return false;
		}
		if (trim(myform.owner_mobilephone.value) != '' && myform.owner_mobilephone.value.replace(/\D/g,'').length != 10){
			alert(error10);
			myform.owner_mobilephone.focus();
			return false;
		}
		if (trim(myform.owner_fax.value) != '' && myform.owner_fax.value.replace(/\D/g,'').length != 10){
			alert(error11);
			myform.owner_fax.focus();
			return false;
		}

		// check if password is long enough
		if (myform.owner_password1.value.length < 3) {
			alert(error2);
			myform.owner_password1.value = '';
			myform.owner_password2.value = '';
			myform.owner_password1.focus();
			return false;
		}

		// check if passwords match
		if (myform.owner_password1.value != myform.owner_password2.value){
			alert(error3);
			myform.owner_password1.value = '';
			myform.owner_password2.value = '';
			myform.owner_password1.focus();
			return false;
		}

		// new members are encouraged to enter email addresses
		if (trim(myform.owner_email.value) == '' && !confirm('You have not provided an email address. We recommend that you do so you can recover your password.\nDo you wish to sign up without an email?')){
			myform.owner_email.focus();
			return false;
		}

		// Clear the owner forms so we aren't submitting temp data
		clearOwnerValues(myform, 'current');
		clearOwnerValues(myform, 'new');

		return true;
	} // end of validate function

	function getRadioValue(r) {
		for (var i = 0, length = r.length; i < length; i++) {
			if (r[i].checked) {
				return r[i].value;
			}
		}
		return '';
	}

	function setRadioValue(r, v) {
		for (var i = 0, length = r.length; i < length; i++) {
			if (r[i].value == v) {
				r[i].checked = true;
			} else {
				r[i].checked = false;
			}
		}
	}

	function getCheckboxValue(c) {
		if (c.checked) {
			return c.value;
		}
		else {
			return '';
		}
	}

	function setCheckboxValue(c, v) {
		if (c.value == v) {
			c.checked = true;
		}
		else {
			c.checked = false;
		}
	}

	function getSelectValue(s) {
		if (!s.disabled && typeof(s.options) != 'undefined') {
			for (var i = 0, length = s.options.length; i < length; i++) {
				if (s.options[i].selected) {
					return s.options[i].value;
				}
			}
		}
		return '';
	}

	function setSelectValue(s, v) {
		for (var i = 0, length = s.options.length; i < length; i++) {
			if (s.options[i].value == v) {
				s.options[i].selected = true;
			} else {
				s.options[i].selected = false;
			}
		}
	}

	function checkEmail(){
		var owneremail = document.forms[0].elements['owner_email'];
		var selected_owneremail = owneremail.value;
		if (trim(selected_owneremail) == ''){
			document.getElementById('email_err').innerHTML = '';
		} else {
			var url = 'register.php?ajax_check_email=true&email='+selected_owneremail;
			var target = 'email_err';
			var result = new Ajax.Updater(target, url,{method: 'get'});
		}
	}

	function changeOwnerType(myform)
	{
		var previous_owner_type = myform.elements['previous_owner_type'].value;
		var current_owner_type  = getRadioValue(myform.elements['owner_type']);

		// Hide while updating
		document.getElementById('idOwnerTypeExisting').style.display = 'none';
		document.getElementById('idOwnerTypeNew').style.display      = 'none';

		// switch out the values for the current owner
		if (previous_owner_type == 'current' && current_owner_type != 'current')
		{
			storeOwnerValues(myform, 'current');
		}

		// switch out the values for the new owner
		if (previous_owner_type == 'new' && current_owner_type != 'new')
		{
			storeOwnerValues(myform, 'new');
		}

		// switch in the values for the current owner
		if (previous_owner_type != 'current' && current_owner_type == 'current')
		{
			retrieveOwnerValues(myform, 'current');
		}

		// switch in the values for the new owner
		if (previous_owner_type != 'new' && current_owner_type == 'new')
		{
			retrieveOwnerValues(myform, 'new');
		}

		if (current_owner_type == 'current')
		{
			document.getElementById('idOwnerTypeNew').style.display      = '';
		}
		else if (current_owner_type == 'existing')
		{
			document.getElementById('idOwnerTypeExisting').style.display = '';
		}
		else
		{
			document.getElementById('idOwnerTypeNew').style.display      = '';
		}

		myform.elements['previous_owner_type'].value = current_owner_type;
	}

	function clearOwnerValues(myform, owner_type)
	{
		myform.elements[owner_type + '_owner_title'].value        = '';
		myform.elements[owner_type + '_owner_firstname'].value    = '';
		myform.elements[owner_type + '_owner_lastname'].value     = '';
		myform.elements[owner_type + '_owner_address'].value      = '';
		myform.elements[owner_type + '_owner_state'].value        = '';
		myform.elements[owner_type + '_suburb_popup'].value       = '';
		myform.elements[owner_type + '_owner_suburb'].value       = '';
		myform.elements[owner_type + '_postcode_popup'].value     = '';
		myform.elements[owner_type + '_owner_postcode'].value     = '';
		myform.elements[owner_type + '_match_mailaddr'].value     = '';
		myform.elements[owner_type + '_mail_address'].value       = '';
		myform.elements[owner_type + '_mail_state'].value         = '';
		myform.elements[owner_type + '_mailsuburb_popup'].value   = '';
		myform.elements[owner_type + '_mail_suburb'].value        = '';
		myform.elements[owner_type + '_mailpostcode_popup'].value = '';
		myform.elements[owner_type + '_mail_postcode'].value      = '';
		myform.elements[owner_type + '_owner_homephone'].value    = '';
		myform.elements[owner_type + '_owner_workphone'].value    = '';
		myform.elements[owner_type + '_owner_mobilephone'].value  = '';
		myform.elements[owner_type + '_owner_fax'].value          = '';
		myform.elements[owner_type + '_owner_email'].value        = '';
		myform.elements[owner_type + '_owner_altperson1'].value   = '';
		myform.elements[owner_type + '_owner_altphone1'].value    = '';
		myform.elements[owner_type + '_owner_altperson2'].value   = '';
		myform.elements[owner_type + '_owner_altphone2'].value    = '';
		myform.elements[owner_type + '_owner_password1'].value    = '';
		myform.elements[owner_type + '_owner_password2'].value    = '';
		myform.elements[owner_type + '_mailing_list'].value       = '';
	}

	function storeOwnerValues(myform, owner_type)
	{
		myform.elements[owner_type + '_owner_title'].value        = getSelectValue(myform.elements['owner_title']);
		myform.elements[owner_type + '_owner_firstname'].value    = myform.elements['owner_firstname'].value;
		myform.elements[owner_type + '_owner_lastname'].value     = myform.elements['owner_lastname'].value;
		myform.elements[owner_type + '_owner_address'].value      = myform.elements['owner_address'].value;
		myform.elements[owner_type + '_owner_state'].value        = getSelectValue(myform.elements['owner_state']);
		myform.elements[owner_type + '_suburb_popup'].value       = document.getElementById('suburb_container').innerHTML;
		myform.elements[owner_type + '_owner_suburb'].value       = getSelectValue(myform.elements['owner_suburb']);
		myform.elements[owner_type + '_postcode_popup'].value     = document.getElementById('postcode_container').innerHTML;
		myform.elements[owner_type + '_owner_postcode'].value     = getSelectValue(myform.elements['owner_postcode']);
		myform.elements[owner_type + '_match_mailaddr'].value     = getCheckboxValue(myform.elements['match_mailaddr']);
		myform.elements[owner_type + '_mail_address'].value       = myform.elements['mail_address'].value;
		myform.elements[owner_type + '_mail_state'].value         = getSelectValue(myform.elements['mail_state']);
		myform.elements[owner_type + '_mailsuburb_popup'].value   = document.getElementById('mailsuburb_container').innerHTML;
		myform.elements[owner_type + '_mail_suburb'].value        = getSelectValue(myform.elements['mail_suburb']);
		myform.elements[owner_type + '_mailpostcode_popup'].value = document.getElementById('mailpostcode_container').innerHTML;
		myform.elements[owner_type + '_mail_postcode'].value      = getSelectValue(myform.elements['mail_postcode']);
		myform.elements[owner_type + '_owner_homephone'].value    = myform.elements['owner_homephone'].value;
		myform.elements[owner_type + '_owner_workphone'].value    = myform.elements['owner_workphone'].value;
		myform.elements[owner_type + '_owner_mobilephone'].value  = myform.elements['owner_mobilephone'].value;
		myform.elements[owner_type + '_owner_fax'].value          = myform.elements['owner_fax'].value;
		myform.elements[owner_type + '_owner_email'].value        = myform.elements['owner_email'].value;
		myform.elements[owner_type + '_owner_altperson1'].value   = myform.elements['owner_altperson1'].value;
		myform.elements[owner_type + '_owner_altphone1'].value    = myform.elements['owner_altphone1'].value;
		myform.elements[owner_type + '_owner_altperson2'].value   = myform.elements['owner_altperson2'].value;
		myform.elements[owner_type + '_owner_altphone2'].value    = myform.elements['owner_altphone2'].value;
		myform.elements[owner_type + '_owner_password1'].value    = myform.elements['owner_password1'].value;
		myform.elements[owner_type + '_owner_password2'].value    = myform.elements['owner_password2'].value;
		myform.elements[owner_type + '_mailing_list'].value       = getRadioValue(myform.elements['mailing_list']);
	}

	function retrieveOwnerValues(myform, owner_type)
	{
		setSelectValue(myform.elements['owner_title']               , myform.elements[owner_type + '_owner_title'].value);
		myform.elements['owner_firstname'].value                    = myform.elements[owner_type + '_owner_firstname'].value;
		myform.elements['owner_lastname'].value                     = myform.elements[owner_type + '_owner_lastname'].value;
		myform.elements['owner_address'].value                      = myform.elements[owner_type + '_owner_address'].value;
		setSelectValue(myform.elements['owner_state']               , myform.elements[owner_type + '_owner_state'].value);
		document.getElementById('suburb_container').innerHTML       = myform.elements[owner_type + '_suburb_popup'].value;
		setSelectValue(myform.elements['owner_suburb']              , myform.elements[owner_type + '_owner_suburb'].value);
		document.getElementById('postcode_container').innerHTML     = myform.elements[owner_type + '_postcode_popup'].value;
		setSelectValue(myform.elements['owner_postcode']            , myform.elements[owner_type + '_owner_postcode'].value);
		setCheckboxValue(myform.elements['match_mailaddr']          , myform.elements[owner_type + '_match_mailaddr'].value);
        setCheckboxValue(myform.elements['match_petaddr']           , myform.elements[owner_type + '_match_petaddr'].value);
		myform.elements['mail_address'].value                       = myform.elements[owner_type + '_mail_address'].value
		setMatchMailAddr();
        setMatchPetAddr();
		setSelectValue(myform.elements['mail_state']                , myform.elements[owner_type + '_mail_state'].value);
		document.getElementById('mailsuburb_container').innerHTML   = myform.elements[owner_type + '_mailsuburb_popup'].value;
		setSelectValue(myform.elements['mail_suburb']               , myform.elements[owner_type + '_mail_suburb'].value);
		document.getElementById('mailpostcode_container').innerHTML = myform.elements[owner_type + '_mailpostcode_popup'].value;
		setSelectValue(myform.elements['mail_postcode']             , myform.elements[owner_type + '_mail_postcode'].value);
		myform.elements['owner_homephone'].value                    = myform.elements[owner_type + '_owner_homephone'].value;
		myform.elements['owner_workphone'].value                    = myform.elements[owner_type + '_owner_workphone'].value;
		myform.elements['owner_mobilephone'].value                  = myform.elements[owner_type + '_owner_mobilephone'].value;
		myform.elements['owner_fax'].value                          = myform.elements[owner_type + '_owner_fax'].value;
		myform.elements['owner_email'].value                        = myform.elements[owner_type + '_owner_email'].value;
		myform.elements['owner_altperson1'].value                   = myform.elements[owner_type + '_owner_altperson1'].value;
		myform.elements['owner_altphone1'].value                    = myform.elements[owner_type + '_owner_altphone1'].value;
		myform.elements['owner_altperson2'].value                   = myform.elements[owner_type + '_owner_altperson2'].value;
		myform.elements['owner_altphone2'].value                    = myform.elements[owner_type + '_owner_altphone2'].value;
		myform.elements['owner_password1'].value                    = myform.elements[owner_type + '_owner_password1'].value;
		myform.elements['owner_password2'].value                    = myform.elements[owner_type + '_owner_password2'].value;
		setRadioValue(myform.elements['mailing_list']               , myform.elements[owner_type + '_mailing_list'].value);
	}

</script>

</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<?php

    /****************** Fetch Savage list ******************/
    $fmrSavage = fFMFindAll('petsafe', 'Web - Savage List');

    // Fetch all savage types into array
	$fmcSavage = $fmrSavage["response"]["data"];
	$savageList = array();
            foreach ($fmcSavage as $savageLine)
            {
                $savageList[]= $savageLine["fieldData"]['Savage'];
            }
            asort($savageList);
    $savage_popup = popup($savageList, 'pet_savage', $fmcPet['Savage']);
    
	/****************** Fetch Rego help info ******************/
    $aRequest = array();
    $aRequest['code'] = '="RegistrationInfo"';

    $fmrRegoInfo = fFMPerformFind('petsafe', 'Web - WebContent', $aRequest);
	$fmcRegoInfo = $fmrRegoInfo["response"]["data"][0];
	$regoInfo = $fmcRegoInfo['fieldData']['Content'];

	/****************** Default values ***********************/
	$companyid = '';

	/****************** Fetch Vet details if logged in ******************/
	if ($_SESSION['VetID'] != ''){
		// get vet details
		$aRequest = array();
		$aRequest['_pk_vet_id'] = '="' . $_SESSION['VetID'] . '"';

		$fmrVet = fFMPerformFind('petsafe', 'All Fields - Vet', $aRequest);
		$fmcVet = $fmrVet["response"]["data"][0];

		// get vet companies and fill select list for Clinic ID
		$aRequest = array();
		$aRequest['_sk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
		$aRequest['cvr_Companies::dont_show_on_web'] = '=';
		$fmrVetCompanies = fFMPerformFind('petsafe', 'All Fields - Company_Vet_Relation', $aRequest);
	}

	echo '<br/><h2 class="greenheading">Change Owner</h2>';

?>

<form action="chip_owner_submit.php" method="post" name="frmregister" id="frmregister">
<?php
if (strtolower($err_code) == 'incomplete'){
	echo '<span style="color:red; font-weight: bold;">Please complete all mandatory fields</span>';
}
if ($err_code == 'InvalidMemberID'){
	echo '<span style="color: red">The member id you entered was NOT found! Please try again.</span>';
}
?>
<!-- Previous Owner Type  -->
<input type="hidden" name="previous_owner_type"       value="current">
<!-- Current Owner Details -->
<input type="hidden" name="current_owner_title"        value="<?php echo htmlspecialchars($fmcOwner['Title']); ?>">
<input type="hidden" name="current_owner_firstname"    value="<?php echo htmlspecialchars($fmcOwner['Given Name']); ?>">
<input type="hidden" name="current_owner_lastname"     value="<?php echo htmlspecialchars($fmcOwner['Last Name']); ?>">
<input type="hidden" name="current_owner_address"      value="<?php echo htmlspecialchars($fmcOwner['Street']); ?>">
<input type="hidden" name="current_owner_state"        value="<?php echo htmlspecialchars($fmcOwner['State']); ?>">
<input type="hidden" name="current_suburb_popup"       value="<?php echo htmlspecialchars($current_suburb_popup); ?>">
<input type="hidden" name="current_owner_suburb"       value="<?php echo htmlspecialchars($fmcOwner['Suburb']); ?>">
<input type="hidden" name="current_owner_postcode"     value="<?php echo htmlspecialchars($fmcOwner['Postcode']); ?>">
<input type="hidden" name="current_postcode_popup"     value="<?php echo htmlspecialchars($current_postcode_popup); ?>">
<input type="hidden" name="current_match_mailaddr"     value="<?php echo $current_match_mailaddr; ?>">
<input type="hidden" name="current_match_petaddr"      value="<?php echo $current_match_petaddr; ?>">
<input type="hidden" name="current_mail_address"       value="<?php echo htmlspecialchars($fmcOwner['Mailing Street']); ?>">
<input type="hidden" name="current_mail_state"         value="<?php echo htmlspecialchars($fmcOwner['Mailing State']); ?>">
<input type="hidden" name="current_mailsuburb_popup"   value="<?php echo htmlspecialchars($current_mailsuburb_popup); ?>">
<input type="hidden" name="current_mail_suburb"        value="<?php echo htmlspecialchars($fmcOwner['Mailing Suburb']); ?>">
<input type="hidden" name="current_mailpostcode_popup" value="<?php echo htmlspecialchars($current_mailpostcode_popup); ?>">
<input type="hidden" name="current_mail_postcode"      value="<?php echo htmlspecialchars($fmcOwner['Mailing Postcode']); ?>">
<input type="hidden" name="current_owner_homephone"    value="<?php echo htmlspecialchars($fmcOwner['Home Phone']); ?>">
<input type="hidden" name="current_owner_workphone"    value="<?php echo htmlspecialchars($fmcOwner['Work Phone']); ?>">
<input type="hidden" name="current_owner_mobilephone"  value="<?php echo htmlspecialchars($fmcOwner['Mobile']); ?>">
<input type="hidden" name="current_owner_fax"          value="<?php echo htmlspecialchars($fmcOwner['Fax']); ?>">
<input type="hidden" name="current_owner_email"        value="<?php echo htmlspecialchars($fmcOwner['Email']); ?>">
<input type="hidden" name="current_owner_altperson1"   value="<?php echo htmlspecialchars($fmcOwner['Alt Person A']); ?>">
<input type="hidden" name="current_owner_altphone1"    value="<?php echo htmlspecialchars($fmcOwner['Phone A']); ?>">
<input type="hidden" name="current_owner_altperson2"   value="<?php echo htmlspecialchars($fmcOwner['Alt Person B']); ?>">
<input type="hidden" name="current_owner_altphone2"    value="<?php echo htmlspecialchars($fmcOwner['Phone B']); ?>">
<input type="hidden" name="current_owner_password1"    value="<?php echo htmlspecialchars($fmcOwner['Password']); ?>">
<input type="hidden" name="current_owner_password2"    value="<?php echo htmlspecialchars($fmcOwner['Password']); ?>">
<input type="hidden" name="current_owner_recordId"     value="<?php echo $fmcOwnerId; ?>">
<input type="hidden" name="current_mailing_list"       value="<?php if($fmcOwner['Mail List'] == 'Yes') { echo 'Yes'; } else { echo 'No'; }; ?>">
<!-- New Owner Details -->
<input type="hidden" name="new_owner_title"        value="">
<input type="hidden" name="new_owner_firstname"    value="">
<input type="hidden" name="new_owner_lastname"     value="">
<input type="hidden" name="new_owner_address"      value="">
<input type="hidden" name="new_owner_state"        value="">
<input type="hidden" name="new_suburb_popup"       value="<?php echo htmlspecialchars($suburb_popup); ?>">
<input type="hidden" name="new_owner_suburb"       value="">
<input type="hidden" name="new_postcode_popup"     value="<?php echo htmlspecialchars($postcode_popup); ?>">
<input type="hidden" name="new_owner_postcode"     value="">
<input type="hidden" name="new_match_mailaddr"     value="1">
<input type="hidden" name="new_match_petaddr"      value="1">
<input type="hidden" name="new_mail_address"       value="">
<input type="hidden" name="new_mail_state"         value="">
<input type="hidden" name="new_mailsuburb_popup"   value="<?php echo htmlspecialchars($mailsuburb_popup); ?>">
<input type="hidden" name="new_mail_suburb"        value="">
<input type="hidden" name="new_mailpostcode_popup" value="<?php echo htmlspecialchars($mailpostcode_popup); ?>">
<input type="hidden" name="new_mail_postcode"      value="">
<input type="hidden" name="new_owner_homephone"    value="">
<input type="hidden" name="new_owner_workphone"    value="">
<input type="hidden" name="new_owner_mobilephone"  value="">
<input type="hidden" name="new_owner_fax"          value="">
<input type="hidden" name="new_owner_email"        value="">
<input type="hidden" name="new_owner_altperson1"   value="">
<input type="hidden" name="new_owner_altphone1"    value="">
<input type="hidden" name="new_owner_altperson2"   value="">
<input type="hidden" name="new_owner_altphone2"    value="">
<input type="hidden" name="new_owner_password1"    value="">
<input type="hidden" name="new_owner_password2"    value="">
<input type="hidden" name="new_mailing_list"       value="Yes">

<table border="0" width="540">
	<tr>
		<td valign="top">Microchip No:</td>
		<td valign="top"><input type="hidden" value="<?php echo $fmcChip['_pk_chip_id']; ?>" name="chip_id" /><?php echo $fmcChip['Chip No']; ?></td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td align="right"><input type="radio" name="owner_type" value="current" checked onclick="return changeOwnerType(this.form);"></td>
		<td><b>Update details for the current Owner</b></td>
	</tr>
	<tr>
		<td align="right"><input type="radio" name="owner_type" value="existing" onclick="return changeOwnerType(this.form);"></td>
		<td><b>or Enter Existing Member ID for the Owner</b></td>
	</tr>
	<tr>
		<td align="right"><input type="radio" name="owner_type" value="new" onclick="return changeOwnerType(this.form);"></td>
		<td><b>or Enter Details for a New Owner</b></td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr id="idOwnerTypeExisting" style="display: none;">
		<td colspan="2"><table border="0" width="100%">
			<tr>
				<td><span style="color:red"><sup>*</sup></span> Member ID</td>
				<td valign="top"><input type="hidden" value="<?php echo $member_id; ?>" name="old_member_id" /><input type="text" size="30" value="<?php echo $member_id; ?>" name="member_id" /></td>
			</tr>
		</table></td>
	</tr>
	<tr id="idOwnerTypeNew">
		<td colspan="2"><table border="0" width="100%">
			<tr>
				<td>Name</td>
				<td valign="top">
					<table border="0" cellpadding="1">
						<tr>
							<td><span style="color:red"><sup>*</sup></span> Title</td>
							<td><span style="color:red"><sup>*</sup></span> Given Name</td>
							<td><span style="color:red"><sup>*</sup></span> Last Name</td>
						</tr>
						<tr>
							<td>
								<select name="owner_title">
									<option value=""></option>
									<option value="Dr">Dr</option>
									<option value="Mr">Mr</option>
									<option value="Mrs">Mrs</option>
									<option value="Ms">Ms</option>
								</select>
							</td>
							<td><input type="text" size="15" value="" name="owner_firstname" /></td>
							<td><input type="text" size="15" value="" name="owner_lastname" /></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td><span style="color:red"><sup>*</sup></span> Street Address</td>
				<td valign="top">
					Unit/Street No &nbsp;&nbsp;Street Name<br/>
					<input type="text" size="30" value="" name="owner_address" />
				</td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> State</td>
				<td valign="top">
					<?php echo $state_popup ?>
				<td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> Suburb</td>
				<td valign="top">
					<div id="suburb_container"><?php echo $suburb_popup ?></div>
				<td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> Postcode</td>
				<td valign="top">
					<div id="postcode_container"><?php echo $postcode_popup ?></div>
				<td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2"><input type="checkbox" name="match_mailaddr" value="1" onclick="setMatchMailAddr(); if(this.checked == false){alert('Please enter mailing address if different from owner\'s address.');}" /> Mailing address same as above</td>
			</tr>
			<tr>
				<td colspan="2">
					<div id="mailaddr" name="mailaddr">
					<table width="100%" border="0">
					<tr>
						<td>Mailing Address</td>
						<td valign="top">
							<input type="text" size="30" value="" name="mail_address" />
						</td>
					</tr>
					<tr>
						<td valign="top">State</td>
						<td valign="top">
							<?php echo $mailstate_popup ?>
						<td>
					</tr>
					<tr>
						<td valign="top">Suburb</td>
						<td valign="top">
							<div id="mailsuburb_container"><?php echo $mailsuburb_popup ?></div>
						<td>
					</tr>
					<tr>
						<td valign="top">Postcode</td>
						<td valign="top">
							<div id="mailpostcode_container"><?php echo $mailpostcode_popup ?></div>
						<td>
					</tr>
					</table>
					</div>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> Tel (H)</td>
				<td valign="top">
					<input type="text" size="12" value="" name="owner_homephone" />
					&nbsp;
					Tel (W)
					<input type="text" size="12" value="" name="owner_workphone" />
				</td>
			</tr>
			<tr>
				<td valign="top">Mobile</td>
				<td valign="top">
					<input type="text" size="12" value="" name="owner_mobilephone" />
					&nbsp;&nbsp;&nbsp;
					Fax
					<input type="text" size="12" value="" name="owner_fax" />
				</td>
			</tr>
			<tr>
				<td valign="top">E-mail address</td>
				<td valign="top">
					<input type="text" size="40" value="" name="owner_email"/>
					<div id="email_err"></div>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td valign="top">Alternative person 1</td>
				<td valign="top">
					<input type="text" size="20" value="" name="owner_altperson1" />
					&nbsp;
					Tel
					<input type="text" size="12" value="" name="owner_altphone1" />
				</td>
			</tr>
			<tr>
				<td valign="top">Alternative person 2</td>
				<td valign="top">
					<input type="text" size="20" value="" name="owner_altperson2" />
					&nbsp;
					Tel
					<input type="text" size="12" value="" name="owner_altphone2" />
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td valign="top" nowrap="nowrap"><span style="color:red"><sup>*</sup></span> Enter your Petsafe Password</td>
				<td valign="top">
					<input type="password" size="15" maxlength="12" value="" name="owner_password1" />
				</td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> Re-Enter Password</td>
				<td valign="top">
					<input type="password" size="15" maxlength="12" value="" name="owner_password2" />
				</td>
			</tr>
			<tr>
				<td valign="top">&nbsp;</td>
				<td valign="top">
					The password can contain a combination of letters & numbers both in lower case
					and upper case. Please limit password to no more than 12 characters.
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td valign="top">Join PetSafe Mailing List?</td>
				<td valign="top">
					<input type="radio" name="mailing_list" checked="checked" value="Yes"/> Yes
					&nbsp;&nbsp;
					<input type="radio" name="mailing_list" value="No"/> No
					<br/>
					<span class="smalltext"><a href="privacysecurity.php" target="_blank"><b>Privacy Policy</b></a></span>
				</td>
			</tr>
		</table></td>
	</tr>
	<tr>
		<td colspan="2"><br/><b>Pet's Details</b></b><br/>&nbsp;</td>
	</tr>
	<tr>
		<td valign="top"><span style="color:red"><sup>*</sup></span> Pet's Name</td>
		<td valign="top"><input type="hidden" name="pet_id" value="<?php echo $pet_id; ?>"><input type="text" size="15" value="<?php echo htmlspecialchars($fmcPet['Name']); ?>" name="pet_name" /></td>
	</tr>
	<tr>
		<td valign="top"><span style="color:red"><sup>*</sup></span> Species</td>
		<td valign="top">
			<input type="radio" name="pet_type" value="Dog"   <?php if ($fmcPet['Type'] == 'Dog') echo 'checked'; ?> />Dog
			<input type="radio" name="pet_type" value="Cat"   <?php if ($fmcPet['Type'] == 'Cat') echo 'checked'; ?> />Cat
            <input type="radio" name="pet_type" value="Horse" <?php if ($fmcPet['Type'] == 'Horse') echo 'checked'; ?> />Horse
			<input type="radio" name="pet_type" value="Other" <?php if ($fmcPet['Type'] == 'Other') echo 'checked'; ?> />Other
		</td>
	</tr>
	<tr>
		<td valign="top"><span style="color:red"><sup>*</sup></span> Colour</td>
		<td valign="top">
			<input type="text" size="15" value="<?php echo htmlspecialchars($fmcPet['Colour']); ?>" name="pet_colour" />
			<span style="color:red"><sup>*</sup></span> Breed
			<input type="text" size="15" value="<?php echo htmlspecialchars($fmcPet['Breed']); ?>" name="pet_breed" />
		</td>
	</tr>
	<tr>
		<td valign="top"><span style="color:red"><sup>*</sup></span> DOB</td>
		<td valign="top">
			<input type="text" maxlength="2" size="2" value="<?php if ($fmcPet['DOB'] != '') echo date('d', strtotime( $fmcPet['DOB'] ) ); ?>" name="pet_dob_dd" />
			/
			<input type="text" maxlength="2" size="2" value="<?php if ($fmcPet['DOB'] != '') echo date('m', strtotime( $fmcPet['DOB'] ) ); ?>" name="pet_dob_mm" />
			/
			<input type="text" maxlength="4" size="4" value="<?php if ($fmcPet['DOB'] != '') echo date('Y', strtotime( $fmcPet['DOB'] ) ); ?>" name="pet_dob_yyyy" />
			(DD/MM/YYYY)
			<br/>
			Sex 
			<input type="radio" name="pet_sex" value="M" <?php if ($fmcPet['Sex'] == 'M'  ) echo 'checked'; ?> />M
			<input type="radio" name="pet_sex" value="F" <?php if ($fmcPet['Sex'] == 'F') echo 'checked'; ?> />F
			&nbsp;
			Desexed
			<input type="radio" name="pet_desexed" value="Yes" <?php if ($fmcPet['Desexed'] == 'Yes') echo 'checked'; ?> />Yes
			<input type="radio" name="pet_desexed" value="No"  <?php if ($fmcPet['Desexed'] == 'No' ) echo 'checked'; ?> />No
		</td>
	</tr>
	<tr>
		<td valign="top">Savage Status</td>
		<td valign="top">
        <div id="petsavage_container"><?php echo $savage_popup ?></div>
		</td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td colspan="2"><input type="checkbox" name="match_petaddr" value="1" <?php echo $fmcPet['Address Same As Owner'] == 'Yes' ? 'checked' : ''; ?> onclick="setMatchPetAddr(); if(this.checked == false){alert('Please enter pet\'s address if different from owner\'s address.');}" /> Pet's address same as Owner's</td>
	</tr>
	<tr>
		<td colspan="2">
			<div id="petaddr" name="petaddr" <?php echo $fmcPet['Address Same As Owner'] == 'Yes' ? 'style="display: none;"' : ''; ?>>
			<table width="100%" border="0">
			<tr>
				<td>Street Address</td>
				<td valign="top">
					Unit/Street No &nbsp;&nbsp;Street Name<br/>
					<input type="text" size="30" value="<?php echo $fmcPet['Display Street']; ?>" name="pet_address" />
				</td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> State</td>
				<td valign="top">
					<?php echo $petstate_popup ?>
				<td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> Suburb</td>
				<td valign="top">
					<div id="petsuburb_container"><?php echo $petsuburb_popup ?></div>
				<td>
			</tr>
			<tr>
				<td valign="top"><span style="color:red"><sup>*</sup></span> Postcode</td>
				<td valign="top">
					<div id="petpostcode_container"><?php echo $petpostcode_popup ?></div>
				<td>
			</tr>
			</table>
			</div>
		</td>
	</tr>
	<tr>
		<td valign="top" colspan="2">
			<br/><input type="submit" value=" Submit " class="button" onclick="javascript: if(!validateForm(this.form)) return false;" />
		</td>
	</tr>
</table>
</form>

<br/><br/>

</td>

<td valign="top" align="right">

<br/><br/>

<div style="width:400px; text-align: left;">
  <b class="instructions">
  <b class="instructions1"><b></b></b>
  <b class="instructions2"><b></b></b>
  <b class="instructions3"></b>
  <b class="instructions4"></b>
  <b class="instructions5"></b></b>

  <div class="instructionsfg">
    <?php echo html_entity_decode($regoInfo) . '<br />'; ?>
	<div style="position:relative;left:-62px;"><img src="<?php echo $gaPage['root_directory']; ?>/images/cockatoo_sm.png" /></div>
  </div>

  <b class="instructions">
  <b class="instructions5"></b>
  <b class="instructions4"></b>
  <b class="instructions3"></b>
  <b class="instructions2"><b></b></b>
  <b class="instructions1"><b></b></b></b>
</div>

<br/><br/>

</td>



<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>