<?php
	/***********************************************************************************
    *	This page is used to process the data when the owner change fee is 0
	*   This is used to bypass paypal because it doesn't accept 0 as valid amount.
	*   Jaime Aramburo 26/08/2015 
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Defaults *********************/
	fDefaultParameter('transaction_id', $_POST, ''); // transaction id
	fDefaultParameter('chip_id', $_POST, ''); // transaction id
	
	$chip_id = $_POST['chip_id'];
	$transaction_id= $_POST['transaction_id'];

	$aRequest = array();
	$aRequest['_pk_chip_id'] = '="' . $chip_id . '"';

	$fmrChip = fFMPerformFind('petsafe', 'All Fields - Chips', $aRequest);

	/************ Check for not found or duplicate ************/
	if ($fmrChip === FALSE || $fmrChip["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Not found
		fCleanup();
	}
	
	$fmcChip = $fmrChip["response"]["data"][0];

	// Get the pet details
	$aRequest = array();
	$aRequest['_pk_pet_id'] = '="' . $fmcChip['fieldData']['_sk_pet_id'] . '"';

	$fmrPet = fFMPerformFind('petsafe', 'All Fields - Pets', $aRequest);

	/************ Check for not found or duplicate ************/
	if ($fmrPet === FALSE || $fmrPet["response"]["dataInfo"]["foundCount"] != 1)
	{
		// Not found
		fCleanup();
	}
	
	///////
	//AMOUNT IS 0, SO UPDATE INFO USING THE WEB PAYMENTS TABLE
	$aRequest = array();
	$aRequest['cookie_transaction_id'] = '="' . $transaction_id . '"';
	
	$fmrTransaction = fFMPerformFind('petsafe', 'All Fields - Web_Payments', $aRequest);
	
	if ($fmrTransaction === FALSE || $fmrTransaction["response"]["dataInfo"]["foundCount"] < 1){
		// invalid transaction
		fCleanup();
	}else{
		$fmrTransactionRecord = $fmrTransaction["response"]["data"][0];
		
		$new_owner_id = $fmrTransactionRecord['fieldData']['_sk_member_id'];
		$pet_street = $fmrTransactionRecord['fieldData']['pet_street'];
		$pet_suburb = $fmrTransactionRecord['fieldData']['pet_suburb'];
		$pet_state = $fmrTransactionRecord['fieldData']['pet_state'];
        $pet_type = $fmrTransactionRecord['fieldData']['pet_type'];
		$pet_postcode = $fmrTransactionRecord['fieldData']['pet_postcode'];
		$address_same_as_owner = $fmrTransactionRecord['fieldData']['pets_address_same_as_owners'];
	}
	////////////
	
	$fmcPet = $fmrPet["response"]["data"][0];
    $recordId = $fmcPet['recordId'];
	$old_owner_id = $fmcPet['fieldData']['_sk_member_id'];

	// Update the pet record with new owner
	$aUpdate = array();
	$aUpdate['_sk_member_id']         = $new_owner_id;
	$aUpdate['Address Same As Owner'] = $address_same_as_owner;
	$aUpdate['Street']                = $pet_street;
	$aUpdate['Suburb']                = $pet_suburb;
	$aUpdate['State']                 = $pet_state;
    $aUpdate['Type']                  = $pet_type;
	$aUpdate['Postcode']              = $pet_postcode;

	// update pet details
	$fmrPetUpdate = fFMPerformUpdate('petsafe', 'Web - Pets', $recordId, $aUpdate);
	
	$member_id = $new_owner_id;
	$pet_id    = $fmcChip['fieldData']['_sk_pet_id'];
	$chip_no   = $fmcChip['fieldData']['Chip No'];
	
	//save change in pet history
	$aRequest = array();
	$aRequest['_sk_pet_id'] = '="' . $pet_id . '"';
	$aSort[]=["fieldName" => "creation_timestamp", "sortOrder" => "ascend"];
	$fmrHistory = fFMPerformFind('petsafe', 'All Fields - Pet_History', $aRequest, $aSort);
	
	if($old_owner_id != $new_owner_id){
		//if there is already history, check if the last added record is different from the new owner, if so, log the change
		if ($fmrHistory === FALSE){
			$aInsert = array();
			$aInsert['_sk_member_id'] = $old_owner_id;
			$aInsert['_sk_pet_id'] = $pet_id;
	
			$fmcHistory = fFMPerformInsert('petsafe', 'All Fields - Pet_History', $aInsert);
			
		}elseif($fmrHistory["response"]["dataInfo"]["foundCount"] > 0){
			$fmrHistoryRecord = $fmrHistory["response"]["data"][0];
			
			if($old_owner_id != $fmrHistoryRecord['fieldData']['_sk_member_id']){
				$aInsert = array();
				$aInsert['_sk_member_id'] = $old_owner_id;
				$aInsert['_sk_pet_id'] = $pet_id;
				
				$fmcHistory = fFMPerformInsert('petsafe', 'All Fields - Pet_History', $aInsert);
			}
		}
	}
	
    try{
        // ADD TO LOG: updated member details
        if ($old_owner_id != $new_owner_id){
            $aInsert = array();
            $aInsert['_sk_member_id'] = isset($_SESSION['MemberID']) ? $_SESSION['MemberID'] : '';
            $aInsert['_sk_chip_no'] = $chip_no;
            $aInsert['_sk_vet_id'] = isset($_SESSION['VetID']) ? $_SESSION['VetID'] : '';
			$aInsert['is_web_admin_login'] = isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0;
            $log_description = 'Updated Pet Details for Pet: ' . $pet_id . ' - ' . $fmcPet['fieldData']['Name'] . '. [Old Owner ID:' . $old_owner_id . ' -> New Owner ID:' . $new_owner_id . ']';
            $aInsert['description'] = $log_description;
            $fmrLog = fFMPerformInsert('petsafe', 'Web - Audit', $aInsert);
        }
    }
    catch(Exception $e) {}
	
	fRedirect('chip_owner_paymentthanks.php?id=' . $chip_id . '&id=' . $transaction_id);
?>
