<?php
	/***********************************************************************************
	*   Filename    : companyvets.php
	*   Description : Petsafe Vets within a company
	*
	*   Date        Modification By      Description
	* 	20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*   29/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('companyid', $_GET, '');

	$err_code = $_GET['err_code'];
	$companyid = $_GET['companyid'];

    /************ Only allow logged in vets to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}
	/********************* Page Functions *********************/
	function isVetMainContact($vetid, $companyid){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "_sk_vet_id eq ".$vetid." and _sk_company_id eq ".$companyid,
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );

		return $response;
    }

	function getVetsForClinic($companyid){
		$fm = \Keysoft\FileMaker\Client::getInstance();
		$odataQuery = $fm->buildODataQuery([
			'filter' => "_sk_company_id eq ".$companyid,
			'select' => ['vet_license_number','implanter_number','vet_name_c','_sk_vet_id','_pk_record_id'],
            'count' => true
        ]);
        $response = $fm->get('Company_Vet_Relation', $odataQuery ,$allPages = true );
        
		if (!$response['success'])
        {
            // Redirect
			var_dump($response);
			die;
        }

        return $response;
    }

	// get company details, if main vet
	// check if user is the main vet for this company
	$fmrVet = isVetMainContact( $_SESSION['VetID'] , $companyid);
	$fmcVet = $fmrVet['data']['value'][0];


	if ($fmcVet['vet_main_contact'] != 'Yes'){
		//Redirect - Not Authorised
		fRedirect('myaccount.php');
		fCleanup();
	} else{
		// get company details
		$companyname = $fmcVet['companyName'];
	}
	
	$fmrVetList = getVetsForClinic($companyid);
	$fmcVetList = $fmrVetList["data"];

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<table border="0" cellpadding="5" width="70%">
<tr>
	<td><b>Vet License #</b></td>
	<td><b>Implanter Number</b></td>
	<td><b>Vet Name</b></td>
	<td>&nbsp;</td>
</tr>
<?php

	echo '<br/><h2 class="orangeheading">' . $companyname . ': Vets List</h2><br/>';

	$rowcolor = '#FFFFFF';

	foreach ($fmcVetList['value'] as $fmcVet){

		if ($rowcolor == '#FFCC66'){
			$rowcolor = '#FFFFFF';
		} else $rowcolor = '#FFCC66';

		echo '<tr style="background-color: '. $rowcolor . '">';
		echo '<td>' . $fmcVet['vet_license_number'] . '</td>';
		echo '<td>' . $fmcVet['implanter_number'] . '</td>';
		echo '<td>' . $fmcVet['vet_name_c'] . '</td>';
		if ($fmcVet['_sk_vet_id'] != $_SESSION['VetID']) {
		//	echo '<td><a href="javascript: if (confirm(\'Do you wish to remove the selected vet from this company?\')) { location.href = \'companyvets_delete.php?companyid=' . $companyid . '&vetid=' . $fmcVet['_sk_vet_id'] . '\';}">Remove Vet</a></td>';
			echo '<td><a href="javascript: if (confirm(\'Do you wish to remove the selected vet from this company?\')) { location.href = \'companyvets_delete.php?companyid=' . $companyid . '&recid=' . $fmcVet['_pk_record_id'] . '\';}">Remove Vet</a></td>';

		} else echo '<td>Main Vet</td>';
		echo '</tr>';
	}

?>
</table>

<br/>
Return to <a href="myaccount.php"><b>My Account</b></a>
<br/><br/>
&nbsp;
</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>