<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*   16/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';
	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';

	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	$err_code = $_GET['err_code'];

	/********************* Page Functions *********************/
	/****** Get all Petsafe About Microchipping information ******/
    function getWebContent($code){
        $fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "contentCode eq '".$code."'",
			'select' => ['content'],
            'count' => true
        ]);
        $response = $fm->get('webContent', $odataQuery ,$allPages = true );
        
        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=No'.$code.'WebContentRecord');
            fCleanup();
        }
		$content = $response['data']['value'][0]['content'];
       
		return $content;
    }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<script language="javascript">
function submitForm(currForm){
	currForm.query.value = currForm.query1.value + currForm.query2.value + currForm.query3.value + currForm.query4.value + 
		currForm.query5.value + currForm.query6.value + currForm.query7.value + currForm.query8.value + currForm.query9.value + 
		currForm.query10.value + currForm.query11.value + currForm.query12.value + currForm.query13.value + currForm.query14.value + currForm.query15.value;
	//alert(currForm.query.value);
	return true;
}
</script>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>
<td>

<?php
    /************ Get all Petsafe About Us information ************/

	echo '<br />' . html_entity_decode(getWebContent('AboutUs')) . '<br />';

?>

<div>
    <a name="chipsearch"><span class="boldtext">Microchip Search</span></a>
    <form action="indexsearchresults.php" method="post" name="microchipsearch" id="microchipsearch">
		<input name="query"  class="grid" type="text" class="field" title="Enter microchip number" value="" />
		<input type="submit" value="  Find Microchip  " class="button" /><input type="hidden" name="searchtype" value="chip" />
		<br/><span class="smalltext">Enter Microchip Number To Check If Registered</span>
		<br/>
    </form>
</div>
<br/>
<div>
    <span class="boldtext">PetSafe Tag Search</span></a>
    <form action="indexsearchresults.php" method="post" name="tagsearch" id="tagsearch">
		<input name="query"  class="grid" type="text" class="field" title="Enter petsafe tag number" value="" />
		<input type="submit" value="  Find Tag  " class="button" />
		<input type="hidden" name="searchtype" value="tag" />
		<br/>
    	<span class="smalltext">Enter PetSafe Tag Number To Check If Registered</span>
	    <br/>
    </form>
</div>

<?php
if ($err_code == 'InvalidChip'){
	echo '<p style="color: red">The chip you searched for is invalid. ' .
		'Microchip number must be 10 Alpha numeric digits or 15 numeric digits. No spaces or hypens.</p>';
} else if ($err_code == 'InvalidTag'){
	echo '<p style="color: red">The PetSafe Tag you searched for is invalid.</p>';
} else if ($err_code == 'TagNotFound'){
	echo '<p style="color: red">The PetSafe Tag you searched for was not found.</p>';
} else if ($err_code == 'PetNotFound'){
	echo '<p style="color: red">The Microchip was found but it has not been implanted on any pet.</p>';
} else if ($err_code == 'ChipNotFound'){
	echo '<p style="color: red">The PetSafe Tag was found but the pet/chip details were not found.</p>';
} else if ($err_code == 'PetNotFound'){
	echo '<p style="color: red">There is no pet associated with this Chip.</p>';
} else if ($err_code == 'PetDuplicate'){
	echo '<p style="color: red">Error: This chip was found on more than 1 pet!</p>';
} else if ($err_code == 'NotAuthorised'){
	echo '<p style="color: red">You are not authorised to view the details of this chip/tag.</p>';
} else if ($err_code == 'PetAddress'){
	echo '<p style="color: red">Microchip was NOT found on the PetSafe web site.<br/>'.
		'<b><a href="http://www.petaddress.com.au">Click here</a> to search on the PetAddress.com.au database.</b></p>';
}

?>

<div><img src="<?php echo $gaPage['root_directory']; ?>/images/petsafe_com_au.jpg" />&nbsp;</div>

</td>

<td valign="top">
<br/><div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/girl_puppy.jpg" />&nbsp;</div>
</td>



<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>