<?php
	/***********************************************************************************
	*   Filename    : indexsearchlogin.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
    *
	*   Copyright Keysoft Pty Ltd 2009
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['onload'] = 'document.frmlogin2.vetid.focus();';

	/******************* Create the toolbar ******************/
	//$bc = fBCSetBreadCrumbs('');                              not required

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	fDefaultParameter('getquery', $_GET, '');
	fDefaultParameter('searchtype', $_GET, '');

    $getQueryValue = $_GET['getquery'];
    $getSearchType = $_GET['searchtype'];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
<script language="JavaScript" type="text/javascript"><!--
	function checkVetForm(myform)
	{
		if (myform.elements['vetid'].value == '')
		{
			alert('Please enter your vet login number or implanter number or e-mail address.');
			myform.elements['vetid'].focus();
			return false;
		}

		if (myform.elements['state'].selectedIndex == 0)
		{
			alert('Please select your state.');
			myform.elements['state'].focus();
			return false;
		}

		if (myform.elements['password'].value == '')
		{
			alert('Please enter your password.');
			myform.elements['password'].focus();
			return false;
		}

		return true;
	}
//--></script>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<?php
    /************ Only allow non-logged in users to login ************/

	if ($_SESSION['LoggedIn'] != 0){
		// Redirect
		fRedirect('index.php?err_code=LoggedIn');
		fCleanup();
	}

	echo '<br/><h2 class="greenheading">Login</h2><br/>';

?>

<b>Congratulations. The chip/tag you entered was found on the PetSafe database.</b>
<br/><br/>
<div>You must login before you can view the search results.</div>

<hr />

<form action="memberlogin_submit.php" method="post" name="frmlogin1" id="frmlogin1">
<table align="left" border="0" width="40%">
	<tr>
		<td colspan="2"><div class="boldtext">Member Login<br/>&nbsp;</div></td>
	</tr>
	<tr>
		<td valign="top" nowrap="nowrap">Member ID:</td>
		<td valign="top"><input type="text" size="20" value="" name="memberid" /><br/>
			<span class="smalltext">Please enter your Member ID here.<br/>
			(This can be found at the top of your PetSafe Certificate)<br/>&nbsp;</span></td>
	</tr>
	<tr>
		<td valign="top" nowrap="nowrap">Password:</td>
		<td valign="top"><input type="password" size="20" value="" name="password" /><br/>
			<span class="smalltext">Please enter your Password here.<br/>
			(This can be found at the top of your PetSafe Certificate)</span></td>
	</tr>
	<tr>
		<td valign="top">&nbsp;</td>
		<td valign="top">
			<br/><input type="submit" value="  Login  " class="button" />
			<input type="hidden" name="query" value="<?php echo $getQueryValue; ?>" />
			<input type="hidden" name="searchtype" value="<?php echo $getSearchType; ?>" />
		</td>
	</tr>
</table>
</form>

<form action="vetlogin_submit.php" method="post" name="frmlogin2" id="frmlogin2" onsubmit="return checkVetForm(this);">
<table border="0" width="40%">
	<tr>
		<td colspan="2"><div class="boldtext">Vet / Pound Login<br/>&nbsp;</div></td>
	</tr>
	<tr>
		<td valign="top" nowrap="nowrap">Vet ID:</td>
		<td valign="top"><input type="text" size="20" value="" name="vetid" /></td>
	</tr>
	<tr>
		<td valign="top" nowrap="nowrap">State:</td>
		<td valign="top"><select name="state" style="width: 80px;">
                <option value="" selected>-- Select -- </option>
                <option value="ACT">ACT</option>
				<option value="NSW">NSW</option>
				<option value="NT">NT</option>
                <option value="QLD">QLD</option>
                <option value="SA">SA</option>
                <option value="TAS">TAS</option>
				<option value="VIC">VIC</option>
                <option value="WA">WA</option>
		</select></td>
	</tr>
	<tr>
		<td valign="top" nowrap="nowrap">Password:</td>
		<td valign="top"><input type="password" size="20" value="" name="password" /></td>
	</tr>
	<tr>
		<td valign="top">&nbsp;</td>
		<td valign="top">
			<br/><input type="submit" value="  Login  " class="button" />
			<input type="hidden" name="query" value="<?php echo $getQueryValue; ?>" />
			<input type="hidden" name="searchtype" value="<?php echo $getSearchType; ?>" />
		</td>
	</tr>
</table>
</form>

</td>

<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>