<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   23/08/2022  John Muffett         Reworked for Data API
    *   29/07/2025  John Muffett         Reworked for oData API
    *
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

    /********************* Page Functions *********************/
	/*********************** Processing Start **********************/

	$entry = [];
	// ADD TO LOG: logout action
	if ($_SESSION['MemberID'] != ''){
		/************ Logout Member ************/
        $entry = [
            "_sk_member_id" => $_SESSION['MemberID'],
            "description" => 'Logged Out as Owner'
        ];
	} else if ($_SESSION['VetID'] != '') {
		/************ Logout Vet ************/
        $entry = [
            "_sk_vet_id" => $_SESSION['VetID'],
            "description" => 'Logged Out as Vet'
        ];
	} else {
        $entry = [
            "description" => 'Session Timed Out'
        ];
	}
	
	$entry['is_web_admin_login'] = isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0;

    makeLogEntry($entry);

	// reset session vars
	$_SESSION['LoggedIn'] = 0;
	$_SESSION['MemberID'] = '';
	$_SESSION['VetID'] = '';
	$_SESSION['IsAdminLogin'] = 0;
	$_SESSION['VetAllowSearch'] = '';
	$_SESSION['cookieid'] = '';

	// redirect to home
	fRedirect('index.php');
	fCleanup();


/************************ Processing End ***********************/

fCleanup();

?>