<?php
	/***********************************************************************************
	* 	Filename    : memberarea_submit.php
	*   Description : Update member details
	* 
	*	Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
 	*   23/08/2022  John Muffett         Rework to support Data API
	* 
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';


	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';


	/************ Only allow logged in members to this area ************/

	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['MemberID'] == ''){
		// Redirect
		fRedirect('logout.php');
		fCleanup();
	}
	
	/********************* Page Defaults *********************/
	fDefaultParameter('memberid', $_POST, '');
	fDefaultParameter('owner_address', $_POST, '');
	fDefaultParameter('owner_state', $_POST, '');
	fDefaultParameter('owner_postcode', $_POST, '');
	fDefaultParameter('owner_suburb', $_POST, '');
	fDefaultParameter('match_mailaddr', $_POST, '0');
	fDefaultParameter('mail_address', $_POST, '');
	fDefaultParameter('mail_state', $_POST, '');
	fDefaultParameter('mail_postcode', $_POST, '');
	fDefaultParameter('mail_suburb', $_POST, '');
	fDefaultParameter('owner_homephone', $_POST, '');
	fDefaultParameter('owner_workphone', $_POST, '');
	fDefaultParameter('owner_mobilephone', $_POST, '');
	fDefaultParameter('owner_fax', $_POST, '');
	fDefaultParameter('owner_email', $_POST, '');
	fDefaultParameter('owner_altperson1', $_POST, '');
	fDefaultParameter('owner_altperson2', $_POST, '');
	fDefaultParameter('owner_altphone1', $_POST, '');
	fDefaultParameter('owner_altphone2', $_POST, '');
	fDefaultParameter('owner_password1', $_POST, '');
	fDefaultParameter('mailing_list', $_POST, '0');

	// get values
	$memberid =  $_POST['memberid'];
	$owner_homephone = $_POST['owner_homephone'];
	$owner_workphone = $_POST['owner_workphone'];
	$owner_mobilephone = $_POST['owner_mobilephone'];
	$owner_email = 	$_POST['owner_email'];
	$owner_fax = $_POST['owner_fax'];
	$owner_password = $_POST['owner_password1'];
	$owner_altperson1 = $_POST['owner_altperson1'];
	$owner_altphone1 = $_POST['owner_altphone1'];
	$owner_altperson2 = $_POST['owner_altperson2'];
	$owner_altphone2 = $_POST['owner_altphone2'];
	$street = $_POST['owner_address'];
	$suburb = $_POST['owner_suburb'];
	$state = $_POST['owner_state'];
	$postcode = $_POST['owner_postcode'];
	$mailstreet = $_POST['mail_address'];
	$mailsuburb = $_POST['mail_suburb'];
	$mailstate = $_POST['mail_state'];
	$mailpostcode = $_POST['mail_postcode'];
	$mailinglist = $_POST['mailing_list'];
	$match_mailaddr = $_POST['match_mailaddr'];

	// ensure logged-in user is updating their own details
	if ($_SESSION['MemberID'] != $memberid){
		// Redirect if not authorised to update
		fRedirect('myaccount.php?err_code=NotAuthorised');
		fCleanup();
	}

	// get member/owner record
	$aRequest = array();
	$aRequest['_pk_member_id'] = '="' . $memberid . '"';

	$fmrMember = fFMPerformFind('petsafe', 'Web - Owners', $aRequest);
	$fmcMember = $fmrMember["response"]["data"][0];
	$recordid = $fmrMember["response"]["data"][0]["recordId"];

	//GET FIELD NAMES SO WE CAN COMPARE LATER WITH UPDATED VALUES
	$fmcMemberFields = array_flip($fmcMember[fieldData]);

	$aUpdate = array();
	$aUpdate['Street'] = $street;
	$aUpdate['Suburb'] = $suburb;
	$aUpdate['State'] = $state;
	$aUpdate['Postcode'] = $postcode;
	if ($match_mailaddr == 1) {
		$aUpdate['Mailing Street'] = $street;
		$aUpdate['Mailing Suburb'] = $suburb;
		$aUpdate['Mailing State'] = $state;
		$aUpdate['Mailing Postcode'] = $postcode;
	} else {
		$aUpdate['Mailing Street'] = $mailstreet;
		$aUpdate['Mailing Suburb'] = $mailsuburb;
		$aUpdate['Mailing State'] = $mailstate;
		$aUpdate['Mailing Postcode'] = $mailpostcode;
	}
	$aUpdate['Home Phone'] = fReformatPhones($owner_homephone);
	$aUpdate['Work Phone'] = fReformatPhones($owner_workphone);
	$aUpdate['Mobile'] = fReformatPhones($owner_mobilephone);
	$aUpdate['Fax'] = fReformatPhones($owner_fax);
	$aUpdate['Email'] = $owner_email;
	$aUpdate['Alt Person A'] = $owner_altperson1;
	$aUpdate['Alt Person B'] = $owner_altperson2;
	$aUpdate['Phone A'] = fReformatPhones($owner_altphone1);
	$aUpdate['Phone B'] = fReformatPhones($owner_altphone2);
	$aUpdate['Password'] = $owner_password;
	if (strtoupper($mailinglist) == 'YES'){
		$aUpdate['Mail List'] = $mailinglist;
	} else {
		$aUpdate['Mail List'] = '';
	}

	//CHECK WHAT VALUES WERE CHANGED TO LATER FORM LOG DESCRIPTION
	$updated_values = array();

	foreach($aUpdate as $key => $value){
		if(array_key_exists($key, $fmcMemberFields)){
			if(trim($value) != trim($fmcMember->getField($key))){
				$updated_values[] = strtoupper($key) . ': (' . trim($fmcMember->getField($key)) . ' -> ' . trim($value) . ')'; 
			}
		}
	}
	
	$audit_extended_description = ' [' . implode(', ', $updated_values) . ']';
	

	// update member details
	$fmrMemberUpdate = fFMPerformUpdate('petsafe', 'Web - Owners', $recordid, $aUpdate);

	// ADD TO LOG: updated member details
	$aInsert['_sk_member_id'] = $_SESSION['MemberID'];
	$aInsert['description'] = 'Updated Member Details.' . $audit_extended_description;
	$aInsert['is_web_admin_login'] = isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0;
	$fmrLog = fFMPerformInsert('petsafe', 'Web - Audit', $aInsert);

	// Redirect
	fRedirect('myaccount.php');
	fCleanup();
?>
