<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   14/11/2019	John Muffett	     Clean up of code to get working with PHP 7
	*
	*   Copyright Keysoft Pty Ltd 2009
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'purple';
	$gaPage['onload'] = 'document.frmlogin.memberid.focus();';

	/********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	$err_code = $_GET['err_code'];

	/********************* Page Functions *******************
	function getWebContent($code){
		$fm = \Keysoft\FileMaker\Client::getInstance();
        $odataQuery = $fm->buildODataQuery([
          	'filter' => "contentCode eq '".$code."'",
			'select' => ['content'],
            'count' => true
        ]);
        $response = $fm->get('webContent', $odataQuery ,$allPages = true );
        
        // Check for not found
        if (!$response['success'] || $response["data"]['count'] < 1)
        {
            // Redirect
            fRedirect('index.php?err_code=No'.$code.'WebContentRecord');
            fCleanup();
        }
		$content = $response['data']['value'][0]['content'];
       
		return $content;
    }**/
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<?php
    /************ Only allow non-logged in users to login ************/

	if ($_SESSION['LoggedIn'] != 0){
		// Redirect
		fRedirect('index.php?err_code=LoggedIn');
		fCleanup();
	}

	echo '<br/><h2 class="purpleheading">Member Login</h2><br/>';

if ($err_code == 'Incorrect'){
	echo '<p style="color: red">The login/password you entered is incorrect.<br/>' .
		'Please try again.</p>';
}
?>

<form action="memberlogin_submit.php" method="post" name="frmlogin" id="frmlogin">
<table border="0" width="90%">
	<tr>
		<td valign="top" nowrap="nowrap">Member ID:</td>
		<td valign="top"><input type="text" size="30" value="" name="memberid" /><br/>
			<span class="smalltext">Please enter your Member ID here.<br/>
			(This can be found at the top of your PetSafe Certificate)<br/>&nbsp;</span></td>
	</tr>
	<tr>
		<td valign="top" nowrap="nowrap">Password:</td>
		<td valign="top"><input type="password" size="20" value="" name="password" /><br/>
			<span class="smalltext">Please enter your Password here.<br/>
			(This can be found at the top of your PetSafe Certificate)</span></td>
	</tr>
	<tr>
		<td valign="top">&nbsp;</td>
		<td valign="top">
			<br/><input type="submit" value="  Login  " class="button" />
		</td>
	</tr>
</table>
</form>

<br/><hr />

<form action="forgotpass.php" method="post" name="frmpass" id="frmpass">
<a name="forgotpass"><div class="boldtext">Forgotten your password?</div><br/></a>
Enter Microchip Number or Member ID:
&nbsp;&nbsp;
<input type="text" size="30" value="" name="user_id" />
&nbsp;&nbsp;
<input type="hidden" name="usertype" value="owner" />
<input type="submit" value="Submit" class="button" />
</form>

<?php
if ($err_code == 'EmailSent'){
	echo '<p style="color: green">Your login details have been sent to the e-mail address linked to the ID provided.</p>';
} else if ($err_code == 'InvalidID'){
    echo '<p style="color: red">Sorry, your pet is not registered with Petsafe. You can check at the search site <a href="http://www.petaddress.com.au" target="_blank">www.petaddress.com.au</a> to see if it is registered on another database.</p>';
} else if ($err_code == 'InvalidEmail'){
    echo '<p style="color: red">No email address is linked to the Microchip Number / Member ID provided.</p>';
}
?>

<hr />

<?php
    /****** Get Extra page info ******/
    /************ Get MemberNotLoggedIn information ************/
	echo '<br />' . html_entity_decode(getWebContent('MemberNotLoggedIn')) . '<br />';
?>

<div><img src="<?php echo $gaPage['root_directory']; ?>/images/petsafe_com_au.jpg" />&nbsp;</div>

</td>

<td valign="top">
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/dog_ball.jpg" />&nbsp;</div>
</td>



<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>