<?php

    /***********************************************************************************
    *   Filename : microchip_by_clinic.php
	*   Description : Microchip Report By Clinic
	* 
	*   Date        Modification By      Description
	*   23/01/2009  Kenneth Ho           Initial Creation
	*   22/08/2022  John Muffett         Reworked for Data API
   	*
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Microchip Report';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

    /********************* Page Defaults *********************/
	fDefaultParameter('err_code',          $_GET, '');
	fDefaultParameter('clinic_id',         $_GET, '');

	$clinic_id         = $_GET['clinic_id'];
	$err_code          = $_GET['err_code'];

    /************ Only allow logged in vets to this area ************/
	
	if ($_SESSION['LoggedIn'] == 0 or $_SESSION['VetID'] == ''){
		// Redirect
		fRedirect('myaccount.php?err_code=NotAuthorised');
		fCleanup();
	}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<style>
	.chip-list-tbl{
		border-collapse:separate;
		overflow:hidden;
		border-radius:3px;
		box-shadow:0 0 3px rgba(0,0,0,0.15);
	}
	
	.chip-list-tbl tr td{
		border-bottom:1px solid #f0f0f0;
		padding:5px;
	}
	
	.chip-list-tbl thead th{
		border-bottom:1px solid #000;
		background-color:#1D6799;
		padding:10px;
		padding-left:5px;
		color:#fff;
		font-size:14px;
	}
	
	.chip-list-tbl .clinic-name-subheading{
		background-color:#FFF3B3;
		font-weight:bold;
		border-top:solid 1px #fff;
	}
	
	.chip-list-tbl tbody tr:nth-child(odd) {
		background-color: #f5f5f5;
	}
	
	.no-clinics-assigned{
		padding:10px;
		border:1px solid red;
		color:red;
		border-radius:1px;	
	}
</style>

<script language=javascript>

</script>

</head>

<?php require '../phpobjects/templates/common/page_header.php'; ?>

<td valign="top">

<br/>

<?php
    /*************************** Page Start ***************************/

	// Get vet's clinics.
	$aRequest = array();
	$aRequest['_sk_vet_id'] = '="' . $_SESSION['VetID'] . '"';
	$aRequest['cvr_Companies::dont_show_on_web'] = '=';
	$fmrVetCompanies = fFMPerformFind('petsafe', 'All Fields - Company_Vet_Relation', $aRequest);
	$has_clinics = false;
	
	if ($fmrVetCompanies === FALSE || $fmrVetCompanies["response"]["dataInfo"]["foundCount"] < 1){
		$has_clinics = false;
	} else {
		$has_clinics = true;
	}
?>


<h2 class="orangeheading">Microchip Report By Clinic</h2>

<?php
if (!$has_clinics){
	echo '<div class="no-clinics-assigned">You are not assigned to any clinic.</div><br>';
} else {
?>

<form method="get">
<table>
	<tr>
		<td>Select Clinic:&nbsp;</td>
		<td>
<?php
			$vet_clinics = array();
			$fmcVetCompanies = $fmrVetCompanies['response']['data'];
			echo '<select name="clinic_id" id="clinic_dropdown">';
			echo '<option value="all">All</option>';
			foreach ($fmcVetCompanies as $companyrecord){
				// get company details
				$aRequest = array();
				$aRequest['_pk_company_id'] = '="' . $companyrecord['fieldData']['_sk_company_id'] . '"';
				$aRequest['dont_show_on_web'] = '=';

				$vet_clinics[] = $companyrecord['fieldData']['_sk_company_id'];
				
				$fmrCompany = fFMPerformFind('petsafe', 'Web - Companies', $aRequest);
				$fmcCompany = $fmrCompany["response"]["data"][0];

				echo '<option value="' . $companyrecord['fieldData']['_sk_company_id'] . '">' . $fmcCompany['fieldData']['Company Name'] . '</option>';
			}
			
			echo '</select>';
?>
			<button type="submit" style="margin-left:10px;">Continue</button>
		</td>
	</tr>
</table>
</form>

<br />

<?php
	$found_chips = false;
	
	$aSort = array();
	$aSort[0] = ['fieldName'=>'chip_Clinic::_pk_company_id', 'sortOrder'=>'ascend'];
//	$aSort[1] = ['fieldName'=>'_pk_chip_id', 'sortOrder'=>'ascend'];
		$aSort[1] = ['fieldName'=>'implanted_date', 'sortOrder'=>'ascend'];

	if($clinic_id == 'all' && $has_clinics){
		$aRequestA = array();
		// Get all chips for vet's clinics
		$fmcVetCompanies = $fmrVetCompanies["response"]["data"];
		$aRequestB = array();
				
		foreach ($fmcVetCompanies as $companyrecord){
			$aRequestB['chip_Clinic::_pk_company_id'] = $companyrecord['fieldData']['_sk_company_id'];
			$aRequestA[] = $aRequestB;
		}
		

		//Find chips all vet's clinics
		$fmrChips = fFMCompoundFind('petsafe', 'Web - Chips', $aRequestA, $aSort);
		
		if ($fmrChips === FALSE || $fmrChips["response"]["dataInfo"]["foundCount"] < 1){
			$found_chips = false;
		} else {
			$found_chips = true;
			$fmcChips = $fmrChips['response']['data'];
		}
	}else if($clinic_id != '' && $has_clinics){
		//check if clinic belongs to vet.
		if(array_search(intval($clinic_id), $vet_clinics) === false){
			//
		}else{
			$aRequest = array();
			$aRequest['chip_Clinic::_pk_company_id'] = '="' . $clinic_id . '"';
			
			//find chips selected clinic
			$fmrChips = fFMPerformFind('petsafe', 'Web - Chips', $aRequest);
			
			if ($fmrChips === FALSE || $fmrChips["response"]["dataInfo"]["foundCount"] < 1){
				$found_chips = false;
			} else {
				$found_chips = true;
				$fmcChips = $fmrChips['response']['data'];
			}	
		}
	}
?>

<?php
if($clinic_id != ''){

	echo '<table border="0" cellpadding="2" cellspacing="0" width="100%" class="chip-list-tbl">';
	echo '<thead>';
    echo '<tr>';
    echo '<th>&nbsp;</th>';
    echo '<th>Microchip No.</th>';
    echo '<th align="center">Initial Member No.</th>';
    echo '<th>Initial Member Name</th>';
    echo '<th>Initial Pet Name</th>';
    echo '<th>Implanted Date</th>';
    echo '<th>Invoice No.</th>';
    echo '</tr>';
    echo '</thead>';
    
	$colspan = 7;
	
	if($found_chips){
		$chip_count = 0;
		$clinic_id_group = '';
		
		foreach ($fmcChips as $chip){
			$chip_count++;
			
			// Get values
			$clinic_id = $chip['fieldData']['chip_Clinic::_pk_company_id'];
			$clinic_name = $chip['fieldData']['chip_Clinic::Company Name'];
			$microchip_no = $chip['fieldData']['Chip No'];
			$member_no = $chip['fieldData']['c_Pet_Owner_initial'];
			$member_name = $chip['fieldData']['c_Pet_Owner Name_initial'];
			$pet_name = $chip['fieldData']['c_Pet_Name_initial'];
			$creation_date = $chip['fieldData']['implanted_date'];
			$invoice_no = $chip['fieldData']['chip_InvoiceItem::cInvoiceNo'];
			
			if($clinic_id != $clinic_id_group){
				echo '<tr><td class="clinic-name-subheading" colspan="' . $colspan . '" style="padding:10px;">' . $clinic_name . '</td></tr>';	
			}
			
			echo '<tr>';
			echo '<td style="font-size:8px; width:30px;">' . $chip_count . '</td>';
			echo '<td>' . $microchip_no . '</td>';
			echo '<td align="center">' . $member_no . '</td>';
			echo '<td>' . $member_name . '</td>';
			echo '<td>' . $pet_name . '</td>';
			echo '<td>' . $creation_date . '</td>';
			echo '<td>' . $invoice_no . '</td>';
			echo '</tr>';

			$clinic_id_group = $clinic_id;
		}
	}else{
		echo '<tr><td colspan="' . $colspan . '" style="padding:10px;">No chips found.</td></tr>';
	}

	echo '</table>';
	echo '<br />';
}

// end if has clinics assigned
}
?>


<?php
/************************* Page End **************************/
require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>