<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
    *
	*   Copyright Keysoft Pty Ltd 2022
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';

	/********************* Page Defaults *********************/
	fDefaultParameter('id', $_GET, '');

	// invalid page entry
	$cookieid = $_GET['id'];
	if (trim($cookieid) == ''){
		fRedirect('register.php');
		fCleanup();
	}

	// select transaction
	$aRequest = array();
	$aRequest['cookie_transaction_id'] = '="' . $cookieid . '"';
	$fmrTransaction = fFMPerformFind('petsafe', 'All Fields - Web_Payments', $aRequest);
	if ($fmrTransaction === FALSE || $fmrTransaction["response"]["dataInfo"]["foundCount"] < 1){
		// redirect to error when transaction not found
		fRedirect('register_error.php');
		fCleanup();
	} 
	$fmcTransaction = $fmrTransaction["response"]["data"];

	$emailsent = ',';
	
	foreach ($fmcTransaction as $trans_record){
		$email = $trans_record['fieldData']['owner_email'];
		$name = $trans_record['fieldData']['owner_title'] . ' ' . $trans_record['fieldData']['owner_first_name'] . ' ' . $trans_record['fieldData']['owner_last_name'];
		$password = $trans_record['fieldData']['owner_password'];
		$newrecordid = $trans_record['fieldData']['_pk_record_id'];
		
		$aUpdate = array();
		$aUpdate['transaction_finish'] = fGetFMTimeStamp();
		$fmrTransactionUpdate = fFMPerformUpdate('petsafe', 'All Fields - Web_Payments', $trans_record['recordId'], $aUpdate);

        if(strtoupper($_SESSION['rego_type']) == 'BREEDER'){
            $script = fFMExecuteScript('petsafe', '[OPS] process web transaction breeder', $newrecordid, 'All Fields - Web_Payments');
        }else{
            $script = fFMExecuteScript('petsafe', '[OPS] process web transaction', $newrecordid, 'All Fields - Web_Payments' );
        }
        
        // Get generated member id
        $fmrTransaction = fFMPerformFind('petsafe', 'All Fields - Web_Payments', $aRequest);
        if ($fmrTransaction === FALSE || $fmrTransaction["response"]["dataInfo"]["foundCount"] < 1){
            // redirect to error when transaction not found
            fRedirect('register_error.php');
            fCleanup();
        } 
        
        $fmcTransaction = $fmrTransaction["response"]["data"][0];
        $new_member_id = $fmcTransaction['fieldData']['generated_member_id'];
		
		//Get chip no for audit
        $chip_no = $fmcTransaction['fieldData']['microchip_no'];
		
		//Get tag no for audit
        $tag_no = $fmcTransaction['fieldData']['petsafe_no'];

		$lb = "<br/><br/>";
        // send email confirmation - new rego details
		if ($email != ''){
			if (strpos(strtolower($emailsent),strtolower(',' . $email . ',')) === FALSE){
				
                $headers = "From: " . $gaFM['petsafe']['email'] . "\r\n" . "X-Mailer: php";
				$to = $email;
				$subject = "Your PetSafe Registration was successful";
                
		$body = <<<BODY
Hi $name,<br>
<br>
Your PetSafe Member ID and password details are as follows.<br>
<br>
Member ID:<b>$new_member_id</b><br>
Password:<b>$password</b><br>
<br>
If you did not receive your Petsafe certificate in the accompanying email you should check your spam/junk and trash folder<br>
<br>
If you cannot find it go to <a href="www.petsafe.com.au" target="_blank">www.petsafe.com.au</a> and login using the Member number and password above and print your certificate<br>
<br>
Keep a copy of your certificate in a safe place.<br>
In some States may need to show the certificate to your local council to prove registration on a lost and found database<br>
<br>
Please ensure that you keep your contact information up to date when you move or change phone numbers.<br>
You can make as many updates (ex ownership) as you like online for free.. i.e. when you go on holidays.<br>
<br>
<h4>Change of Petsafe Ownership Access</h4>
Change of Petsafe data Ownership cannot be completed online and must be notified in writing using our form<br>
The Form and should be signed by both the former owner and the new owner.<br>
If the former owner is not contactable for some reason complete the form with your details and send it to us.<br>
We will attempt to obtain consent from the owner as recorded on our records and will give them three working weeks to respond.<br>
If the original owner is uncontactable we will change ownership to your name after the three week period.<br>
In the event of a dispute we will freeze the Petsafe data pending a solution to the dispute.<br>
<br>
Download form <a href="/forms/Petsafe_Change_Owner.pdf" target="_blank">here</a>
<br>		
BODY;

                
                if (send_mail($subject, $body, $to, array())) {}
			}
		}

		$emailsent = $emailsent . $email . ',';

		// ADD TO LOG: confirmed new registration
		if ($_SESSION['VetID'] != '') {
			$aInsert = array();
			$aInsert['_sk_vet_id'] = $_SESSION['VetID'];
			$aInsert['_sk_chip_no'] = $chip_no;
			$aInsert['_sk_tag_no'] = $tag_no;
			$aInsert['description'] = 'Confirmed new registration.';
			$aInsert['is_web_admin_login'] = isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0;
			$fmrLog = fFMPerformInsert('petsafe', 'Web - Audit', $aInsert);
            
		} else if ($_SESSION['MemberID'] != '') {
			$aInsert = array();
			$aInsert['_sk_member_id'] = $_SESSION['MemberID'];
			$aInsert['_sk_chip_no'] = $chip_no;
			$aInsert['_sk_tag_no'] = $tag_no;
			$aInsert['description'] = 'Confirmed new registration.';
			$aInsert['is_web_admin_login'] = isset($_SESSION['IsAdminLogin']) ? $_SESSION['IsAdminLogin'] : 0;
			$fmrLog = fFMPerformInsert('petsafe', 'Web - Audit', $aInsert);
		}
	}

	// redirect to confirmation
	fRedirect('register_thanks.php?id=' . $cookieid);
	fCleanup();
?>
