<?php
	/***********************************************************************************
	*   Filename    : index.php
	*   Description : Petsafe Index/Home page
	*
	*   Date        Modification By      Description
	*   20/10/2008  Shane Schokman       Initial Creation
	*   23/01/2009  Kenneth Ho           Adaptation to Digivet-Petsafe
	*   22/08/2022  John Muffett         Reworked for Data API
	*   24/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

	/******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';


	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';
	$gaPage['onload'] = 'document.frmlogin.vetid.focus();';


    /********************* Page Defaults *********************/
	fDefaultParameter('err_code', $_GET, '');
	$err_code = $_GET['err_code'];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>
<script language="JavaScript" type="text/javascript"><!--
	function checkform(myform)
	{
		if (myform.elements['vetid'].value == '')
		{
			alert('Please enter your vet login number or implanter number or e-mail address.');
			myform.elements['vetid'].focus();
			return false;
		}

		if (myform.elements['state'].selectedIndex == 0)
		{
			alert('Please select your state.');
			myform.elements['state'].focus();
			return false;
		}

		if (myform.elements['password'].value == '')
		{
			alert('Please enter your password.');
			myform.elements['password'].focus();
			return false;
		}

		return true;
	}
//--></script>

<style>
    .login-form-table tr td{
        vertical-align: middle;
    }
</style>
</head>

<?php

require '../phpobjects/templates/common/page_header.php';
/*********************** Page Start **********************/
?>

<td valign="top">

<?php
    /************ Only allow non-logged in users to login ************/

	if ($_SESSION['LoggedIn'] != 0){
		// Redirect
		fRedirect('index.php?err_code=LoggedIn');
		fCleanup();
	}

	echo '<br/><h2 class="orangeheading">Vet / Pound Login</h2>';

if ($err_code == 'Incorrect'){
	echo '<p style="color: red">The login / password you entered is incorrect.<br/>' .
		'Please try again.</p>';
}
?>

<form action="vetlogin_submit.php" method="post" name="frmlogin" id="frmlogin" onsubmit="return checkform(this);">
<table border="0" width="90%" cellspacing="0" cellpadding="2" class="login-form-table">
	<tr>
		<td valign="top" align="right" nowrap="nowrap">Vet License # / Implanter #:</td>
		<td valign="top"><input type="text" size="30" value="" name="vetid" /></td>
	</tr>
	<tr>
		<td valign="top" align="right" nowrap="nowrap">State:</td>
		<td valign="top"><select name="state" style="width: 80px;">
                <option value="" selected>-- Select -- </option>
                <option value="ACT">ACT</option>
				<option value="NSW">NSW</option>
				<option value="NT">NT</option>
                <option value="QLD">QLD</option>
                <option value="SA">SA</option>
                <option value="TAS">TAS</option>
				<option value="VIC">VIC</option>
                <option value="WA">WA</option>
		</select></td>
	</tr>
	<tr>
		<td valign="top" align="right" nowrap="nowrap">Password:</td>
		<td valign="top"><input type="password" size="20" value="" name="password" /></td>
	</tr>
	<tr>
		<td valign="top">&nbsp;</td>
		<td valign="top">
			<br/><input type="submit" value="  Login  " class="button" />
		</td>
	</tr>
</table>
</form>

<br/><hr />

<form action="forgotpass.php" method="post" name="frmpass" id="frmpass">
<a name="forgotpass"><div class="boldtext">Forgotten your Password?</div><br/></a>
Enter License # / Implanter #:
&nbsp;&nbsp;
<input type="text" size="20" value="" name="user_id" />
&nbsp;&nbsp;
<input type="hidden" name="usertype" value="vet" />
<input type="submit" value="Submit" class="button" />
</form>

<?php
if ($err_code == 'EmailSent'){
	echo '<p style="color: green">Your login details have been sent to the e-mail address linked to the ID provided.</p>';
} else if ($err_code == 'InvalidID'){
	echo '<p style="color: red">No email address is linked to the ID provided.</p>';
}
?>

<hr />

<br/><br/>
<div>If you are an authorised person and have not registered with a new user name and password to access this site please download an application form on the forms page and email or post it to Petsafe.</div>

<br/><br/>


<div><img src="<?php echo $gaPage['root_directory']; ?>/images/petsafe_com_au.jpg" />&nbsp;</div>

</td>

<td valign="top">
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/vet_cat.jpg" />&nbsp;</div>
</td>



<?php
/************************ Page End ***********************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>