<?php
    /***********************************************************************************
	*   Filename    : vets.php
	*   Description : Petsafe Participating Vets page
	*
	*   Date        Modification By      Description
	*   25/01/2009  Kenneth Ho           Initial Creation
	*   22/08/2022  John Muffett         Reworked for Data API
	*   16/07/2025  John Muffett         Reworked for oData API
	*
	*   Copyright Keysoft Pty Ltd 2025
	***********************************************************************************/

    /******************** Global Settings ********************/
	require_once '../phpobjects/common/global.php';

	/********************* Page Settings *********************/
	$gaPage['title'] = 'Petsafe.com.au - Participating Vets';
	$gaPage['root_directory'] = '..';
	$gaPage['colour'] = 'orange';

     /********************* Page Defaults *********************/
    fDefaultParameter('err_code', $_GET, '');
	$err_code = $_GET['err_code'];
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head>
<?php require '../phpobjects/templates/common/page_head.php'; ?>

<script language="JavaScript" type="text/javascript">
	function valFormSS(myform)
	{
		if (myform.elements['state'].value == 'Not Selected')
		{
			alert('You must choose a state. (i.e. NSW)');
			myform.elements['state'].focus();
            return false;
		}

        return true;
    }

    function valFormSPC(myform)
    {
        if (myform.elements['postcode'].value == '')
        {
          	alert('You must enter a Postcode. (i.e. 2000)');
            myform.elements['postcode'].focus();
            myform.elements['postcode'].select();
            return false;

        }

        if (myform.elements['postcode'].value != '' &&
                 myform.elements['postcode'].value.length > 4)
        {
            alert('You must enter a valid Postcode. (i.e 2000)');
			myform.elements['postcode'].focus();
            myform.elements['postcode'].select();
			return false;
        }

		return true;
	}
</script>
</head>

<?php
    require '../phpobjects/templates/common/page_header.php';

    /*************************** Page Start ***************************/
?>

<td valign="top">

<br/>
<h2 class="orangeheading">Participating Vets</h2>

<div>A regularly updated on-line directory of recommended Petsafe vet clinics with their addresses & telephone numbers.
We know these professionals will give your pet the best possible chance of returning home when lost.</div>

        <br/><br/>

        <!--------- FORM 1: SEARCH VET BY STATE --------->
        <form name="searchstate" action="vetsearchresults.php" method="get" onSubmit="return valFormSS(this)">
            <table width="100%" border="0" cellspacing="0" cellpadding="2">
            <tr>
                <td width="300">Select your state from the drop down box<br/>
					at the right and click &quot;Go&quot;</td>
                <td>
                <select name="state">
                <option value="Not Selected" selected>-- Select -- </option>
                <option value="ACT">ACT</option>
				<option value="NSW">NSW</option>
				<option value="NT">NT</option>
                <option value="QLD">QLD</option>
                <option value="SA">SA</option>
                <option value="TAS">TAS</option>
				<option value="VIC">VIC</option>
                <option value="WA">WA</option>
                </select>
                <input type="submit" value="Go" class="button" />
				<?php if ($err_code == 'VetCompaniesStateNotFound'){
					echo '<br/><span style="color:red">No vets were found in the selected state.</span>';
				}
				?>
				</td>
            </tr>
            <tr><td colspan="2"><br/><div style="font-weight: bold;">OR</div></td></tr>
            </table>
        </form>


        <!--------- FORM 2: SEARCH VET BY POSTCODE --------->
        <form name="searchpostcode" action="vetsearchresults.php" method="get" onSubmit="return valFormSPC(this)">
        <table width="100%" border="0" cellspacing="0" cellpadding="2">
            <tr>
                <td width="300">Enter the Postcode you want to search for<br/>
					in the box and click &quot;Go&quot;</td>
                <td>
                <input name="postcode" maxlength="4" type="text" class="field" title="postcode" size="5"/>
                <input type="submit" value="Go" class="button" />
				<?php if ($err_code == 'VetCompaniesPostcodeNotFound'){
					echo '<br/><span style="color:red">No vets were found in that postcode.</span>';
				}
				?>
				</td>
            </tr>
            </table>
        </form>

<br/><br/><br/><br/><br/><br/><br/><br/><br/><br/>



<div><img src="<?php echo $gaPage['root_directory']; ?>/images/petsafe_com_au.jpg" />&nbsp;</div></td>

<td valign="top">
<div><img align="right" src="<?php echo $gaPage['root_directory']; ?>/images/locate_vets.jpg" />&nbsp;</div>
</td>

<?php
/************************* Page End **************************/

require '../phpobjects/templates/common/page_footer.php';
?>

</html>
<?php fCleanup(); ?>